/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.view.View;
import android.view.ViewParent;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyHolder;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyModelWithHolder;
import com.airbnb.epoxy.GeneratedModel;
import com.airbnb.epoxy.ViewHolderState;
import java.util.List;

public class EpoxyViewHolder
extends RecyclerView.ViewHolder {
    private EpoxyModel epoxyModel;
    private List<Object> payloads;
    private EpoxyHolder epoxyHolder;
    @Nullable
    ViewHolderState.ViewState initialViewState;
    private ViewParent parent;

    public EpoxyViewHolder(ViewParent parent, View view, boolean saveInitialState) {
        super(view);
        this.parent = parent;
        if (saveInitialState) {
            this.initialViewState = new ViewHolderState.ViewState();
            this.initialViewState.save(this.itemView);
        }
    }

    void restoreInitialViewState() {
        if (this.initialViewState != null) {
            this.initialViewState.restore(this.itemView);
        }
    }

    public void bind(EpoxyModel model, @Nullable EpoxyModel<?> previouslyBoundModel, List<Object> payloads, int position) {
        this.payloads = payloads;
        if (this.epoxyHolder == null && model instanceof EpoxyModelWithHolder) {
            this.epoxyHolder = ((EpoxyModelWithHolder)model).createNewHolder(this.parent);
            this.epoxyHolder.bindView(this.itemView);
        }
        this.parent = null;
        if (model instanceof GeneratedModel) {
            ((GeneratedModel)((Object)model)).handlePreBind(this, this.objectToBind(), position);
        }
        if (previouslyBoundModel != null) {
            model.bind(this.objectToBind(), previouslyBoundModel);
        } else if (payloads.isEmpty()) {
            model.bind(this.objectToBind());
        } else {
            model.bind(this.objectToBind(), payloads);
        }
        if (model instanceof GeneratedModel) {
            ((GeneratedModel)((Object)model)).handlePostBind(this.objectToBind(), position);
        }
        this.epoxyModel = model;
    }

    @NonNull
    Object objectToBind() {
        return this.epoxyHolder != null ? this.epoxyHolder : this.itemView;
    }

    public void unbind() {
        this.assertBound();
        this.epoxyModel.unbind(this.objectToBind());
        this.epoxyModel = null;
        this.payloads = null;
    }

    public void visibilityStateChanged(int visibilityState) {
        this.assertBound();
        this.epoxyModel.onVisibilityStateChanged(visibilityState, this.objectToBind());
    }

    public void visibilityChanged(@FloatRange(from=0.0, to=100.0) float percentVisibleHeight, @FloatRange(from=0.0, to=100.0) float percentVisibleWidth, @Px int visibleHeight, @Px int visibleWidth) {
        this.assertBound();
        this.epoxyModel.onVisibilityChanged(percentVisibleHeight, percentVisibleWidth, visibleHeight, visibleWidth, this.objectToBind());
    }

    public List<Object> getPayloads() {
        this.assertBound();
        return this.payloads;
    }

    public EpoxyModel<?> getModel() {
        this.assertBound();
        return this.epoxyModel;
    }

    public EpoxyHolder getHolder() {
        this.assertBound();
        return this.epoxyHolder;
    }

    private void assertBound() {
        if (this.epoxyModel == null) {
            throw new IllegalStateException("This holder is not currently bound.");
        }
    }

    public String toString() {
        return "EpoxyViewHolder{epoxyModel=" + this.epoxyModel + ", view=" + this.itemView + ", super=" + super.toString() + '}';
    }
}

