/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.util.Log;
import com.airbnb.epoxy.Timer;

class DebugTimer
implements Timer {
    private final String tag;
    private long startTime;
    private String sectionName;

    DebugTimer(String tag) {
        this.tag = tag;
        this.reset();
    }

    private void reset() {
        this.startTime = -1L;
        this.sectionName = null;
    }

    @Override
    public void start(String sectionName) {
        if (this.startTime != -1L) {
            throw new IllegalStateException("Timer was already started");
        }
        this.startTime = System.nanoTime();
        this.sectionName = sectionName;
    }

    @Override
    public void stop() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Timer was not started");
        }
        float durationMs = (float)(System.nanoTime() - this.startTime) / 1000000.0f;
        Log.d((String)this.tag, (String)String.format(this.sectionName + ": %.3fms", Float.valueOf(durationMs)));
        this.reset();
    }
}

