/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor.resourcescanning;

import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XAnnotationValue;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.processor.resourcescanning.ResourceValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u0015H&J(\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013J.\u0010\u0016\u001a\u00020\u00102\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eJ2\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH$J.\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\f2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013J<\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\fH$J\u001e\u0010#\u001a\u0004\u0018\u00010$*\u00020\u001b2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;", "", "environmentProvider", "Lkotlin/Function0;", "Landroidx/room/compiler/processing/XProcessingEnv;", "(Lkotlin/jvm/functions/Function0;)V", "getEnvironmentProvider", "()Lkotlin/jvm/functions/Function0;", "mutableRClasses", "", "Lcom/squareup/javapoet/ClassName;", "rClassNames", "", "getRClassNames", "()Ljava/util/List;", "getAlternateLayouts", "Lcom/airbnb/epoxy/processor/resourcescanning/ResourceValue;", "layout", "getImports", "", "classElement", "Landroidx/room/compiler/processing/XTypeElement;", "getResourceValue", "annotation", "Lkotlin/reflect/KClass;", "", "element", "Landroidx/room/compiler/processing/XElement;", "property", "value", "", "getResourceValueInternal", "getResourceValueList", "getResourceValueListInternal", "values", "getXAnnotation", "Landroidx/room/compiler/processing/XAnnotation;", "epoxy-processor"})
public abstract class ResourceScanner {
    @NotNull
    private final Function0<XProcessingEnv> environmentProvider;
    @NotNull
    private final Set<ClassName> mutableRClasses;

    public ResourceScanner(@NotNull Function0<? extends XProcessingEnv> environmentProvider) {
        Intrinsics.checkNotNullParameter(environmentProvider, (String)"environmentProvider");
        this.environmentProvider = environmentProvider;
        this.mutableRClasses = new LinkedHashSet();
    }

    @NotNull
    public final Function0<XProcessingEnv> getEnvironmentProvider() {
        return this.environmentProvider;
    }

    @NotNull
    public final List<ClassName> getRClassNames() {
        return CollectionsKt.toList((Iterable)this.mutableRClasses);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ResourceValue getResourceValue(@NotNull KClass<? extends Annotation> annotation, @NotNull XElement element, @NotNull String property) {
        Object v1;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            XAnnotation xAnnotation = this.getXAnnotation(element, annotation);
            if (xAnnotation == null) {
                return null;
            }
            XAnnotation xAnnotation2 = xAnnotation;
            Iterable iterable = xAnnotation2.getAnnotationValues();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XAnnotationValue it = (XAnnotationValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)property)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        XAnnotationValue xAnnotationValue = v1;
        Object object = xAnnotationValue != null ? xAnnotationValue.getValue() : null;
        Integer n = object instanceof Integer ? (Integer)object : null;
        if (n == null) {
            return null;
        }
        int value = n;
        return this.getResourceValue(annotation, element, property, value);
    }

    private final XAnnotation getXAnnotation(XElement $this$getXAnnotation, KClass<? extends Annotation> annotation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getXAnnotation.getAllAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XAnnotation it = (XAnnotation)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)annotation.getSimpleName()) && Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)annotation.getQualifiedName()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final ResourceValue getResourceValue(@NotNull KClass<? extends Annotation> annotation, @NotNull XElement element, @NotNull String property, int value) {
        ResourceValue resourceValue;
        ResourceValue resourceValue2;
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        ResourceValue resourceValue3 = resourceValue2 = this.getResourceValueInternal(annotation, element, property, value);
        boolean bl = false;
        ResourceValue resourceValue4 = resourceValue3;
        if (resourceValue4 != null && (resourceValue4 = resourceValue4.getClassName()) != null) {
            ResourceValue it = resourceValue4;
            boolean bl2 = false;
            this.mutableRClasses.add((ClassName)it);
        }
        if ((resourceValue = resourceValue2) == null) {
            resourceValue = new ResourceValue(value);
        }
        return resourceValue;
    }

    @Nullable
    public final List<ResourceValue> getResourceValueList(@NotNull KClass<? extends Annotation> annotation, @NotNull XElement element, @NotNull String property) {
        Object v1;
        List $this$firstOrNull$iv;
        block4: {
            Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            XAnnotation xAnnotation = this.getXAnnotation(element, annotation);
            if (xAnnotation == null) {
                return null;
            }
            XAnnotation xAnnotation2 = xAnnotation;
            Iterable iterable = xAnnotation2.getAnnotationValues();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XAnnotationValue it = (XAnnotationValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)property)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Object object = v1;
        if (object == null || ($this$firstOrNull$iv = object.asIntList()) == null) {
            return null;
        }
        List values = $this$firstOrNull$iv;
        Object list = object = this.getResourceValueListInternal(annotation, element, property, values);
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassName it;
            ResourceValue resourceValue = (ResourceValue)element$iv;
            boolean bl2 = false;
            if (resourceValue.getRClass() == null) continue;
            boolean bl3 = false;
            this.mutableRClasses.add(it);
        }
        return object;
    }

    @NotNull
    protected abstract List<ResourceValue> getResourceValueListInternal(@NotNull KClass<? extends Annotation> var1, @NotNull XElement var2, @NotNull String var3, @NotNull List<Integer> var4);

    @Nullable
    protected abstract ResourceValue getResourceValueInternal(@NotNull KClass<? extends Annotation> var1, @NotNull XElement var2, @NotNull String var3, int var4);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceValue> getAlternateLayouts(@NotNull ResourceValue layout) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        ClassName className = layout.getClassName();
        if (className == null) {
            return CollectionsKt.emptyList();
        }
        ClassName layoutClassName = className;
        XTypeElement rLayoutClassElement = ((XProcessingEnv)this.environmentProvider.invoke()).requireTypeElement((TypeName)layoutClassName);
        String target = layout.getResourceName() + '_';
        Iterable iterable = rLayoutClassElement.getDeclaredFields();
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            XFieldElement xFieldElement = (XFieldElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)target, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResourceValue(layout.getClassName(), it, 0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public abstract List<String> getImports(@NotNull XTypeElement var1);
}

