/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import com.airbnb.epoxy.processor.LoggerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJJ\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\tH\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\n\u0010\u000fR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/airbnb/epoxy/processor/Timing;", "", "name", "", "durationMs", "", "nestedTimings", "", "itemCount", "", "isParallel", "", "(Ljava/lang/String;JLjava/util/List;Ljava/lang/Integer;Ljava/lang/Boolean;)V", "getDurationMs", "()J", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getItemCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getName", "()Ljava/lang/String;", "getNestedTimings", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;JLjava/util/List;Ljava/lang/Integer;Ljava/lang/Boolean;)Lcom/airbnb/epoxy/processor/Timing;", "equals", "other", "hashCode", "toString", "nesting", "epoxy-processor"})
public final class Timing {
    @NotNull
    private final String name;
    private final long durationMs;
    @NotNull
    private final List<Timing> nestedTimings;
    @Nullable
    private final Integer itemCount;
    @Nullable
    private final Boolean isParallel;

    public Timing(@NotNull String name, long durationMs, @NotNull List<Timing> nestedTimings, @Nullable Integer itemCount, @Nullable Boolean isParallel) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(nestedTimings, (String)"nestedTimings");
        this.name = name;
        this.durationMs = durationMs;
        this.nestedTimings = nestedTimings;
        this.itemCount = itemCount;
        this.isParallel = isParallel;
    }

    public /* synthetic */ Timing(String string, long l, List list, Integer n, Boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = null;
        }
        this(string, l, list, n, bl);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getDurationMs() {
        return this.durationMs;
    }

    @NotNull
    public final List<Timing> getNestedTimings() {
        return this.nestedTimings;
    }

    @Nullable
    public final Integer getItemCount() {
        return this.itemCount;
    }

    @Nullable
    public final Boolean isParallel() {
        return this.isParallel;
    }

    @NotNull
    public final String toString(int nesting) {
        if (this.durationMs == 0L) {
            return "";
        }
        String parallel = Intrinsics.areEqual((Object)this.isParallel, (Object)true) ? "in parallel" : "";
        String items = this.itemCount != null ? "" + '(' + this.itemCount + " items " + parallel + ')' : "";
        String indent = StringsKt.repeat((CharSequence)"  ", (int)nesting);
        return indent + this.name + ": " + this.durationMs + " ms " + items + '\n' + LoggerKt.access$joinToString(this.nestedTimings, nesting + 1);
    }

    public static /* synthetic */ String toString$default(Timing timing, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return timing.toString(n);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final long component2() {
        return this.durationMs;
    }

    @NotNull
    public final List<Timing> component3() {
        return this.nestedTimings;
    }

    @Nullable
    public final Integer component4() {
        return this.itemCount;
    }

    @Nullable
    public final Boolean component5() {
        return this.isParallel;
    }

    @NotNull
    public final Timing copy(@NotNull String name, long durationMs, @NotNull List<Timing> nestedTimings, @Nullable Integer itemCount, @Nullable Boolean isParallel) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(nestedTimings, (String)"nestedTimings");
        return new Timing(name, durationMs, nestedTimings, itemCount, isParallel);
    }

    public static /* synthetic */ Timing copy$default(Timing timing, String string, long l, List list, Integer n, Boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = timing.name;
        }
        if ((n2 & 2) != 0) {
            l = timing.durationMs;
        }
        if ((n2 & 4) != 0) {
            list = timing.nestedTimings;
        }
        if ((n2 & 8) != 0) {
            n = timing.itemCount;
        }
        if ((n2 & 0x10) != 0) {
            bl = timing.isParallel;
        }
        return timing.copy(string, l, list, n, bl);
    }

    @NotNull
    public String toString() {
        return "Timing(name=" + this.name + ", durationMs=" + this.durationMs + ", nestedTimings=" + this.nestedTimings + ", itemCount=" + this.itemCount + ", isParallel=" + this.isParallel + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + Long.hashCode(this.durationMs);
        result = result * 31 + ((Object)this.nestedTimings).hashCode();
        result = result * 31 + (this.itemCount == null ? 0 : ((Object)this.itemCount).hashCode());
        result = result * 31 + (this.isParallel == null ? 0 : ((Object)this.isParallel).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Timing)) {
            return false;
        }
        Timing timing = (Timing)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)timing.name)) {
            return false;
        }
        if (this.durationMs != timing.durationMs) {
            return false;
        }
        if (!Intrinsics.areEqual(this.nestedTimings, timing.nestedTimings)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.itemCount, (Object)timing.itemCount)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.isParallel, (Object)timing.isParallel);
    }
}

