/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XArrayType;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XEnumEntryKt;
import androidx.room.compiler.processing.XEnumTypeElementKt;
import androidx.room.compiler.processing.XMemberContainer;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.XTypeKt;
import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.EpoxyProcessorException;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.XProcessingUtilsKt;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0015H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/airbnb/epoxy/processor/HashCodeValidator;", "", "environment", "Landroidx/room/compiler/processing/XProcessingEnv;", "memoizer", "Lcom/airbnb/epoxy/processor/Memoizer;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "(Landroidx/room/compiler/processing/XProcessingEnv;Lcom/airbnb/epoxy/processor/Memoizer;Lcom/airbnb/epoxy/processor/Logger;)V", "getLogger", "()Lcom/airbnb/epoxy/processor/Logger;", "hasEqualsInClassHierarchy", "", "clazz", "Landroidx/room/compiler/processing/XTypeElement;", "hasFunctionInClassHierarchy", "function", "Lcom/squareup/javapoet/MethodSpec;", "hasHashCodeInClassHierarchy", "implementsHashCodeAndEquals", "mirror", "Landroidx/room/compiler/processing/XType;", "isAutoValueType", "element", "isWhiteListedType", "validate", "", "attribute", "Lcom/airbnb/epoxy/processor/AttributeInfo;", "validateArrayType", "Landroidx/room/compiler/processing/XArrayType;", "validateImplementsHashCode", "xType", "validateIterableType", "type", "Companion", "epoxy-processor"})
public final class HashCodeValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XProcessingEnv environment;
    @NotNull
    private final Memoizer memoizer;
    @NotNull
    private final Logger logger;
    private static final MethodSpec HASH_CODE_METHOD = MethodSpec.methodBuilder((String)"hashCode").returns(TypeName.INT).build();
    private static final MethodSpec EQUALS_METHOD = MethodSpec.methodBuilder((String)"equals").addParameter((TypeName)TypeName.OBJECT, "obj", new Modifier[0]).returns(TypeName.BOOLEAN).build();

    public HashCodeValidator(@NotNull XProcessingEnv environment, @NotNull Memoizer memoizer, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.environment = environment;
        this.memoizer = memoizer;
        this.logger = logger2;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final boolean implementsHashCodeAndEquals(@NotNull XType mirror) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        try {
            this.validateImplementsHashCode(mirror);
            bl = true;
        }
        catch (EpoxyProcessorException e) {
            bl = false;
        }
        return bl;
    }

    public final void validate(@NotNull AttributeInfo attribute) throws EpoxyProcessorException {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        try {
            this.validateImplementsHashCode(attribute.getXType());
        }
        catch (EpoxyProcessorException e) {
            Object[] objectArray = new Object[]{attribute};
            this.logger.logError(e.getMessage() + " (%s) Epoxy requires every model attribute to implement equals and hashCode so that changes in the model can be tracked. If you want the attribute to be excluded, use the option 'DoNotHash'. If you want to ignore this warning use the option 'IgnoreRequireHashCode'", objectArray);
        }
    }

    private final void validateImplementsHashCode(XType xType) throws EpoxyProcessorException {
        if (xType.isError()) {
            return;
        }
        if (xType.getTypeName().isPrimitive() || xType.getTypeName().isBoxedPrimitive()) {
            return;
        }
        if (XTypeKt.isArray((XType)xType)) {
            this.validateArrayType((XArrayType)xType);
            return;
        }
        XTypeElement xTypeElement = xType.getTypeElement();
        if (xTypeElement == null) {
            return;
        }
        XTypeElement xTypeElement2 = xTypeElement;
        if (xTypeElement2.isDataClass() || XEnumTypeElementKt.isEnum((XTypeElement)xTypeElement2) || XEnumEntryKt.isEnumEntry((XElement)((XElement)xTypeElement2)) || xTypeElement2.isValueClass()) {
            return;
        }
        if (Utils.INSTANCE.isMap(xType, this.environment)) {
            return;
        }
        if (Utils.isIterableType(xType, this.memoizer)) {
            this.validateIterableType(xType);
            return;
        }
        if (this.isAutoValueType(xTypeElement2)) {
            return;
        }
        if (this.isWhiteListedType(xTypeElement2)) {
            return;
        }
        if (!this.hasHashCodeInClassHierarchy(xTypeElement2)) {
            Utils.throwError("Attribute does not implement hashCode", new Object[0]);
        }
        if (!this.hasEqualsInClassHierarchy(xTypeElement2)) {
            Utils.throwError("Attribute does not implement equals", new Object[0]);
        }
    }

    private final boolean hasHashCodeInClassHierarchy(XTypeElement clazz) {
        MethodSpec methodSpec = HASH_CODE_METHOD;
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"HASH_CODE_METHOD");
        return this.hasFunctionInClassHierarchy(clazz, methodSpec);
    }

    private final boolean hasEqualsInClassHierarchy(XTypeElement clazz) {
        MethodSpec methodSpec = EQUALS_METHOD;
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"EQUALS_METHOD");
        return this.hasFunctionInClassHierarchy(clazz, methodSpec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasFunctionInClassHierarchy(XTypeElement clazz, MethodSpec function) {
        XTypeElement implementingClass;
        XMethodElement xMethodElement = Utils.getMethodOnClass(clazz, function, this.environment);
        if (xMethodElement == null) {
            return false;
        }
        XMethodElement methodOnClass = xMethodElement;
        XMemberContainer xMemberContainer = methodOnClass.getEnclosingElement();
        XTypeElement xTypeElement = implementingClass = xMemberContainer instanceof XTypeElement ? (XTypeElement)xMemberContainer : null;
        if (Intrinsics.areEqual((Object)(xTypeElement != null ? xTypeElement.getName() : null), (Object)"Object")) return false;
        XTypeElement xTypeElement2 = implementingClass;
        XTypeElement xTypeElement3 = xTypeElement2;
        if (xTypeElement2 == null) return true;
        XType xType = xTypeElement3.getType();
        xTypeElement3 = xType;
        if (xType == null) return true;
        if (!XProcessingUtilsKt.isObjectOrAny((XType)xTypeElement3)) return true;
        return false;
    }

    private final void validateArrayType(XArrayType mirror) throws EpoxyProcessorException {
        XType arrayType = mirror.getComponentType();
        try {
            this.validateImplementsHashCode(arrayType);
        }
        catch (EpoxyProcessorException e) {
            Object[] objectArray = new Object[]{arrayType.toString()};
            Utils.throwError("Type in array does not implement hashCode. Type: %s", objectArray);
        }
    }

    private final void validateIterableType(XType type) throws EpoxyProcessorException {
        for (XType typeParameter : type.getTypeArguments()) {
            try {
                this.validateImplementsHashCode(typeParameter);
            }
            catch (EpoxyProcessorException e) {
                Object[] objectArray = new Object[]{typeParameter.toString()};
                Utils.throwError("Type in Iterable does not implement hashCode. Type: %s", objectArray);
            }
        }
    }

    private final boolean isWhiteListedType(XTypeElement element) {
        return XProcessingUtilsKt.isSubTypeOf(element, this.memoizer.getCharSequenceType());
    }

    private final boolean isAutoValueType(XTypeElement element) {
        if (element.isAbstract() && !element.isInterface()) {
            return true;
        }
        for (XAnnotation xAnnotation : element.getAllAnnotations()) {
            boolean isAutoValue = Intrinsics.areEqual((Object)xAnnotation.getName(), (Object)"AutoValue");
            if (!isAutoValue) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/airbnb/epoxy/processor/HashCodeValidator$Companion;", "", "()V", "EQUALS_METHOD", "Lcom/squareup/javapoet/MethodSpec;", "kotlin.jvm.PlatformType", "HASH_CODE_METHOD", "epoxy-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

