/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.resourcescanning.ResourceScanner;
import com.squareup.javapoet.ClassName;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/airbnb/epoxy/processor/DataBindingModuleLookup;", "", "environment", "Landroidx/room/compiler/processing/XProcessingEnv;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "resourceProcessor", "Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;", "(Landroidx/room/compiler/processing/XProcessingEnv;Lcom/airbnb/epoxy/processor/Logger;Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;)V", "getModuleName", "", "element", "Landroidx/room/compiler/processing/XTypeElement;", "getModuleNameViaGuessing", "packageName", "getModuleNameViaResources", "epoxy-processor"})
public final class DataBindingModuleLookup {
    @NotNull
    private final XProcessingEnv environment;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ResourceScanner resourceProcessor;

    public DataBindingModuleLookup(@NotNull XProcessingEnv environment, @NotNull Logger logger2, @NotNull ResourceScanner resourceProcessor2) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resourceProcessor2, (String)"resourceProcessor");
        this.environment = environment;
        this.logger = logger2;
        this.resourceProcessor = resourceProcessor2;
    }

    @NotNull
    public final String getModuleName(@NotNull XTypeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String packageName = element.getPackageName();
        String moduleName = this.getModuleNameViaResources(packageName);
        if (moduleName == null) {
            moduleName = this.getModuleNameViaGuessing(packageName);
        }
        if (moduleName == null) {
            this.logger.logError("Could not find module name for DataBinding BR class.", new Object[0]);
            moduleName = packageName;
        }
        return moduleName;
    }

    private final String getModuleNameViaResources(String packageName) {
        List<ClassName> rClasses = this.resourceProcessor.getRClassNames();
        if (rClasses.isEmpty()) {
            return packageName;
        }
        if (rClasses.size() == 1) {
            String string = rClasses.get(0).packageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rClasses[0].packageName()");
            return string;
        }
        String[] stringArray = new String[]{"\\."};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)packageName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] packageNames = stringArray2;
        ClassName bestMatch = null;
        int bestNumMatches = -1;
        for (ClassName rClass : rClasses) {
            String[] rModuleNames;
            String string = rClass.packageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rClass.packageName()");
            String[] stringArray3 = new String[]{"\\."};
            Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)string, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            Intrinsics.checkNotNull((Object)thisCollection$iv2.toArray(new String[0]), (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            int numNameMatches = 0;
            int n = Math.min(packageNames.length, rModuleNames.length);
            for (int i = 0; i < n && Intrinsics.areEqual((Object)packageNames[i], (Object)rModuleNames[i]); ++i) {
                ++numNameMatches;
            }
            if (numNameMatches <= bestNumMatches) continue;
            bestMatch = rClass;
        }
        ClassName className = bestMatch;
        Intrinsics.checkNotNull(className);
        String string = className.packageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bestMatch!!.packageName()");
        return string;
    }

    private final String getModuleNameViaGuessing(String packageName) {
        String[] stringArray = new String[]{"\\."};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)packageName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] packageNameParts = stringArray2;
        String moduleName = "";
        int n = packageNameParts.length;
        for (int i = 0; i < n; ++i) {
            XType rClass = this.environment.findType((moduleName = moduleName + packageNameParts[i]) + ".R");
            if (rClass != null) {
                return moduleName;
            }
            moduleName = moduleName + ".";
        }
        return null;
    }
}

