/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.ClassNames;
import com.airbnb.epoxy.processor.DataBindingAttributeInfo;
import com.airbnb.epoxy.processor.GeneratedModelInfo;
import com.airbnb.epoxy.processor.HashCodeValidator;
import com.airbnb.epoxy.processor.KotlinUtilsKt;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.resourcescanning.ResourceValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\"R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00118BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"Lcom/airbnb/epoxy/processor/DataBindingModelInfo;", "Lcom/airbnb/epoxy/processor/GeneratedModelInfo;", "layoutResource", "Lcom/airbnb/epoxy/processor/resourcescanning/ResourceValue;", "moduleName", "", "layoutPrefix", "enableDoNotHash", "", "annotatedElement", "Landroidx/room/compiler/processing/XElement;", "memoizer", "Lcom/airbnb/epoxy/processor/Memoizer;", "(Lcom/airbnb/epoxy/processor/resourcescanning/ResourceValue;Ljava/lang/String;Ljava/lang/String;ZLandroidx/room/compiler/processing/XElement;Lcom/airbnb/epoxy/processor/Memoizer;)V", "getAnnotatedElement", "()Landroidx/room/compiler/processing/XElement;", "dataBindingClassElement", "Landroidx/room/compiler/processing/XTypeElement;", "getDataBindingClassElement", "()Landroidx/room/compiler/processing/XTypeElement;", "dataBindingClassName", "Lcom/squareup/javapoet/ClassName;", "getEnableDoNotHash", "()Z", "getLayoutResource", "()Lcom/airbnb/epoxy/processor/resourcescanning/ResourceValue;", "getModuleName", "()Ljava/lang/String;", "additionalOriginatingElements", "", "buildGeneratedModelName", "getDataBindingClassNameForResource", "parseDataBindingClass", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "Companion", "epoxy-processor"})
public final class DataBindingModelInfo
extends GeneratedModelInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceValue layoutResource;
    @NotNull
    private final String moduleName;
    @NotNull
    private final String layoutPrefix;
    private final boolean enableDoNotHash;
    @NotNull
    private final XElement annotatedElement;
    @NotNull
    private final ClassName dataBindingClassName;
    @Nullable
    private XTypeElement dataBindingClassElement;
    @NotNull
    public static final String BINDING_SUFFIX = "Binding";
    @NotNull
    private static final List<String> FIELD_NAME_BLACKLIST = CollectionsKt.listOf((Object)"lifecycleOwner");

    public DataBindingModelInfo(@NotNull ResourceValue layoutResource, @NotNull String moduleName, @NotNull String layoutPrefix, boolean enableDoNotHash, @NotNull XElement annotatedElement, @NotNull Memoizer memoizer) {
        Intrinsics.checkNotNullParameter((Object)layoutResource, (String)"layoutResource");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)layoutPrefix, (String)"layoutPrefix");
        Intrinsics.checkNotNullParameter((Object)annotatedElement, (String)"annotatedElement");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        super(memoizer);
        this.layoutResource = layoutResource;
        this.moduleName = moduleName;
        this.layoutPrefix = layoutPrefix;
        this.enableDoNotHash = enableDoNotHash;
        this.annotatedElement = annotatedElement;
        this.dataBindingClassName = this.getDataBindingClassNameForResource(this.layoutResource, this.moduleName);
        XTypeElement xTypeElement = memoizer.getEpoxyDataBindingModelBaseClass();
        if (xTypeElement == null) {
            throw new IllegalStateException("Epoxy Databinding library not found".toString());
        }
        this.setSuperClassElement(xTypeElement);
        this.setSuperClassName((TypeName)ClassNames.EPOXY_DATA_BINDING_MODEL);
        this.setGeneratedName(this.buildGeneratedModelName());
        this.setParameterizedGeneratedName((TypeName)this.getGeneratedName());
        this.setModelType((TypeName)ClassNames.EPOXY_DATA_BINDING_HOLDER);
        this.setShouldGenerateModel(true);
        this.collectMethodsReturningClassType(this.getSuperClassElement());
    }

    public /* synthetic */ DataBindingModelInfo(ResourceValue resourceValue, String string, String string2, boolean bl, XElement xElement, Memoizer memoizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(resourceValue, string, string2, bl, xElement, memoizer);
    }

    @NotNull
    public final ResourceValue getLayoutResource() {
        return this.layoutResource;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    public final boolean getEnableDoNotHash() {
        return this.enableDoNotHash;
    }

    @NotNull
    public final XElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    private final XTypeElement getDataBindingClassElement() {
        if (this.dataBindingClassElement == null) {
            this.dataBindingClassElement = this.getMemoizer().getEnvironment().findTypeElement((TypeName)this.dataBindingClassName);
        }
        return this.dataBindingClassElement;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final XTypeElement parseDataBindingClass(@NotNull Logger logger2) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        XTypeElement xTypeElement = this.getDataBindingClassElement();
        if (xTypeElement == null) {
            return null;
        }
        XTypeElement dataBindingClassElement = xTypeElement;
        HashCodeValidator hashCodeValidator = new HashCodeValidator(this.getMemoizer().getEnvironment(), this.getMemoizer(), logger2);
        Iterable iterable = dataBindingClassElement.getDeclaredMethods();
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XMethodElement)element$iv$iv;
            boolean bl = false;
            if (!Utils.INSTANCE.isSetterMethod((XElement)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (XMethodElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DataBindingAttributeInfo(this, (XMethodElement)it, hashCodeValidator, this.getMemoizer()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataBindingAttributeInfo)element$iv$iv;
            boolean bl = false;
            if (!(!FIELD_NAME_BLACKLIST.contains(((AttributeInfo)it).getFieldName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it2 = (List)destination$iv$iv;
        boolean bl = false;
        this.addAttributes(it2);
        return dataBindingClassElement;
    }

    private final ClassName getDataBindingClassNameForResource(ResourceValue layoutResource, String moduleName) {
        String string;
        String string2;
        String string3 = layoutResource.getResourceName();
        if (string3 == null || (string2 = KotlinUtilsKt.toUpperCamelCase(string3)) == null || (string = string2 + BINDING_SUFFIX) == null) {
            throw new IllegalStateException(("Resource name not found for layout: " + layoutResource.debugDetails()).toString());
        }
        String modelName = string;
        ClassName className = ClassName.get((String)(moduleName + ".databinding"), (String)modelName, (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(\"$moduleName.databinding\", modelName)");
        return className;
    }

    private final ClassName buildGeneratedModelName() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.layoutResource.getResourceName();
        Intrinsics.checkNotNull((Object)string);
        String modelName = stringBuilder.append(KotlinUtilsKt.toUpperCamelCase(StringsKt.removePrefix((String)string, (CharSequence)this.layoutPrefix))).append("BindingModel_").toString();
        ClassName className = ClassName.get((String)this.moduleName, (String)modelName, (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(moduleName, modelName)");
        return className;
    }

    @Override
    @NotNull
    public List<XElement> additionalOriginatingElements() {
        Object[] objectArray = new XElement[]{this.annotatedElement, (XElement)this.getDataBindingClassElement()};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/airbnb/epoxy/processor/DataBindingModelInfo$Companion;", "", "()V", "BINDING_SUFFIX", "", "FIELD_NAME_BLACKLIST", "", "getFIELD_NAME_BLACKLIST", "()Ljava/util/List;", "epoxy-processor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getFIELD_NAME_BLACKLIST() {
            return FIELD_NAME_BLACKLIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

