/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XRoundEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.PackageEpoxyConfig;
import com.airbnb.epoxy.PackageModelViewConfig;
import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.ControllerClassInfo;
import com.airbnb.epoxy.processor.GeneratedModelInfo;
import com.airbnb.epoxy.processor.ModelViewInfo;
import com.airbnb.epoxy.processor.PackageConfigSettings;
import com.airbnb.epoxy.processor.PackageModelViewSettings;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.ViewAttributeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A2\u00020\u0001:\u0001AB#\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020&H\u0002J\u000e\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u0004J\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010%\u001a\u00020&J\u0010\u0010-\u001a\u0004\u0018\u00010\u00192\u0006\u0010%\u001a\u00020&J\u0012\u0010-\u001a\u0004\u0018\u00010\u00192\b\u0010.\u001a\u0004\u0018\u00010/J\u000e\u00100\u001a\u00020\f2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J\u0018\u00104\u001a\f\u0012\b\u0012\u000606j\u0002`7052\u0006\u00108\u001a\u000209J\u0018\u0010:\u001a\f\u0012\b\u0012\u000606j\u0002`7052\u0006\u00108\u001a\u000209J\u000e\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020&J\u000e\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020\fR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u001c\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00190\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u000e\u0010!\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/airbnb/epoxy/processor/ConfigManager;", "", "options", "", "", "environment", "Landroidx/room/compiler/processing/XProcessingEnv;", "(Ljava/util/Map;Landroidx/room/compiler/processing/XProcessingEnv;)V", "configurationMap", "", "Lcom/airbnb/epoxy/processor/PackageConfigSettings;", "disableDslMarker", "", "getDisableDslMarker", "()Z", "disableGenerateBuilderOverloads", "disableGenerateGetters", "disableGenerateReset", "disableKotlinExtensionGeneration", "globalImplicitlyAddAutoModels", "globalRequireAbstractModels", "globalRequireHashCode", "logTimings", "getLogTimings", "modelViewNamingMap", "Lcom/airbnb/epoxy/processor/PackageModelViewSettings;", "packageEpoxyConfigElements", "", "Landroidx/room/compiler/processing/XElement;", "getPackageEpoxyConfigElements", "()Ljava/util/List;", "packageModelViewConfigElements", "getPackageModelViewConfigElements", "validateModelUsage", "modelInfo", "Lcom/airbnb/epoxy/processor/GeneratedModelInfo;", "generatedModelSuffix", "viewElement", "Landroidx/room/compiler/processing/XTypeElement;", "getConfigurationForElement", "element", "getConfigurationForPackage", "packageName", "getDefaultBaseModel", "Landroidx/room/compiler/processing/XType;", "getModelViewConfig", "modelViewInfo", "Lcom/airbnb/epoxy/processor/ModelViewInfo;", "implicitlyAddAutoModels", "controller", "Lcom/airbnb/epoxy/processor/ControllerClassInfo;", "includeAlternateLayoutsForViews", "processPackageEpoxyConfig", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "roundEnv", "Landroidx/room/compiler/processing/XRoundEnv;", "processPackageModelViewConfig", "requiresAbstractModels", "classElement", "requiresHashCode", "attributeInfo", "Lcom/airbnb/epoxy/processor/AttributeInfo;", "shouldValidateModelUsage", "Companion", "epoxy-processor"})
public final class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XProcessingEnv environment;
    @NotNull
    private final List<XElement> packageEpoxyConfigElements;
    @NotNull
    private final List<XElement> packageModelViewConfigElements;
    @NotNull
    private final Map<String, PackageConfigSettings> configurationMap;
    @NotNull
    private final Map<String, PackageModelViewSettings> modelViewNamingMap;
    private final boolean validateModelUsage;
    private final boolean globalRequireHashCode;
    private final boolean globalRequireAbstractModels;
    private final boolean globalImplicitlyAddAutoModels;
    private final boolean disableKotlinExtensionGeneration;
    private final boolean disableGenerateReset;
    private final boolean disableGenerateGetters;
    private final boolean disableGenerateBuilderOverloads;
    private final boolean disableDslMarker;
    private final boolean logTimings;
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_DLS_MARKER = "epoxyDisableDslMarker";
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_GENERATE_RESET = "epoxyDisableGenerateReset";
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_GENERATE_GETTERS = "epoxyDisableGenerateGetters";
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_GENERATE_BUILDER_OVERLOADS = "epoxyDisableGenerateOverloads";
    @NotNull
    public static final String PROCESSOR_OPTION_LOG_TIMINGS = "logEpoxyTimings";
    @NotNull
    public static final String PROCESSOR_OPTION_VALIDATE_MODEL_USAGE = "validateEpoxyModelUsage";
    @NotNull
    public static final String PROCESSOR_OPTION_REQUIRE_HASHCODE = "requireHashCodeInEpoxyModels";
    @NotNull
    public static final String PROCESSOR_OPTION_REQUIRE_ABSTRACT_MODELS = "requireAbstractEpoxyModels";
    @NotNull
    public static final String PROCESSOR_OPTION_IMPLICITLY_ADD_AUTO_MODELS = "implicitlyAddAutoModels";
    @NotNull
    public static final String PROCESSOR_OPTION_DISABLE_KOTLIN_EXTENSION_GENERATION = "disableEpoxyKotlinExtensionGeneration";
    @NotNull
    private static final PackageConfigSettings DEFAULT_PACKAGE_CONFIG_SETTINGS = PackageConfigSettings.Companion.forDefaults();

    public ConfigManager(@NotNull Map<String, String> options, @NotNull XProcessingEnv environment) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        this.packageEpoxyConfigElements = new ArrayList();
        this.packageModelViewConfigElements = new ArrayList();
        this.configurationMap = new LinkedHashMap();
        this.modelViewNamingMap = new LinkedHashMap();
        this.validateModelUsage = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_VALIDATE_MODEL_USAGE, true);
        this.globalRequireHashCode = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_REQUIRE_HASHCODE, false);
        this.globalRequireAbstractModels = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_REQUIRE_ABSTRACT_MODELS, false);
        this.globalImplicitlyAddAutoModels = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_IMPLICITLY_ADD_AUTO_MODELS, false);
        this.disableKotlinExtensionGeneration = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_KOTLIN_EXTENSION_GENERATION, false);
        this.logTimings = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_LOG_TIMINGS, false);
        this.disableGenerateReset = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_GENERATE_RESET, false);
        this.disableGenerateGetters = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_GENERATE_GETTERS, false);
        this.disableGenerateBuilderOverloads = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_GENERATE_BUILDER_OVERLOADS, false);
        this.disableDslMarker = ConfigManager.Companion.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_DLS_MARKER, false);
    }

    @NotNull
    public final List<XElement> getPackageEpoxyConfigElements() {
        return this.packageEpoxyConfigElements;
    }

    @NotNull
    public final List<XElement> getPackageModelViewConfigElements() {
        return this.packageModelViewConfigElements;
    }

    public final boolean getDisableDslMarker() {
        return this.disableDslMarker;
    }

    public final boolean getLogTimings() {
        return this.logTimings;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Exception> processPackageEpoxyConfig(@NotNull XRoundEnv roundEnv) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        List errors = new ArrayList();
        Iterable $this$filterIsInstance$iv = roundEnv.getElementsAnnotatedWith(Reflection.getOrCreateKotlinClass(PackageEpoxyConfig.class));
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XTypeElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XAnnotationBox annotation;
            XTypeElement element = (XTypeElement)element$iv;
            boolean bl = false;
            this.packageEpoxyConfigElements.add((XElement)element);
            String packageName = element.getPackageName();
            if (this.configurationMap.containsKey(packageName)) {
                Object[] objectArray = new Object[]{packageName};
                errors.add(Utils.buildEpoxyException("Only one Epoxy configuration annotation is allowed per package (%s)", objectArray));
                continue;
            }
            Intrinsics.checkNotNull((Object)element.getAnnotation(Reflection.getOrCreateKotlinClass(PackageEpoxyConfig.class)));
            this.configurationMap.put(packageName, PackageConfigSettings.Companion.create((XAnnotationBox<PackageEpoxyConfig>)annotation));
        }
        return errors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Exception> processPackageModelViewConfig(@NotNull XRoundEnv roundEnv) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        List errors = new ArrayList();
        Iterable $this$filterIsInstance$iv = roundEnv.getElementsAnnotatedWith(Reflection.getOrCreateKotlinClass(PackageModelViewConfig.class));
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XTypeElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XTypeElement rClassName;
            XTypeElement element = (XTypeElement)element$iv;
            boolean bl = false;
            this.packageModelViewConfigElements.add((XElement)element);
            String packageName = element.getPackageName();
            if (this.modelViewNamingMap.containsKey(packageName)) {
                Object[] objectArray = new Object[]{PackageModelViewConfig.class.getSimpleName(), packageName};
                errors.add(Utils.buildEpoxyException("Only one %s annotation is allowed per package (%s)", objectArray));
                continue;
            }
            XAnnotationBox annotation = element.requireAnnotation(Reflection.getOrCreateKotlinClass(PackageModelViewConfig.class));
            XType xType = annotation.getAsType("rClass");
            Object object = rClassName = xType != null ? xType.getTypeElement() : null;
            if (rClassName == null) {
                Object[] objectArray = new Object[]{PackageModelViewConfig.class.getSimpleName(), packageName};
                errors.add(Utils.INSTANCE.buildEpoxyException((XElement)element, "Unable to get R class details from annotation %s (package: %s)", objectArray));
                continue;
            }
            String rLayoutClassString = rClassName.getClassName().reflectionName();
            Intrinsics.checkNotNullExpressionValue((Object)rLayoutClassString, (String)"rLayoutClassString");
            if (!StringsKt.endsWith$default((String)rLayoutClassString, (String)".R", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)rLayoutClassString, (String)".R2", (boolean)false, (int)2, null)) {
                Object[] objectArray = new Object[]{PackageModelViewConfig.class.getSimpleName(), rLayoutClassString, packageName};
                errors.add(Utils.INSTANCE.buildEpoxyException((XElement)element, "Invalid R class in %s. Was '%s' (package: %s)", objectArray));
                continue;
            }
            this.modelViewNamingMap.put(packageName, new PackageModelViewSettings(rClassName, (XAnnotationBox<PackageModelViewConfig>)annotation));
        }
        return errors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean requiresHashCode(@NotNull AttributeInfo attributeInfo) {
        Intrinsics.checkNotNullParameter((Object)attributeInfo, (String)"attributeInfo");
        if (attributeInfo instanceof ViewAttributeInfo) {
            return true;
        }
        if (this.globalRequireHashCode) return true;
        String string = attributeInfo.getPackageName();
        if (string == null) return false;
        String packageName = string;
        boolean bl = false;
        if (!this.getConfigurationForPackage(packageName).getRequireHashCode()) return false;
        return true;
    }

    public final boolean requiresAbstractModels(@NotNull XTypeElement classElement) {
        Intrinsics.checkNotNullParameter((Object)classElement, (String)"classElement");
        return this.globalRequireAbstractModels || this.getConfigurationForElement(classElement).getRequireAbstractModels();
    }

    public final boolean implicitlyAddAutoModels(@NotNull ControllerClassInfo controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        return this.globalImplicitlyAddAutoModels || this.getConfigurationForPackage(controller.getClassPackage()).getImplicitlyAddAutoModels();
    }

    public final boolean disableKotlinExtensionGeneration() {
        return this.disableKotlinExtensionGeneration;
    }

    public final boolean shouldValidateModelUsage() {
        return this.validateModelUsage;
    }

    @Nullable
    public final PackageModelViewSettings getModelViewConfig(@Nullable ModelViewInfo modelViewInfo) {
        if (modelViewInfo == null) {
            return null;
        }
        return this.getModelViewConfig(modelViewInfo.getViewElement());
    }

    @Nullable
    public final PackageModelViewSettings getModelViewConfig(@NotNull XTypeElement viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        String packageName = viewElement.getPackageName();
        return (PackageModelViewSettings)ConfigManager.Companion.getObjectFromPackageMap(this.modelViewNamingMap, packageName, null);
    }

    @Nullable
    public final XType getDefaultBaseModel(@NotNull XTypeElement viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        PackageModelViewSettings packageModelViewSettings = this.getModelViewConfig(viewElement);
        return packageModelViewSettings != null ? packageModelViewSettings.getDefaultBaseModel() : null;
    }

    public final boolean includeAlternateLayoutsForViews(@NotNull XTypeElement viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        PackageModelViewSettings packageModelViewSettings = this.getModelViewConfig(viewElement);
        return packageModelViewSettings != null ? packageModelViewSettings.getIncludeAlternateLayouts() : false;
    }

    @NotNull
    public final String generatedModelSuffix(@NotNull XTypeElement viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        Object object = this.getModelViewConfig(viewElement);
        if (object == null || (object = ((PackageModelViewSettings)object).getGeneratedModelSuffix()) == null) {
            object = "Model_";
        }
        return object;
    }

    public final boolean disableGenerateBuilderOverloads(@NotNull GeneratedModelInfo modelInfo) {
        Intrinsics.checkNotNullParameter((Object)modelInfo, (String)"modelInfo");
        Object object = this.getModelViewConfig(modelInfo instanceof ModelViewInfo ? (ModelViewInfo)modelInfo : null);
        return object != null && (object = ((PackageModelViewSettings)object).getDisableGenerateBuilderOverloads()) != null ? (Boolean)object : this.disableGenerateBuilderOverloads;
    }

    public final boolean disableGenerateReset(@NotNull GeneratedModelInfo modelInfo) {
        Intrinsics.checkNotNullParameter((Object)modelInfo, (String)"modelInfo");
        Object object = this.getModelViewConfig(modelInfo instanceof ModelViewInfo ? (ModelViewInfo)modelInfo : null);
        return object != null && (object = ((PackageModelViewSettings)object).getDisableGenerateReset()) != null ? (Boolean)object : this.disableGenerateReset;
    }

    public final boolean disableGenerateGetters(@NotNull GeneratedModelInfo modelInfo) {
        Intrinsics.checkNotNullParameter((Object)modelInfo, (String)"modelInfo");
        Object object = this.getModelViewConfig(modelInfo instanceof ModelViewInfo ? (ModelViewInfo)modelInfo : null);
        return object != null && (object = ((PackageModelViewSettings)object).getDisableGenerateGetters()) != null ? (Boolean)object : this.disableGenerateGetters;
    }

    private final PackageConfigSettings getConfigurationForElement(XTypeElement element) {
        return this.getConfigurationForPackage(element.getPackageName());
    }

    @NotNull
    public final PackageConfigSettings getConfigurationForPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object object = ConfigManager.Companion.getObjectFromPackageMap(this.configurationMap, packageName, ConfigManager.DEFAULT_PACKAGE_CONFIG_SETTINGS);
        Intrinsics.checkNotNull((Object)object);
        return (PackageConfigSettings)object;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J9\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00170\u00132\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u0002H\u0017H\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/airbnb/epoxy/processor/ConfigManager$Companion;", "", "()V", "DEFAULT_PACKAGE_CONFIG_SETTINGS", "Lcom/airbnb/epoxy/processor/PackageConfigSettings;", "PROCESSOR_OPTION_DISABLE_DLS_MARKER", "", "PROCESSOR_OPTION_DISABLE_GENERATE_BUILDER_OVERLOADS", "PROCESSOR_OPTION_DISABLE_GENERATE_GETTERS", "PROCESSOR_OPTION_DISABLE_GENERATE_RESET", "PROCESSOR_OPTION_DISABLE_KOTLIN_EXTENSION_GENERATION", "PROCESSOR_OPTION_IMPLICITLY_ADD_AUTO_MODELS", "PROCESSOR_OPTION_LOG_TIMINGS", "PROCESSOR_OPTION_REQUIRE_ABSTRACT_MODELS", "PROCESSOR_OPTION_REQUIRE_HASHCODE", "PROCESSOR_OPTION_VALIDATE_MODEL_USAGE", "getBooleanOption", "", "options", "", "option", "defaultValue", "getObjectFromPackageMap", "T", "map", "packageName", "ifNotFound", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "epoxy-processor"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getBooleanOption(Map<String, String> options, String option, boolean defaultValue) {
            String string = options.get(option);
            if (string == null) {
                return defaultValue;
            }
            String value = string;
            return Boolean.parseBoolean(value);
        }

        private final <T> T getObjectFromPackageMap(Map<String, ? extends T> map, String packageName, T ifNotFound) {
            if (map.containsKey(packageName)) {
                return map.get(packageName);
            }
            T matchValue = null;
            int matchLength = 0;
            Map<String, T> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, T>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, T> element$iv;
                Map.Entry<String, T> entry = element$iv = iterator.next();
                boolean bl = false;
                String entryPackage = entry.getKey();
                T value = entry.getValue();
                if (!StringsKt.startsWith$default((String)packageName, (String)(entryPackage + '.'), (boolean)false, (int)2, null) || matchLength >= entryPackage.length()) continue;
                matchLength = entryPackage.length();
                matchValue = value;
            }
            T t = matchValue;
            if (t == null) {
                t = ifNotFound;
            }
            return t;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

