/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.EpoxyModelClass;
import com.airbnb.epoxy.processor.GeneratedModelInfo;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.TypeNameWorkaroundKt;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.XProcessingUtilsKt;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/airbnb/epoxy/processor/BasicGeneratedModelInfo;", "Lcom/airbnb/epoxy/processor/GeneratedModelInfo;", "superClassElement", "Landroidx/room/compiler/processing/XTypeElement;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "memoizer", "Lcom/airbnb/epoxy/processor/Memoizer;", "(Landroidx/room/compiler/processing/XTypeElement;Lcom/airbnb/epoxy/processor/Logger;Lcom/airbnb/epoxy/processor/Memoizer;)V", "boundObjectTypeElement", "getBoundObjectTypeElement", "()Landroidx/room/compiler/processing/XTypeElement;", "additionalOriginatingElements", "", "Landroidx/room/compiler/processing/XElement;", "buildGeneratedModelName", "Lcom/squareup/javapoet/ClassName;", "classElement", "epoxy-processor"})
public final class BasicGeneratedModelInfo
extends GeneratedModelInfo {
    @Nullable
    private final XTypeElement boundObjectTypeElement;

    public BasicGeneratedModelInfo(@NotNull XTypeElement superClassElement, @NotNull Logger logger2, final @NotNull Memoizer memoizer) {
        Object[] typeParam2;
        Intrinsics.checkNotNullParameter((Object)superClassElement, (String)"superClassElement");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        super(memoizer);
        this.setSuperClassName(TypeNameWorkaroundKt.typeNameWithWorkaround(superClassElement.getType(), memoizer));
        this.setSuperClassElement(superClassElement);
        this.setGeneratedName(this.buildGeneratedModelName(superClassElement));
        for (Object[] typeParam2 : superClassElement.getType().getTypeArguments()) {
            TypeName defaultTypeName = TypeNameWorkaroundKt.typeNameWithWorkaround((XType)typeParam2, memoizer);
            if (defaultTypeName instanceof TypeVariableName) {
                this.getTypeVariableNames().add((TypeVariableName)defaultTypeName);
                continue;
            }
            logger2.logError((XElement)superClassElement, "Unable to get type variable name for " + superClassElement + ". Found " + defaultTypeName, new Object[0]);
        }
        this.getConstructors().addAll((Collection<GeneratedModelInfo.ConstructorInfo>)this.getClassConstructors(superClassElement));
        this.collectMethodsReturningClassType(superClassElement);
        if (!((Collection)this.getTypeVariableNames()).isEmpty()) {
            ClassName className = this.getGeneratedName();
            Collection $this$toTypedArray$iv = this.getTypeVariableNames();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            TypeVariableName[] typeVariableNameArray = thisCollection$iv.toArray(new TypeVariableName[0]);
            Intrinsics.checkNotNull((Object)typeVariableNameArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            typeParam2 = typeVariableNameArray;
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)className, (TypeName[])((TypeName[])Arrays.copyOf(typeParam2, typeParam2.length)));
            Intrinsics.checkNotNullExpressionValue((Object)parameterizedTypeName, (String)"get(\n                gen\u2026ypedArray()\n            )");
            this.setParameterizedGeneratedName((TypeName)parameterizedTypeName);
        } else {
            this.setParameterizedGeneratedName((TypeName)this.getGeneratedName());
        }
        XType boundObjectType = Utils.INSTANCE.getEpoxyObjectType(superClassElement, memoizer);
        if (boundObjectType == null) {
            typeParam2 = new Object[]{superClassElement.getName()};
            logger2.logError("Epoxy model type could not be found. (class: %s)", typeParam2);
            boundObjectType = memoizer.getAndroidViewType();
        }
        this.setModelType(boundObjectType.getTypeName());
        this.boundObjectTypeElement = boundObjectType.getTypeElement();
        XAnnotationBox annotation = superClassElement.getAnnotation(Reflection.getOrCreateKotlinClass(EpoxyModelClass.class));
        this.setShouldGenerateModel(annotation != null || !superClassElement.isAbstract());
        XAnnotationBox xAnnotationBox = annotation;
        this.setIncludeOtherLayoutOptions(xAnnotationBox != null && (xAnnotationBox = (EpoxyModelClass)xAnnotationBox.getValue()) != null ? xAnnotationBox.useLayoutOverloads() : false);
        this.getAnnotations().addAll((Collection<AnnotationSpec>)XProcessingUtilsKt.buildAnnotationSpecs(superClassElement, (Function1<? super ClassName, Boolean>)((Function1)new Function1<ClassName, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull ClassName it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it, (Object)memoizer.getEpoxyModelClassAnnotation());
            }
        }), memoizer));
    }

    @Nullable
    public final XTypeElement getBoundObjectTypeElement() {
        return this.boundObjectTypeElement;
    }

    private final ClassName buildGeneratedModelName(XTypeElement classElement) {
        String packageName = classElement.getPackageName();
        int packageLen = packageName.length() + 1;
        String string = classElement.getQualifiedName().substring(packageLen);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String className = StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null);
        ClassName className2 = ClassName.get((String)packageName, (String)(className + '_'), (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className2, (String)"get(\n            package\u2026ASS_NAME_SUFFIX\n        )");
        return className2;
    }

    @Override
    @NotNull
    public List<XElement> additionalOriginatingElements() {
        return CollectionsKt.listOf((Object)this.getSuperClassElement());
    }
}

