/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XExecutableParameterElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XMemberContainer;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XNullability;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.EpoxyAttribute;
import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.ViewAttributeInfoKt;
import com.airbnb.epoxy.processor.XProcessingUtilsKt;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.Origin;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J(\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/airbnb/epoxy/processor/BaseModelAttributeInfo;", "Lcom/airbnb/epoxy/processor/AttributeInfo;", "attribute", "Landroidx/room/compiler/processing/XFieldElement;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "memoizer", "Lcom/airbnb/epoxy/processor/Memoizer;", "(Landroidx/room/compiler/processing/XFieldElement;Lcom/airbnb/epoxy/processor/Logger;Lcom/airbnb/epoxy/processor/Memoizer;)V", "classElement", "Landroidx/room/compiler/processing/XTypeElement;", "buildAnnotationLists", "", "annotations", "", "Landroidx/room/compiler/processing/XAnnotation;", "findGetterAndSetterForPrivateField", "validateAnnotationOptions", "annotation", "Lcom/airbnb/epoxy/EpoxyAttribute;", "options", "", "Lcom/airbnb/epoxy/EpoxyAttribute$Option;", "hasSuperMethod", "", "epoxy-processor"})
public final class BaseModelAttributeInfo
extends AttributeInfo {
    @NotNull
    private final XTypeElement classElement;

    public BaseModelAttributeInfo(@NotNull XFieldElement attribute, @NotNull Logger logger2, @NotNull Memoizer memoizer) {
        KSPropertyDeclaration declaration;
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        super(memoizer);
        XMemberContainer xMemberContainer = attribute.getEnclosingElement();
        Intrinsics.checkNotNull((Object)xMemberContainer, (String)"null cannot be cast to non-null type androidx.room.compiler.processing.XTypeElement");
        this.classElement = (XTypeElement)xMemberContainer;
        this.setFieldName(attribute.getName());
        this.setXType(attribute.getType(), memoizer);
        this.setJavaDocString(attribute.getDocComment());
        this.setRootClass(this.classElement.getName());
        this.setPackageName(this.classElement.getPackageName());
        this.setHasSuperSetter(this.hasSuperMethod(this.classElement, attribute));
        this.setHasFinalModifier(memoizer.getEnvironment().getBackend() == XProcessingEnv.Backend.KSP ? ((declaration = XProcessingUtilsKt.getDeclaration(attribute)).getOrigin() == Origin.JAVA ? attribute.isFinal() : !declaration.isMutable()) : attribute.isFinal());
        this.setPackagePrivate(Utils.isFieldPackagePrivate((XElement)attribute));
        XAnnotationBox annotationBox = attribute.requireAnnotation(Reflection.getOrCreateKotlinClass(EpoxyAttribute.class));
        Set options = ArraysKt.toSet((Object[])((EpoxyAttribute)annotationBox.getValue()).value());
        this.validateAnnotationOptions(logger2, (EpoxyAttribute)annotationBox.getValue(), options);
        this.setUseInHash(((EpoxyAttribute)annotationBox.getValue()).hash() && !options.contains(EpoxyAttribute.Option.DoNotHash));
        this.setIgnoreRequireHashCode(options.contains(EpoxyAttribute.Option.IgnoreRequireHashCode));
        this.setDoNotUseInToString(options.contains(EpoxyAttribute.Option.DoNotUseInToString));
        this.setGenerateSetter(((EpoxyAttribute)annotationBox.getValue()).setter() && !options.contains(EpoxyAttribute.Option.NoSetter));
        this.setGenerateGetter(!options.contains(EpoxyAttribute.Option.NoGetter));
        this.setPrivate(attribute.isPrivate());
        if (this.isPrivate()) {
            this.findGetterAndSetterForPrivateField(logger2);
        }
        this.buildAnnotationLists(attribute, attribute.getAllAnnotations());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasSuperMethod(XTypeElement $this$hasSuperMethod, XFieldElement attribute) {
        boolean bl;
        if (!XProcessingUtilsKt.isEpoxyModel($this$hasSuperMethod.getType(), this.getMemoizer())) {
            return false;
        }
        Iterable $this$any$iv = $this$hasSuperMethod.getDeclaredMethods();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                XMethodElement method = (XMethodElement)element$iv;
                boolean bl2 = false;
                if (!method.isPrivate() && Intrinsics.areEqual((Object)method.getName(), (Object)attribute.getName())) {
                    XExecutableParameterElement xExecutableParameterElement = (XExecutableParameterElement)CollectionsKt.singleOrNull((List)method.getParameters());
                    if (Intrinsics.areEqual((Object)(xExecutableParameterElement != null ? xExecutableParameterElement.getType() : null), (Object)attribute.getType())) {
                        return true;
                    }
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        boolean hasImplementation = bl;
        if (hasImplementation) return true;
        XType xType = $this$hasSuperMethod.getSuperType();
        XType xType2 = xType;
        if (xType == null) return false;
        XTypeElement xTypeElement = xType2.getTypeElement();
        xType2 = xTypeElement;
        if (xTypeElement == null) return false;
        if (!this.hasSuperMethod((XTypeElement)xType2, attribute)) return false;
        return true;
    }

    private final void validateAnnotationOptions(Logger logger2, EpoxyAttribute annotation, Set<? extends EpoxyAttribute.Option> options) {
        Object[] objectArray;
        if (options.contains(EpoxyAttribute.Option.IgnoreRequireHashCode) && options.contains(EpoxyAttribute.Option.DoNotHash)) {
            objectArray = new Object[5];
            objectArray[0] = EpoxyAttribute.Option.DoNotHash;
            objectArray[1] = EpoxyAttribute.Option.IgnoreRequireHashCode;
            Intrinsics.checkNotNullExpressionValue((Object)EpoxyAttribute.class.getSimpleName(), (String)"EpoxyAttribute::class.java.simpleName");
            objectArray[3] = this.classElement.getName();
            objectArray[4] = this.getFieldName();
            logger2.logError("Illegal to use both %s and %s options in an %s annotation. (%s#%s)", objectArray);
        }
        if (!((Collection)options).isEmpty()) {
            EpoxyAttribute epoxyAttribute = annotation;
            Intrinsics.checkNotNull((Object)epoxyAttribute);
            if (!epoxyAttribute.hash()) {
                objectArray = new Object[4];
                Intrinsics.checkNotNullExpressionValue((Object)EpoxyAttribute.class.getSimpleName(), (String)"EpoxyAttribute::class.java.simpleName");
                objectArray[1] = EpoxyAttribute.Option.DoNotHash;
                objectArray[2] = this.classElement.getName();
                objectArray[3] = this.getFieldName();
                logger2.logError("Don't use hash=false in an %s if you are using options. Instead, use the %s option. (%s#%s)", objectArray);
            }
            if (!annotation.setter()) {
                objectArray = new Object[4];
                Intrinsics.checkNotNullExpressionValue((Object)EpoxyAttribute.class.getSimpleName(), (String)"EpoxyAttribute::class.java.simpleName");
                objectArray[1] = EpoxyAttribute.Option.NoSetter;
                objectArray[2] = this.classElement.getName();
                objectArray[3] = this.getFieldName();
                logger2.logError("Don't use setter=false in an %s if you are using options. Instead, use the %s option. (%s#%s)", objectArray);
            }
        }
    }

    private final void findGetterAndSetterForPrivateField(Logger logger2) {
        Iterable $this$forEach$iv = this.classElement.getDeclaredMethods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object[] objectArray;
            String string;
            List parameters;
            String methodName;
            XMethodElement method;
            block8: {
                block7: {
                    method = (XMethodElement)element$iv;
                    boolean bl = false;
                    methodName = method.getName();
                    parameters = method.getParameters();
                    string = "get%s";
                    objectArray = new Object[]{Utils.capitalizeFirstLetter(this.getFieldName())};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    if (Intrinsics.areEqual((Object)methodName, (Object)string2)) break block7;
                    string = "is%s";
                    objectArray = new Object[]{Utils.capitalizeFirstLetter(this.getFieldName())};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                    if (!Intrinsics.areEqual((Object)methodName, (Object)string3) && (!Intrinsics.areEqual((Object)methodName, (Object)this.getFieldName()) || !Utils.startsWithIs(this.getFieldName()))) break block8;
                }
                if (!method.isPrivate() && !method.isStatic() && parameters.isEmpty()) {
                    this.setGetterMethodName(methodName);
                }
            }
            string = "set%s";
            objectArray = new Object[]{Utils.capitalizeFirstLetter(this.getFieldName())};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            if (!Intrinsics.areEqual((Object)methodName, (Object)string4)) {
                if (!Utils.startsWithIs(this.getFieldName())) continue;
                string = "set%s";
                objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)this.getFieldName().substring(2, this.getFieldName().length()), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
                if (!Intrinsics.areEqual((Object)methodName, (Object)string5)) continue;
            }
            if (method.isPrivate() || method.isStatic() || parameters.size() != 1) continue;
            this.setSetterMethodName(methodName);
        }
        if (this.getGetterMethodName() == null || this.getSetterMethodName() == null) {
            this.setPrivate(false);
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)EpoxyAttribute.class.getSimpleName(), (String)"EpoxyAttribute::class.java.simpleName");
            objectArray[1] = this.classElement.getName();
            objectArray[2] = this.getFieldName();
            logger2.logError("%s annotations must not be on private fields without proper getter and setter methods. (class: %s, field: %s)", objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAnnotationLists(XFieldElement attribute, List<? extends XAnnotation> annotations) {
        ElementType[] targetAnnotation;
        for (XAnnotation xAnnotation : annotations) {
            if (!((Collection)xAnnotation.getAnnotationValues()).isEmpty() || xAnnotation.getType().isTypeOf(Reflection.getOrCreateKotlinClass(EpoxyAttribute.class))) continue;
            XType annotationType = xAnnotation.getType();
            XTypeElement xTypeElement = annotationType.getTypeElement();
            targetAnnotation = xTypeElement != null ? xTypeElement.getAnnotation(Reflection.getOrCreateKotlinClass(Target.class)) : null;
            Object object = targetAnnotation;
            if (targetAnnotation == null || (object = (Target)object.getValue()) == null || (object = object.value()) == null) {
                object = ElementType.values();
            }
            Object elementTypes = object;
            AnnotationSpec annotationSpec = XProcessingUtilsKt.toAnnotationSpec(xAnnotation, this.getMemoizer());
            if (ArraysKt.contains((Object[])elementTypes, (Object)((Object)ElementType.PARAMETER))) {
                this.getSetterAnnotations().add(annotationSpec);
            }
            if (!ArraysKt.contains((Object[])elementTypes, (Object)((Object)ElementType.METHOD))) continue;
            this.getGetterAnnotations().add(annotationSpec);
        }
        if (this.getMemoizer().getEnvironment().getBackend() == XProcessingEnv.Backend.KSP && XProcessingUtilsKt.isKotlinOrigin((KSDeclaration)XProcessingUtilsKt.getDeclaration(attribute)) && !attribute.getType().getTypeName().isPrimitive()) {
            boolean $i$f$none;
            void $this$mapTo$iv$iv;
            ElementType[] elementTypeArray = (ElementType[])this.getSetterAnnotations();
            boolean $i$f$map = false;
            targetAnnotation = elementTypeArray;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)elementTypeArray, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void annotation;
                AnnotationSpec annotationSpec = (AnnotationSpec)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TypeName type = annotation.type;
                if (type instanceof ClassName) {
                    string = ((ClassName)type).simpleName();
                } else {
                    String string2 = annotation.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"annotation.toString()");
                    string = StringsKt.substringAfterLast$default((String)string2, (String)".", null, (int)2, null);
                }
                collection.add(string);
            }
            List annotationSimpleNames = (List)destination$iv$iv;
            if (attribute.getType().getNullability() == XNullability.NULLABLE) {
                boolean bl;
                block18: {
                    Iterable iterable = annotationSimpleNames;
                    $i$f$none = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : iterable) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)"Nullable")) continue;
                            bl = false;
                            break block18;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    List<AnnotationSpec> list = this.getSetterAnnotations();
                    AnnotationSpec annotationSpec = ViewAttributeInfoKt.getNULLABLE_ANNOTATION_SPEC();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationSpec, (String)"NULLABLE_ANNOTATION_SPEC");
                    list.add(annotationSpec);
                    List<AnnotationSpec> list2 = this.getGetterAnnotations();
                    AnnotationSpec annotationSpec2 = ViewAttributeInfoKt.getNULLABLE_ANNOTATION_SPEC();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationSpec2, (String)"NULLABLE_ANNOTATION_SPEC");
                    list2.add(annotationSpec2);
                }
            } else if (attribute.getType().getNullability() == XNullability.NONNULL) {
                boolean bl;
                block19: {
                    Iterable iterable = annotationSimpleNames;
                    $i$f$none = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : iterable) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!(Intrinsics.areEqual((Object)it, (Object)"NotNull") || Intrinsics.areEqual((Object)it, (Object)"NonNull"))) continue;
                            bl = false;
                            break block19;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    List<AnnotationSpec> list = this.getSetterAnnotations();
                    AnnotationSpec annotationSpec = ViewAttributeInfoKt.getNON_NULL_ANNOTATION_SPEC();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationSpec, (String)"NON_NULL_ANNOTATION_SPEC");
                    list.add(annotationSpec);
                    List<AnnotationSpec> list3 = this.getGetterAnnotations();
                    AnnotationSpec annotationSpec3 = ViewAttributeInfoKt.getNON_NULL_ANNOTATION_SPEC();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationSpec3, (String)"NON_NULL_ANNOTATION_SPEC");
                    list3.add(annotationSpec3);
                }
            }
        }
    }
}

