/*
 * Decompiled with CFR 0.152.
 */
package com.agapsys.utils.console;

import com.agapsys.utils.console.ConsoleColor;
import com.agapsys.utils.console.ConsoleFormat;

public class FormatEscapeBuilder {
    private ConsoleColor bgColor = null;
    private ConsoleColor fgColor = null;
    private Boolean bold = null;
    private Boolean dim = null;
    private Boolean underlined = null;
    private Boolean blink = null;
    private Boolean reverse = null;
    private Boolean hidden = null;

    public FormatEscapeBuilder setBgColor(ConsoleColor bgColor) {
        if (bgColor == null) {
            throw new IllegalArgumentException("bgColor == null");
        }
        if (this.bgColor != null) {
            throw new IllegalStateException("bgColor is already set");
        }
        this.bgColor = bgColor;
        return this;
    }

    public FormatEscapeBuilder setFgColor(ConsoleColor fgColor) {
        if (fgColor == null) {
            throw new IllegalArgumentException("fgColor == null");
        }
        if (this.fgColor != null) {
            throw new IllegalStateException("fgColor is already set");
        }
        this.fgColor = fgColor;
        return this;
    }

    public FormatEscapeBuilder setBold() {
        return this.setBold(true);
    }

    public FormatEscapeBuilder setBold(boolean enabled) {
        if (this.bold != null) {
            throw new IllegalStateException("property already set");
        }
        this.bold = enabled;
        return this;
    }

    public FormatEscapeBuilder setDim() {
        return this.setDim(true);
    }

    public FormatEscapeBuilder setDim(boolean enabled) {
        if (this.dim != null) {
            throw new IllegalStateException("property already set");
        }
        this.dim = enabled;
        return this;
    }

    public FormatEscapeBuilder setUnderlined() {
        return this.setUnderlined(true);
    }

    public FormatEscapeBuilder setUnderlined(boolean enabled) {
        if (this.underlined != null) {
            throw new IllegalStateException("property already set");
        }
        this.underlined = enabled;
        return this;
    }

    public FormatEscapeBuilder setBlink() {
        return this.setBlink(true);
    }

    public FormatEscapeBuilder setBlink(boolean enabled) {
        if (this.blink != null) {
            throw new IllegalStateException("property already set");
        }
        this.blink = enabled;
        return this;
    }

    public FormatEscapeBuilder setReverse() {
        return this.setReverse(true);
    }

    public FormatEscapeBuilder setReverse(boolean enabled) {
        if (this.reverse != null) {
            throw new IllegalStateException("property already set");
        }
        this.reverse = enabled;
        return this;
    }

    public FormatEscapeBuilder setHidden() {
        return this.setHidden(true);
    }

    public FormatEscapeBuilder setHidden(boolean enabled) {
        if (this.hidden != null) {
            throw new IllegalStateException("property already set");
        }
        this.hidden = enabled;
        return this;
    }

    public String escape(String msg) {
        if (msg == null || msg.trim().isEmpty()) {
            throw new IllegalArgumentException("msg == null or msg.isEmpty()");
        }
        Object[] objectArray = new Object[8];
        objectArray[0] = this.bgColor != null ? this.bgColor.getBgCode() + ";" : "";
        Object object = objectArray[1] = this.fgColor != null ? this.fgColor.getFgCode() + ";" : "";
        Object object2 = this.bold != null ? (this.bold != false ? ConsoleFormat.BOLD.getSetCode() : ConsoleFormat.BOLD.getResetCode()) + ";" : (objectArray[2] = "");
        Object object3 = this.dim != null ? (this.dim != false ? ConsoleFormat.DIM.getSetCode() : ConsoleFormat.DIM.getResetCode()) + ";" : (objectArray[3] = "");
        Object object4 = this.underlined != null ? (this.underlined != false ? ConsoleFormat.UNDERLINED.getSetCode() : ConsoleFormat.UNDERLINED.getResetCode()) + ";" : (objectArray[4] = "");
        Object object5 = this.blink != null ? (this.blink != false ? ConsoleFormat.BLINK.getSetCode() : ConsoleFormat.BLINK.getResetCode()) + ";" : (objectArray[5] = "");
        Object object6 = this.reverse != null ? (this.reverse != false ? ConsoleFormat.REVERSE.getSetCode() : ConsoleFormat.REVERSE.getResetCode()) + ";" : (objectArray[6] = "");
        objectArray[7] = this.hidden != null ? (this.hidden != false ? ConsoleFormat.HIDDEN.getSetCode() : ConsoleFormat.HIDDEN.getResetCode()) + ";" : "";
        String attrCodes = String.format("%s%s%s%s%s%s%s", objectArray);
        if (!attrCodes.isEmpty()) {
            attrCodes = attrCodes.substring(0, attrCodes.length() - 1);
            return String.format("\u001b[%sm%s\u001b[0m", attrCodes, msg);
        }
        return msg;
    }
}

