/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout.details;

import com.adyen.model.checkout.PaymentMethodDetails;
import com.adyen.util.MaskUtil;
import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class GooglePayDetails
implements PaymentMethodDetails {
    public static final String GOOGLEPAY = "paywithgoogle";
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource = null;
    @SerializedName(value="googlePayCardNetwork")
    private String googlePayCardNetwork = null;
    @SerializedName(value="googlePayToken")
    private String googlePayToken = null;
    @SerializedName(value="type")
    private String type = "paywithgoogle";

    public GooglePayDetails fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public GooglePayDetails googlePayCardNetwork(String googlePayCardNetwork) {
        this.googlePayCardNetwork = googlePayCardNetwork;
        return this;
    }

    public String getGooglePayCardNetwork() {
        return this.googlePayCardNetwork;
    }

    public void setGooglePayCardNetwork(String googlePayCardNetwork) {
        this.googlePayCardNetwork = googlePayCardNetwork;
    }

    public GooglePayDetails googlePayToken(String googlePayToken) {
        this.googlePayToken = googlePayToken;
        return this;
    }

    public String getGooglePayToken() {
        return this.googlePayToken;
    }

    public void setGooglePayToken(String googlePayToken) {
        this.googlePayToken = googlePayToken;
    }

    public GooglePayDetails type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GooglePayDetails googlePayDetails = (GooglePayDetails)o;
        return Objects.equals((Object)this.fundingSource, (Object)googlePayDetails.fundingSource) && Objects.equals(this.googlePayCardNetwork, googlePayDetails.googlePayCardNetwork) && Objects.equals(this.googlePayToken, googlePayDetails.googlePayToken) && Objects.equals(this.type, googlePayDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fundingSource, this.googlePayCardNetwork, this.googlePayToken, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GooglePayDetails {\n");
        sb.append("    fundingSource: ").append(Util.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    googlePayCardNetwork: ").append(Util.toIndentedString(this.googlePayCardNetwork)).append("\n");
        sb.append("    googlePayToken: ").append(Util.toIndentedString(MaskUtil.mask(this.googlePayToken))).append("\n");
        sb.append("    type: ").append(Util.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        CREDIT("credit"),
        DEBIT("debit");

        @JsonValue
        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String text) {
            return Arrays.stream(FundingSourceEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

