/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay.notification;

import com.adyen.model.marketpay.notification.NotificationConfigurationDetails;
import com.adyen.model.marketpay.notification.NotificationConfigurationDetailsContainer;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetNotificationConfigurationListResponse {
    @SerializedName(value="submittedAsync")
    private Boolean submittedAsync = null;
    @SerializedName(value="configurations")
    private List<NotificationConfigurationDetailsContainer> configurationsContainers = null;
    private transient List<NotificationConfigurationDetails> configurations = null;
    @SerializedName(value="pspReference")
    private String pspReference = null;

    public GetNotificationConfigurationListResponse submittedAsync(Boolean submittedAsync) {
        this.submittedAsync = submittedAsync;
        return this;
    }

    public Boolean getSubmittedAsync() {
        return this.submittedAsync;
    }

    public void setSubmittedAsync(Boolean submittedAsync) {
        this.submittedAsync = submittedAsync;
    }

    public List<NotificationConfigurationDetails> getConfigurations() {
        if (this.configurations == null && this.configurationsContainers != null && !this.configurationsContainers.isEmpty()) {
            this.configurations = this.configurationsContainers.stream().map(s -> s.getNotificationConfigurationDetails()).collect(Collectors.toList());
        }
        return this.configurations;
    }

    public void setConfigurations(List<NotificationConfigurationDetails> configurations) {
        this.configurations = configurations;
        this.configurationsContainers = configurations.stream().map(s -> this.createNotificationConfigurationDetailsContainerFromConfiguration((NotificationConfigurationDetails)s)).collect(Collectors.toList());
    }

    private NotificationConfigurationDetailsContainer createNotificationConfigurationDetailsContainerFromConfiguration(NotificationConfigurationDetails configuration) {
        NotificationConfigurationDetailsContainer notificationConfigurationDetailsContainer = new NotificationConfigurationDetailsContainer();
        notificationConfigurationDetailsContainer.setNotificationConfigurationDetails(configuration);
        return notificationConfigurationDetailsContainer;
    }

    public GetNotificationConfigurationListResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetNotificationConfigurationListResponse getNotificationConfigurationListResponse = (GetNotificationConfigurationListResponse)o;
        return Objects.equals(this.submittedAsync, getNotificationConfigurationListResponse.submittedAsync) && Objects.equals(this.configurations, getNotificationConfigurationListResponse.configurations) && Objects.equals(this.pspReference, getNotificationConfigurationListResponse.pspReference);
    }

    public int hashCode() {
        return Objects.hash(this.submittedAsync, this.configurations, this.pspReference);
    }

    public String toString() {
        this.getConfigurations();
        StringBuilder sb = new StringBuilder();
        sb.append("class GetNotificationConfigurationListResponse {\n");
        sb.append("    submittedAsync: ").append(this.toIndentedString(this.submittedAsync)).append("\n");
        sb.append("    configurations: ").append(this.toIndentedString(this.configurations)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

