/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.httpclient;

import com.adyen.Config;
import com.adyen.enums.Environment;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.adyen.model.RequestOptions;
import com.adyen.terminal.security.TerminalCommonNameValidator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;

public class HttpURLConnectionClient
implements ClientInterface {
    private static final String CHARSET = "UTF-8";
    private Proxy proxy;

    @Override
    public String request(String requestUrl, String requestBody, Config config) throws IOException, HTTPClientException {
        return this.request(requestUrl, requestBody, config, false);
    }

    @Override
    public String request(String endpoint, String json, Config config, boolean isApiKeyRequired) throws IOException, HTTPClientException {
        return this.request(endpoint, json, config, isApiKeyRequired, null);
    }

    @Override
    public String request(String requestUrl, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions) throws IOException, HTTPClientException {
        HttpURLConnection httpConnection = this.createRequest(requestUrl, config.getApplicationName(), requestOptions);
        if (config.getTerminalCertificatePath() != null && !config.getTerminalCertificatePath().isEmpty()) {
            Environment environment = this.getEnvironment(config);
            this.installCertificateVerifier(httpConnection, config.getTerminalCertificatePath());
            this.installCertificateCommonNameValidator(httpConnection, environment);
        }
        String apiKey = config.getApiKey();
        if (isApiKeyRequired || apiKey != null && !apiKey.isEmpty()) {
            this.setApiKey(httpConnection, apiKey);
        } else {
            this.setBasicAuthentication(httpConnection, config.getUsername(), config.getPassword());
        }
        httpConnection.setConnectTimeout(config.getConnectionTimeoutMillis());
        httpConnection.setReadTimeout(config.getReadTimeoutMillis());
        this.setContentType(httpConnection, "application/json");
        return this.doPostRequest(httpConnection, requestBody);
    }

    private Environment getEnvironment(Config config) {
        return config.getEnvironment() != null ? config.getEnvironment() : Environment.TEST;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String rBody = null;
        if (scanner.hasNext()) {
            rBody = scanner.next();
        }
        scanner.close();
        responseStream.close();
        return rBody;
    }

    @Override
    public String post(String requestUrl, Map<String, String> params, Config config) throws IOException, HTTPClientException {
        String postQuery = this.getQuery(params);
        HttpURLConnection httpConnection = this.createRequest(requestUrl, config.getApplicationName());
        String response = this.doPostRequest(httpConnection, postQuery);
        return response;
    }

    private String getQuery(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> pair : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(pair.getKey(), CHARSET));
            result.append("=");
            result.append(URLEncoder.encode(pair.getValue(), CHARSET));
        }
        return result.toString();
    }

    private HttpURLConnection createRequest(String requestUrl, String applicationName) throws IOException {
        return this.createRequest(requestUrl, applicationName, null);
    }

    private HttpURLConnection createRequest(String requestUrl, String applicationName, RequestOptions requestOptions) throws IOException {
        URL targetUrl = new URL(requestUrl);
        HttpURLConnection httpConnection = this.proxy != null ? (HttpURLConnection)targetUrl.openConnection(this.proxy) : (HttpURLConnection)targetUrl.openConnection();
        httpConnection.setUseCaches(false);
        httpConnection.setDoOutput(true);
        httpConnection.setRequestMethod("POST");
        httpConnection.setRequestProperty("Accept-Charset", CHARSET);
        httpConnection.setRequestProperty("User-Agent", String.format("%s %s/%s", applicationName, "adyen-java-api-library", "6.1.0"));
        if (requestOptions != null && requestOptions.getIdempotencyKey() != null) {
            httpConnection.setRequestProperty("Idempotency-Key", requestOptions.getIdempotencyKey());
        }
        return httpConnection;
    }

    private HttpURLConnection setBasicAuthentication(HttpURLConnection httpConnection, String username, String password) {
        String authString = username + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        httpConnection.setRequestProperty("Authorization", "Basic " + authStringEnc);
        return httpConnection;
    }

    private HttpURLConnection setContentType(HttpURLConnection httpConnection, String contentType) {
        httpConnection.setRequestProperty("Content-Type", contentType);
        return httpConnection;
    }

    private HttpURLConnection setApiKey(HttpURLConnection httpConnection, String apiKey) {
        if (apiKey != null && !apiKey.isEmpty()) {
            httpConnection.setRequestProperty("x-api-key", apiKey);
        }
        return httpConnection;
    }

    private String doPostRequest(HttpURLConnection httpConnection, String requestBody) throws IOException, HTTPClientException {
        String response = null;
        OutputStream outputStream = httpConnection.getOutputStream();
        outputStream.write(requestBody.getBytes());
        outputStream.flush();
        int responseCode = httpConnection.getResponseCode();
        Integer[] resultOKHttpStatusCodes = new Integer[]{200, 202, 204, 201};
        if (!Arrays.asList(resultOKHttpStatusCodes).contains(responseCode)) {
            if (httpConnection.getErrorStream() != null) {
                response = HttpURLConnectionClient.getResponseBody(httpConnection.getErrorStream());
            }
            HTTPClientException httpClientException = new HTTPClientException(responseCode, "HTTP Exception", httpConnection.getHeaderFields(), response);
            throw httpClientException;
        }
        response = HttpURLConnectionClient.getResponseBody(httpConnection.getInputStream());
        httpConnection.disconnect();
        return response;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    private void installCertificateVerifier(URLConnection connection, String terminalCertificatePath) throws HTTPClientException {
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            try {
                FileInputStream certificateInput = new FileInputStream(terminalCertificatePath);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(certificateInput);
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(null, null);
                keyStore.setCertificateEntry("TerminalCertificate", cert);
                TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustFactory.init(keyStore);
                TrustManager[] trustManagers = trustFactory.getTrustManagers();
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustManagers, new SecureRandom());
                httpsConnection.setSSLSocketFactory(sc.getSocketFactory());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new HTTPClientException("Error loading certificate from path", e);
            }
        }
    }

    private void installCertificateCommonNameValidator(HttpURLConnection connection, final Environment environment) {
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            HostnameVerifier terminalHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String host, SSLSession session) {
                    try {
                        if (session.getPeerCertificates() != null && session.getPeerCertificates().length > 0) {
                            X509Certificate certificate = (X509Certificate)session.getPeerCertificates()[0];
                            return TerminalCommonNameValidator.validateCertificate(certificate, environment);
                        }
                        return false;
                    }
                    catch (SSLPeerUnverifiedException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            httpsConnection.setHostnameVerifier(terminalHostsValid);
        }
    }
}

