/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"phoneCountryCode", "phoneNumber", "phoneType"})
public class PhoneNumber {
    public static final String JSON_PROPERTY_PHONE_COUNTRY_CODE = "phoneCountryCode";
    private String phoneCountryCode;
    private boolean isSetPhoneCountryCode = false;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;
    private boolean isSetPhoneNumber = false;
    public static final String JSON_PROPERTY_PHONE_TYPE = "phoneType";
    private PhoneTypeEnum phoneType;
    private boolean isSetPhoneType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PhoneNumber phoneCountryCode(String phoneCountryCode) {
        this.phoneCountryCode = phoneCountryCode;
        this.isSetPhoneCountryCode = true;
        return this;
    }

    @JsonProperty(value="phoneCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneCountryCode() {
        return this.phoneCountryCode;
    }

    @JsonProperty(value="phoneCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneCountryCode(String phoneCountryCode) {
        this.phoneCountryCode = phoneCountryCode;
        this.isSetPhoneCountryCode = true;
    }

    public PhoneNumber phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        this.isSetPhoneNumber = true;
        return this;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        this.isSetPhoneNumber = true;
    }

    public PhoneNumber phoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
        this.isSetPhoneType = true;
        return this;
    }

    @JsonProperty(value="phoneType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PhoneTypeEnum getPhoneType() {
        return this.phoneType;
    }

    @JsonProperty(value="phoneType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
        this.isSetPhoneType = true;
    }

    public PhoneNumber includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber phoneNumber = (PhoneNumber)o;
        return Objects.equals(this.phoneCountryCode, phoneNumber.phoneCountryCode) && Objects.equals(this.isSetPhoneCountryCode, phoneNumber.isSetPhoneCountryCode) && Objects.equals(this.phoneNumber, phoneNumber.phoneNumber) && Objects.equals(this.isSetPhoneNumber, phoneNumber.isSetPhoneNumber) && Objects.equals((Object)this.phoneType, (Object)phoneNumber.phoneType) && Objects.equals(this.isSetPhoneType, phoneNumber.isSetPhoneType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.phoneCountryCode, this.isSetPhoneCountryCode, this.phoneNumber, this.isSetPhoneNumber, this.phoneType, this.isSetPhoneType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneNumber {\n");
        sb.append("    phoneCountryCode: ").append(this.toIndentedString(this.phoneCountryCode)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    phoneType: ").append(this.toIndentedString((Object)this.phoneType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetPhoneCountryCode) {
            this.addIfNull(nulls, JSON_PROPERTY_PHONE_COUNTRY_CODE, this.phoneCountryCode);
        }
        if (this.isSetPhoneNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_PHONE_NUMBER, this.phoneNumber);
        }
        if (this.isSetPhoneType) {
            this.addIfNull(nulls, JSON_PROPERTY_PHONE_TYPE, (Object)this.phoneType);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PhoneNumber fromJson(String jsonString) throws JsonProcessingException {
        return (PhoneNumber)JSON.getMapper().readValue(jsonString, PhoneNumber.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PhoneTypeEnum {
        FAX(String.valueOf("Fax")),
        LANDLINE(String.valueOf("Landline")),
        MOBILE(String.valueOf("Mobile")),
        SIP(String.valueOf("SIP"));

        private static final Logger LOG;
        private String value;

        private PhoneTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PhoneTypeEnum fromValue(String value) {
            for (PhoneTypeEnum b : PhoneTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PhoneTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PhoneTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PhoneTypeEnum.class.getName());
        }
    }
}

