/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Address;
import com.adyen.model.payout.Card;
import com.adyen.model.payout.JSON;
import com.adyen.model.payout.Name;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "billingAddress", "card", "shopperEmail", "shopperName", "telephoneNumber"})
public class FundSource {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    public static final String JSON_PROPERTY_CARD = "card";
    private Card card;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;

    public FundSource additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public FundSource putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public FundSource billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public FundSource card(Card card) {
        this.card = card;
        return this;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Card getCard() {
        return this.card;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCard(Card card) {
        this.card = card;
    }

    public FundSource shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public FundSource shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public FundSource telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundSource fundSource = (FundSource)o;
        return Objects.equals(this.additionalData, fundSource.additionalData) && Objects.equals(this.billingAddress, fundSource.billingAddress) && Objects.equals(this.card, fundSource.card) && Objects.equals(this.shopperEmail, fundSource.shopperEmail) && Objects.equals(this.shopperName, fundSource.shopperName) && Objects.equals(this.telephoneNumber, fundSource.telephoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.billingAddress, this.card, this.shopperEmail, this.shopperName, this.telephoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundSource {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FundSource fromJson(String jsonString) throws JsonProcessingException {
        return (FundSource)JSON.getMapper().readValue(jsonString, FundSource.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

