/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"capabilities", "entityIds", "expiresAt"})
public class VerificationDeadline {
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private List<CapabilitiesEnum> capabilities;
    public static final String JSON_PROPERTY_ENTITY_IDS = "entityIds";
    private List<String> entityIds;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public VerificationDeadline() {
    }

    @JsonCreator
    public VerificationDeadline(@JsonProperty(value="capabilities") List<CapabilitiesEnum> capabilities, @JsonProperty(value="entityIds") List<String> entityIds, @JsonProperty(value="expiresAt") OffsetDateTime expiresAt) {
        this();
        this.capabilities = capabilities;
        this.entityIds = entityIds;
        this.expiresAt = expiresAt;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilitiesEnum> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="entityIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEntityIds() {
        return this.entityIds;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationDeadline verificationDeadline = (VerificationDeadline)o;
        return Objects.equals(this.capabilities, verificationDeadline.capabilities) && Objects.equals(this.entityIds, verificationDeadline.entityIds) && Objects.equals(this.expiresAt, verificationDeadline.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.entityIds, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationDeadline {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    entityIds: ").append(this.toIndentedString(this.entityIds)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static VerificationDeadline fromJson(String jsonString) throws JsonProcessingException {
        return (VerificationDeadline)JSON.getMapper().readValue(jsonString, VerificationDeadline.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum CapabilitiesEnum {
        ACCEPTEXTERNALFUNDING(String.valueOf("acceptExternalFunding")),
        ACCEPTPSPFUNDING(String.valueOf("acceptPspFunding")),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIES(String.valueOf("acceptTransactionInRestrictedCountries")),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("acceptTransactionInRestrictedCountriesCommercial")),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("acceptTransactionInRestrictedCountriesConsumer")),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIES(String.valueOf("acceptTransactionInRestrictedIndustries")),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCOMMERCIAL(String.valueOf("acceptTransactionInRestrictedIndustriesCommercial")),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCONSUMER(String.valueOf("acceptTransactionInRestrictedIndustriesConsumer")),
        ACQUIRING(String.valueOf("acquiring")),
        ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
        ATMWITHDRAWALCOMMERCIAL(String.valueOf("atmWithdrawalCommercial")),
        ATMWITHDRAWALCONSUMER(String.valueOf("atmWithdrawalConsumer")),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIES(String.valueOf("atmWithdrawalInRestrictedCountries")),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("atmWithdrawalInRestrictedCountriesCommercial")),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("atmWithdrawalInRestrictedCountriesConsumer")),
        AUTHORISEDPAYMENTINSTRUMENTUSER(String.valueOf("authorisedPaymentInstrumentUser")),
        GETGRANTOFFERS(String.valueOf("getGrantOffers")),
        ISSUEBANKACCOUNT(String.valueOf("issueBankAccount")),
        ISSUECARD(String.valueOf("issueCard")),
        ISSUECARDCOMMERCIAL(String.valueOf("issueCardCommercial")),
        ISSUECARDCONSUMER(String.valueOf("issueCardConsumer")),
        ISSUECHARGECARD(String.valueOf("issueChargeCard")),
        ISSUECHARGECARDCOMMERCIAL(String.valueOf("issueChargeCardCommercial")),
        ISSUECREDITLIMIT(String.valueOf("issueCreditLimit")),
        LOCALACCEPTANCE(String.valueOf("localAcceptance")),
        PAYOUT(String.valueOf("payout")),
        PAYOUTTOTRANSFERINSTRUMENT(String.valueOf("payoutToTransferInstrument")),
        PROCESSING(String.valueOf("processing")),
        RECEIVEFROMBALANCEACCOUNT(String.valueOf("receiveFromBalanceAccount")),
        RECEIVEFROMPLATFORMPAYMENTS(String.valueOf("receiveFromPlatformPayments")),
        RECEIVEFROMTHIRDPARTY(String.valueOf("receiveFromThirdParty")),
        RECEIVEFROMTRANSFERINSTRUMENT(String.valueOf("receiveFromTransferInstrument")),
        RECEIVEGRANTS(String.valueOf("receiveGrants")),
        RECEIVEPAYMENTS(String.valueOf("receivePayments")),
        SENDTOBALANCEACCOUNT(String.valueOf("sendToBalanceAccount")),
        SENDTOTHIRDPARTY(String.valueOf("sendToThirdParty")),
        SENDTOTRANSFERINSTRUMENT(String.valueOf("sendToTransferInstrument")),
        THIRDPARTYFUNDING(String.valueOf("thirdPartyFunding")),
        USECARD(String.valueOf("useCard")),
        USECARDCOMMERCIAL(String.valueOf("useCardCommercial")),
        USECARDCONSUMER(String.valueOf("useCardConsumer")),
        USECARDINRESTRICTEDCOUNTRIES(String.valueOf("useCardInRestrictedCountries")),
        USECARDINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("useCardInRestrictedCountriesCommercial")),
        USECARDINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("useCardInRestrictedCountriesConsumer")),
        USECARDINRESTRICTEDINDUSTRIES(String.valueOf("useCardInRestrictedIndustries")),
        USECARDINRESTRICTEDINDUSTRIESCOMMERCIAL(String.valueOf("useCardInRestrictedIndustriesCommercial")),
        USECARDINRESTRICTEDINDUSTRIESCONSUMER(String.valueOf("useCardInRestrictedIndustriesConsumer")),
        USECHARGECARD(String.valueOf("useChargeCard")),
        USECHARGECARDCOMMERCIAL(String.valueOf("useChargeCardCommercial")),
        WITHDRAWFROMATM(String.valueOf("withdrawFromAtm")),
        WITHDRAWFROMATMCOMMERCIAL(String.valueOf("withdrawFromAtmCommercial")),
        WITHDRAWFROMATMCONSUMER(String.valueOf("withdrawFromAtmConsumer")),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIES(String.valueOf("withdrawFromAtmInRestrictedCountries")),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCOMMERCIAL(String.valueOf("withdrawFromAtmInRestrictedCountriesCommercial")),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCONSUMER(String.valueOf("withdrawFromAtmInRestrictedCountriesConsumer"));

        private static final Logger LOG;
        private String value;

        private CapabilitiesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CapabilitiesEnum fromValue(String value) {
            for (CapabilitiesEnum b : CapabilitiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("CapabilitiesEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])CapabilitiesEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(CapabilitiesEnum.class.getName());
        }
    }
}

