/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Airline;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.Lodging;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"airline", "lodging", "type"})
public class MerchantPurchaseData {
    public static final String JSON_PROPERTY_AIRLINE = "airline";
    private Airline airline;
    public static final String JSON_PROPERTY_LODGING = "lodging";
    private List<Lodging> lodging;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.MERCHANTPURCHASEDATA;

    public MerchantPurchaseData airline(Airline airline) {
        this.airline = airline;
        return this;
    }

    @JsonProperty(value="airline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Airline getAirline() {
        return this.airline;
    }

    @JsonProperty(value="airline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAirline(Airline airline) {
        this.airline = airline;
    }

    public MerchantPurchaseData lodging(List<Lodging> lodging) {
        this.lodging = lodging;
        return this;
    }

    public MerchantPurchaseData addLodgingItem(Lodging lodgingItem) {
        if (this.lodging == null) {
            this.lodging = new ArrayList<Lodging>();
        }
        this.lodging.add(lodgingItem);
        return this;
    }

    @JsonProperty(value="lodging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Lodging> getLodging() {
        return this.lodging;
    }

    @JsonProperty(value="lodging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLodging(List<Lodging> lodging) {
        this.lodging = lodging;
    }

    public MerchantPurchaseData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantPurchaseData merchantPurchaseData = (MerchantPurchaseData)o;
        return Objects.equals(this.airline, merchantPurchaseData.airline) && Objects.equals(this.lodging, merchantPurchaseData.lodging) && Objects.equals((Object)this.type, (Object)merchantPurchaseData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.airline, this.lodging, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantPurchaseData {\n");
        sb.append("    airline: ").append(this.toIndentedString(this.airline)).append("\n");
        sb.append("    lodging: ").append(this.toIndentedString(this.lodging)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MerchantPurchaseData fromJson(String jsonString) throws JsonProcessingException {
        return (MerchantPurchaseData)JSON.getMapper().readValue(jsonString, MerchantPurchaseData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        MERCHANTPURCHASEDATA(String.valueOf("merchantPurchaseData"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

