/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transactionwebhooks;

import com.adyen.model.transactionwebhooks.JSON;
import com.adyen.model.transactionwebhooks.TransactionNotificationRequestV4;
import java.util.Optional;
import java.util.logging.Logger;

public class TransactionWebhooksHandler {
    private static final Logger LOG = Logger.getLogger(TransactionWebhooksHandler.class.getName());
    private final String payload;

    public TransactionWebhooksHandler(String payload) {
        this.payload = payload;
    }

    public Optional<TransactionNotificationRequestV4> getTransactionNotificationRequestV4() {
        return this.getOptionalField(TransactionNotificationRequestV4.class);
    }

    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            Object val = JSON.getMapper().readValue(this.payload, clazz);
            return Optional.ofNullable(val);
        }
        catch (Exception e) {
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }
}

