/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.NetworkTokenNotificationDataV2;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "environment", "timestamp", "type"})
public class NetworkTokenNotificationRequest {
    public static final String JSON_PROPERTY_DATA = "data";
    private NetworkTokenNotificationDataV2 data;
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    private String environment;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private OffsetDateTime timestamp;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public NetworkTokenNotificationRequest data(NetworkTokenNotificationDataV2 data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkTokenNotificationDataV2 getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(NetworkTokenNotificationDataV2 data) {
        this.data = data;
    }

    public NetworkTokenNotificationRequest environment(String environment) {
        this.environment = environment;
        return this;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public NetworkTokenNotificationRequest timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public NetworkTokenNotificationRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkTokenNotificationRequest networkTokenNotificationRequest = (NetworkTokenNotificationRequest)o;
        return Objects.equals(this.data, networkTokenNotificationRequest.data) && Objects.equals(this.environment, networkTokenNotificationRequest.environment) && Objects.equals(this.timestamp, networkTokenNotificationRequest.timestamp) && Objects.equals((Object)this.type, (Object)networkTokenNotificationRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.environment, this.timestamp, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkTokenNotificationRequest {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static NetworkTokenNotificationRequest fromJson(String jsonString) throws JsonProcessingException {
        return (NetworkTokenNotificationRequest)JSON.getMapper().readValue(jsonString, NetworkTokenNotificationRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BALANCEPLATFORM_NETWORKTOKEN_CREATED(String.valueOf("balancePlatform.networkToken.created")),
        BALANCEPLATFORM_NETWORKTOKEN_UPDATED(String.valueOf("balancePlatform.networkToken.updated"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

