/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.Amount;
import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.OperationStatus;
import com.adyen.model.marketpaywebhooks.Split;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "amount", "debitInitiationDate", "invalidFields", "merchantAccountCode", "splits", "status"})
public class DirectDebitInitiatedNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_DEBIT_INITIATION_DATE = "debitInitiationDate";
    private LocalDate debitInitiationDate;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
    private String merchantAccountCode;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private OperationStatus status;

    public DirectDebitInitiatedNotificationContent accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public DirectDebitInitiatedNotificationContent amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public DirectDebitInitiatedNotificationContent debitInitiationDate(LocalDate debitInitiationDate) {
        this.debitInitiationDate = debitInitiationDate;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="debitInitiationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDebitInitiationDate() {
        return this.debitInitiationDate;
    }

    @JsonProperty(value="debitInitiationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDebitInitiationDate(LocalDate debitInitiationDate) {
        this.debitInitiationDate = debitInitiationDate;
    }

    public DirectDebitInitiatedNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public DirectDebitInitiatedNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Invalid fields list.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public DirectDebitInitiatedNotificationContent merchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the merchant account.")
    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccountCode() {
        return this.merchantAccountCode;
    }

    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
    }

    public DirectDebitInitiatedNotificationContent splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public DirectDebitInitiatedNotificationContent addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="The split data for the debit request.")
    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public DirectDebitInitiatedNotificationContent status(OperationStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OperationStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(OperationStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectDebitInitiatedNotificationContent directDebitInitiatedNotificationContent = (DirectDebitInitiatedNotificationContent)o;
        return Objects.equals(this.accountCode, directDebitInitiatedNotificationContent.accountCode) && Objects.equals(this.amount, directDebitInitiatedNotificationContent.amount) && Objects.equals(this.debitInitiationDate, directDebitInitiatedNotificationContent.debitInitiationDate) && Objects.equals(this.invalidFields, directDebitInitiatedNotificationContent.invalidFields) && Objects.equals(this.merchantAccountCode, directDebitInitiatedNotificationContent.merchantAccountCode) && Objects.equals(this.splits, directDebitInitiatedNotificationContent.splits) && Objects.equals(this.status, directDebitInitiatedNotificationContent.status);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.amount, this.debitInitiationDate, this.invalidFields, this.merchantAccountCode, this.splits, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectDebitInitiatedNotificationContent {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    debitInitiationDate: ").append(this.toIndentedString(this.debitInitiationDate)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    merchantAccountCode: ").append(this.toIndentedString(this.merchantAccountCode)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DirectDebitInitiatedNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (DirectDebitInitiatedNotificationContent)JSON.getMapper().readValue(jsonString, DirectDebitInitiatedNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

