/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

@JsonPropertyOrder(value={"allowed", "enabled", "enabledFromDate", "id", "priority", "transferInstrumentId", "verificationStatus"})
public class PayoutSettings {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_ENABLED_FROM_DATE = "enabledFromDate";
    private String enabledFromDate;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private PriorityEnum priority;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    private String transferInstrumentId;
    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private VerificationStatusEnum verificationStatus;

    public PayoutSettings allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public PayoutSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PayoutSettings enabledFromDate(String enabledFromDate) {
        this.enabledFromDate = enabledFromDate;
        return this;
    }

    @JsonProperty(value="enabledFromDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnabledFromDate() {
        return this.enabledFromDate;
    }

    @JsonProperty(value="enabledFromDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabledFromDate(String enabledFromDate) {
        this.enabledFromDate = enabledFromDate;
    }

    public PayoutSettings id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public PayoutSettings priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public PayoutSettings transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public PayoutSettings verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutSettings payoutSettings = (PayoutSettings)o;
        return Objects.equals(this.allowed, payoutSettings.allowed) && Objects.equals(this.enabled, payoutSettings.enabled) && Objects.equals(this.enabledFromDate, payoutSettings.enabledFromDate) && Objects.equals(this.id, payoutSettings.id) && Objects.equals((Object)this.priority, (Object)payoutSettings.priority) && Objects.equals(this.transferInstrumentId, payoutSettings.transferInstrumentId) && Objects.equals((Object)this.verificationStatus, (Object)payoutSettings.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowed, this.enabled, this.enabledFromDate, this.id, this.priority, this.transferInstrumentId, this.verificationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutSettings {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    enabledFromDate: ").append(this.toIndentedString(this.enabledFromDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayoutSettings fromJson(String jsonString) throws JsonProcessingException {
        return (PayoutSettings)JSON.getMapper().readValue(jsonString, PayoutSettings.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum VerificationStatusEnum {
        INVALID(String.valueOf("invalid")),
        PENDING(String.valueOf("pending")),
        REJECTED(String.valueOf("rejected")),
        VALID(String.valueOf("valid"));

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PriorityEnum {
        FIRST(String.valueOf("first")),
        NORMAL(String.valueOf("normal")),
        URGENT(String.valueOf("urgent"));

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

