/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"arrivalAirportCode", "basicFareCode", "carrierCode", "departureAirportCode", "departureDate", "flightNumber"})
public class Leg {
    public static final String JSON_PROPERTY_ARRIVAL_AIRPORT_CODE = "arrivalAirportCode";
    private String arrivalAirportCode;
    public static final String JSON_PROPERTY_BASIC_FARE_CODE = "basicFareCode";
    private String basicFareCode;
    public static final String JSON_PROPERTY_CARRIER_CODE = "carrierCode";
    private String carrierCode;
    public static final String JSON_PROPERTY_DEPARTURE_AIRPORT_CODE = "departureAirportCode";
    private String departureAirportCode;
    public static final String JSON_PROPERTY_DEPARTURE_DATE = "departureDate";
    private String departureDate;
    public static final String JSON_PROPERTY_FLIGHT_NUMBER = "flightNumber";
    private String flightNumber;

    public Leg arrivalAirportCode(String arrivalAirportCode) {
        this.arrivalAirportCode = arrivalAirportCode;
        return this;
    }

    @ApiModelProperty(value="The IATA 3-letter airport code of the destination airport. This field is required if the airline data includes leg details.")
    @JsonProperty(value="arrivalAirportCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArrivalAirportCode() {
        return this.arrivalAirportCode;
    }

    @JsonProperty(value="arrivalAirportCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArrivalAirportCode(String arrivalAirportCode) {
        this.arrivalAirportCode = arrivalAirportCode;
    }

    public Leg basicFareCode(String basicFareCode) {
        this.basicFareCode = basicFareCode;
        return this;
    }

    @ApiModelProperty(value="The basic fare code for this leg.")
    @JsonProperty(value="basicFareCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBasicFareCode() {
        return this.basicFareCode;
    }

    @JsonProperty(value="basicFareCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBasicFareCode(String basicFareCode) {
        this.basicFareCode = basicFareCode;
    }

    public Leg carrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
        return this;
    }

    @ApiModelProperty(value="IATA code of the carrier operating the flight.")
    @JsonProperty(value="carrierCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCarrierCode() {
        return this.carrierCode;
    }

    @JsonProperty(value="carrierCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public Leg departureAirportCode(String departureAirportCode) {
        this.departureAirportCode = departureAirportCode;
        return this;
    }

    @ApiModelProperty(value="The IATA three-letter airport code of the departure airport. This field is required if the airline data includes leg details")
    @JsonProperty(value="departureAirportCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDepartureAirportCode() {
        return this.departureAirportCode;
    }

    @JsonProperty(value="departureAirportCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDepartureAirportCode(String departureAirportCode) {
        this.departureAirportCode = departureAirportCode;
    }

    public Leg departureDate(String departureDate) {
        this.departureDate = departureDate;
        return this;
    }

    @ApiModelProperty(value="The flight departure date.")
    @JsonProperty(value="departureDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDepartureDate() {
        return this.departureDate;
    }

    @JsonProperty(value="departureDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDepartureDate(String departureDate) {
        this.departureDate = departureDate;
    }

    public Leg flightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
        return this;
    }

    @ApiModelProperty(value="The flight identifier.")
    @JsonProperty(value="flightNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFlightNumber() {
        return this.flightNumber;
    }

    @JsonProperty(value="flightNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Leg leg = (Leg)o;
        return Objects.equals(this.arrivalAirportCode, leg.arrivalAirportCode) && Objects.equals(this.basicFareCode, leg.basicFareCode) && Objects.equals(this.carrierCode, leg.carrierCode) && Objects.equals(this.departureAirportCode, leg.departureAirportCode) && Objects.equals(this.departureDate, leg.departureDate) && Objects.equals(this.flightNumber, leg.flightNumber);
    }

    public int hashCode() {
        return Objects.hash(this.arrivalAirportCode, this.basicFareCode, this.carrierCode, this.departureAirportCode, this.departureDate, this.flightNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Leg {\n");
        sb.append("    arrivalAirportCode: ").append(this.toIndentedString(this.arrivalAirportCode)).append("\n");
        sb.append("    basicFareCode: ").append(this.toIndentedString(this.basicFareCode)).append("\n");
        sb.append("    carrierCode: ").append(this.toIndentedString(this.carrierCode)).append("\n");
        sb.append("    departureAirportCode: ").append(this.toIndentedString(this.departureAirportCode)).append("\n");
        sb.append("    departureDate: ").append(this.toIndentedString(this.departureDate)).append("\n");
        sb.append("    flightNumber: ").append(this.toIndentedString(this.flightNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Leg fromJson(String jsonString) throws JsonProcessingException {
        return (Leg)JSON.getMapper().readValue(jsonString, Leg.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

