/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.DocumentDetail;
import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;

@JsonPropertyOrder(value={"documentContent", "documentDetail"})
public class UploadDocumentRequest {
    public static final String JSON_PROPERTY_DOCUMENT_CONTENT = "documentContent";
    private byte[] documentContent;
    public static final String JSON_PROPERTY_DOCUMENT_DETAIL = "documentDetail";
    private DocumentDetail documentDetail;

    public UploadDocumentRequest documentContent(byte[] documentContent) {
        this.documentContent = documentContent;
        return this;
    }

    @ApiModelProperty(required=true, value="The content of the document, in Base64-encoded string format.  To learn about document requirements, refer to [Verification checks](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks).")
    @JsonProperty(value="documentContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getDocumentContent() {
        return this.documentContent;
    }

    @JsonProperty(value="documentContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentContent(byte[] documentContent) {
        this.documentContent = documentContent;
    }

    public UploadDocumentRequest documentDetail(DocumentDetail documentDetail) {
        this.documentDetail = documentDetail;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="documentDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DocumentDetail getDocumentDetail() {
        return this.documentDetail;
    }

    @JsonProperty(value="documentDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentDetail(DocumentDetail documentDetail) {
        this.documentDetail = documentDetail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadDocumentRequest uploadDocumentRequest = (UploadDocumentRequest)o;
        return Arrays.equals(this.documentContent, uploadDocumentRequest.documentContent) && Objects.equals(this.documentDetail, uploadDocumentRequest.documentDetail);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.documentContent), this.documentDetail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadDocumentRequest {\n");
        sb.append("    documentContent: ").append(this.toIndentedString(this.documentContent)).append("\n");
        sb.append("    documentDetail: ").append(this.toIndentedString(this.documentDetail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UploadDocumentRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UploadDocumentRequest)JSON.getMapper().readValue(jsonString, UploadDocumentRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

