/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.AccountHolderCapability;
import com.adyen.model.balanceplatform.ContactDetails;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.VerificationDeadline;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"balancePlatform", "capabilities", "contactDetails", "description", "metadata", "migratedAccountHolderCode", "primaryBalanceAccount", "reference", "status", "timeZone", "verificationDeadlines"})
public class AccountHolderUpdateRequest {
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, AccountHolderCapability> capabilities = null;
    public static final String JSON_PROPERTY_CONTACT_DETAILS = "contactDetails";
    @Deprecated
    private ContactDetails contactDetails;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_MIGRATED_ACCOUNT_HOLDER_CODE = "migratedAccountHolderCode";
    private String migratedAccountHolderCode;
    public static final String JSON_PROPERTY_PRIMARY_BALANCE_ACCOUNT = "primaryBalanceAccount";
    private String primaryBalanceAccount;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TIME_ZONE = "timeZone";
    private String timeZone;
    public static final String JSON_PROPERTY_VERIFICATION_DEADLINES = "verificationDeadlines";
    private List<VerificationDeadline> verificationDeadlines = null;

    public AccountHolderUpdateRequest balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [balance platform](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balancePlatforms/{id}__queryParam_id) to which the account holder belongs. Required in the request if your API credentials can be used for multiple balance platforms.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public AccountHolderUpdateRequest capabilities(Map<String, AccountHolderCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public AccountHolderUpdateRequest putCapabilitiesItem(String key, AccountHolderCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, AccountHolderCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that an account holder can do in your platform. The key is a capability required for your integration. For example, **issueCard** for Issuing. The value is an object containing the settings for the capability.")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, AccountHolderCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(Map<String, AccountHolderCapability> capabilities) {
        this.capabilities = capabilities;
    }

    @Deprecated
    public AccountHolderUpdateRequest contactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="")
    @JsonProperty(value="contactDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactDetails getContactDetails() {
        return this.contactDetails;
    }

    @Deprecated
    @JsonProperty(value="contactDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
    }

    public AccountHolderUpdateRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the account holder.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public AccountHolderUpdateRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public AccountHolderUpdateRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public AccountHolderUpdateRequest migratedAccountHolderCode(String migratedAccountHolderCode) {
        this.migratedAccountHolderCode = migratedAccountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the migrated account holder in the classic integration.")
    @JsonProperty(value="migratedAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMigratedAccountHolderCode() {
        return this.migratedAccountHolderCode;
    }

    @JsonProperty(value="migratedAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigratedAccountHolderCode(String migratedAccountHolderCode) {
        this.migratedAccountHolderCode = migratedAccountHolderCode;
    }

    public AccountHolderUpdateRequest primaryBalanceAccount(String primaryBalanceAccount) {
        this.primaryBalanceAccount = primaryBalanceAccount;
        return this;
    }

    @ApiModelProperty(value="The ID of the account holder's primary balance account. By default, this is set to the first balance account that you create for the account holder. To assign a different balance account, send a PATCH request.")
    @JsonProperty(value="primaryBalanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrimaryBalanceAccount() {
        return this.primaryBalanceAccount;
    }

    @JsonProperty(value="primaryBalanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryBalanceAccount(String primaryBalanceAccount) {
        this.primaryBalanceAccount = primaryBalanceAccount;
    }

    public AccountHolderUpdateRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the account holder.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public AccountHolderUpdateRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the account holder.  Possible values:    * **active**: The account holder is active and allowed to use its capabilities. This is the initial status for account holders and balance accounts. You can change this status to **suspended** or **closed**.    * **suspended**: The account holder is temporarily disabled and payouts are blocked. You can change this status to **active** or **closed**.   * **closed**: The account holder and all of its capabilities are permanently disabled. This is a final status and cannot be changed.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AccountHolderUpdateRequest timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The time zone of the account holder. For example, **Europe/Amsterdam**. Defaults to the time zone of the balance platform if no time zone is set. For possible values, see the [list of time zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).")
    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public AccountHolderUpdateRequest verificationDeadlines(List<VerificationDeadline> verificationDeadlines) {
        this.verificationDeadlines = verificationDeadlines;
        return this;
    }

    public AccountHolderUpdateRequest addVerificationDeadlinesItem(VerificationDeadline verificationDeadlinesItem) {
        if (this.verificationDeadlines == null) {
            this.verificationDeadlines = new ArrayList<VerificationDeadline>();
        }
        this.verificationDeadlines.add(verificationDeadlinesItem);
        return this;
    }

    @ApiModelProperty(value="List of verification deadlines and the capabilities that will be disallowed if verification errors are not resolved.")
    @JsonProperty(value="verificationDeadlines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VerificationDeadline> getVerificationDeadlines() {
        return this.verificationDeadlines;
    }

    @JsonProperty(value="verificationDeadlines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationDeadlines(List<VerificationDeadline> verificationDeadlines) {
        this.verificationDeadlines = verificationDeadlines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderUpdateRequest accountHolderUpdateRequest = (AccountHolderUpdateRequest)o;
        return Objects.equals(this.balancePlatform, accountHolderUpdateRequest.balancePlatform) && Objects.equals(this.capabilities, accountHolderUpdateRequest.capabilities) && Objects.equals(this.contactDetails, accountHolderUpdateRequest.contactDetails) && Objects.equals(this.description, accountHolderUpdateRequest.description) && Objects.equals(this.metadata, accountHolderUpdateRequest.metadata) && Objects.equals(this.migratedAccountHolderCode, accountHolderUpdateRequest.migratedAccountHolderCode) && Objects.equals(this.primaryBalanceAccount, accountHolderUpdateRequest.primaryBalanceAccount) && Objects.equals(this.reference, accountHolderUpdateRequest.reference) && Objects.equals((Object)this.status, (Object)accountHolderUpdateRequest.status) && Objects.equals(this.timeZone, accountHolderUpdateRequest.timeZone) && Objects.equals(this.verificationDeadlines, accountHolderUpdateRequest.verificationDeadlines);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balancePlatform, this.capabilities, this.contactDetails, this.description, this.metadata, this.migratedAccountHolderCode, this.primaryBalanceAccount, this.reference, this.status, this.timeZone, this.verificationDeadlines});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderUpdateRequest {\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    contactDetails: ").append(this.toIndentedString(this.contactDetails)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    migratedAccountHolderCode: ").append(this.toIndentedString(this.migratedAccountHolderCode)).append("\n");
        sb.append("    primaryBalanceAccount: ").append(this.toIndentedString(this.primaryBalanceAccount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    verificationDeadlines: ").append(this.toIndentedString(this.verificationDeadlines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderUpdateRequest fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderUpdateRequest)JSON.getMapper().readValue(jsonString, AccountHolderUpdateRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        SUSPENDED("suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

