/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.CapabilityProblem;
import com.adyen.model.legalentitymanagement.DocumentReference;
import com.adyen.model.legalentitymanagement.EntityReference;
import com.adyen.model.legalentitymanagement.Individual;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.LegalEntityAssociation;
import com.adyen.model.legalentitymanagement.LegalEntityCapability;
import com.adyen.model.legalentitymanagement.Organization;
import com.adyen.model.legalentitymanagement.SoleProprietorship;
import com.adyen.model.legalentitymanagement.TransferInstrumentReference;
import com.adyen.model.legalentitymanagement.Trust;
import com.adyen.model.legalentitymanagement.UnincorporatedPartnership;
import com.adyen.model.legalentitymanagement.VerificationDeadline;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"capabilities", "documentDetails", "documents", "entityAssociations", "id", "individual", "organization", "problems", "reference", "soleProprietorship", "transferInstruments", "trust", "type", "unincorporatedPartnership", "verificationDeadlines", "verificationPlan"})
public class LegalEntity {
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, LegalEntityCapability> capabilities = new HashMap<String, LegalEntityCapability>();
    public static final String JSON_PROPERTY_DOCUMENT_DETAILS = "documentDetails";
    private List<DocumentReference> documentDetails = new ArrayList<DocumentReference>();
    public static final String JSON_PROPERTY_DOCUMENTS = "documents";
    @Deprecated
    private List<EntityReference> documents = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_ENTITY_ASSOCIATIONS = "entityAssociations";
    private List<LegalEntityAssociation> entityAssociations = new ArrayList<LegalEntityAssociation>();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
    private Individual individual;
    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    private Organization organization;
    public static final String JSON_PROPERTY_PROBLEMS = "problems";
    private List<CapabilityProblem> problems = new ArrayList<CapabilityProblem>();
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SOLE_PROPRIETORSHIP = "soleProprietorship";
    private SoleProprietorship soleProprietorship;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENTS = "transferInstruments";
    private List<TransferInstrumentReference> transferInstruments = new ArrayList<TransferInstrumentReference>();
    public static final String JSON_PROPERTY_TRUST = "trust";
    private Trust trust;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_UNINCORPORATED_PARTNERSHIP = "unincorporatedPartnership";
    private UnincorporatedPartnership unincorporatedPartnership;
    public static final String JSON_PROPERTY_VERIFICATION_DEADLINES = "verificationDeadlines";
    private List<VerificationDeadline> verificationDeadlines = new ArrayList<VerificationDeadline>();
    public static final String JSON_PROPERTY_VERIFICATION_PLAN = "verificationPlan";
    private String verificationPlan;

    public LegalEntity() {
    }

    @JsonCreator
    public LegalEntity(@JsonProperty(value="capabilities") Map<String, LegalEntityCapability> capabilities, @JsonProperty(value="id") String id, @JsonProperty(value="transferInstruments") List<TransferInstrumentReference> transferInstruments, @JsonProperty(value="verificationDeadlines") List<VerificationDeadline> verificationDeadlines) {
        this();
        this.capabilities = capabilities;
        this.id = id;
        this.transferInstruments = transferInstruments;
        this.verificationDeadlines = verificationDeadlines;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, LegalEntityCapability> getCapabilities() {
        return this.capabilities;
    }

    public LegalEntity documentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
        return this;
    }

    public LegalEntity addDocumentDetailsItem(DocumentReference documentDetailsItem) {
        if (this.documentDetails == null) {
            this.documentDetails = new ArrayList<DocumentReference>();
        }
        this.documentDetails.add(documentDetailsItem);
        return this;
    }

    @JsonProperty(value="documentDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocumentReference> getDocumentDetails() {
        return this.documentDetails;
    }

    @JsonProperty(value="documentDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
    }

    @Deprecated
    public LegalEntity documents(List<EntityReference> documents) {
        this.documents = documents;
        return this;
    }

    public LegalEntity addDocumentsItem(EntityReference documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<EntityReference>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Deprecated
    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDocuments() {
        return this.documents;
    }

    @Deprecated
    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocuments(List<EntityReference> documents) {
        this.documents = documents;
    }

    public LegalEntity entityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        return this;
    }

    public LegalEntity addEntityAssociationsItem(LegalEntityAssociation entityAssociationsItem) {
        if (this.entityAssociations == null) {
            this.entityAssociations = new ArrayList<LegalEntityAssociation>();
        }
        this.entityAssociations.add(entityAssociationsItem);
        return this;
    }

    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalEntityAssociation> getEntityAssociations() {
        return this.entityAssociations;
    }

    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public LegalEntity individual(Individual individual) {
        this.individual = individual;
        return this;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Individual getIndividual() {
        return this.individual;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividual(Individual individual) {
        this.individual = individual;
    }

    public LegalEntity organization(Organization organization) {
        this.organization = organization;
        return this;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Organization getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public LegalEntity problems(List<CapabilityProblem> problems) {
        this.problems = problems;
        return this;
    }

    public LegalEntity addProblemsItem(CapabilityProblem problemsItem) {
        if (this.problems == null) {
            this.problems = new ArrayList<CapabilityProblem>();
        }
        this.problems.add(problemsItem);
        return this;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilityProblem> getProblems() {
        return this.problems;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProblems(List<CapabilityProblem> problems) {
        this.problems = problems;
    }

    public LegalEntity reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public LegalEntity soleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        return this;
    }

    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SoleProprietorship getSoleProprietorship() {
        return this.soleProprietorship;
    }

    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSoleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
    }

    @JsonProperty(value="transferInstruments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferInstrumentReference> getTransferInstruments() {
        return this.transferInstruments;
    }

    public LegalEntity trust(Trust trust) {
        this.trust = trust;
        return this;
    }

    @JsonProperty(value="trust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Trust getTrust() {
        return this.trust;
    }

    @JsonProperty(value="trust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrust(Trust trust) {
        this.trust = trust;
    }

    public LegalEntity type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LegalEntity unincorporatedPartnership(UnincorporatedPartnership unincorporatedPartnership) {
        this.unincorporatedPartnership = unincorporatedPartnership;
        return this;
    }

    @JsonProperty(value="unincorporatedPartnership")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UnincorporatedPartnership getUnincorporatedPartnership() {
        return this.unincorporatedPartnership;
    }

    @JsonProperty(value="unincorporatedPartnership")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnincorporatedPartnership(UnincorporatedPartnership unincorporatedPartnership) {
        this.unincorporatedPartnership = unincorporatedPartnership;
    }

    @JsonProperty(value="verificationDeadlines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<VerificationDeadline> getVerificationDeadlines() {
        return this.verificationDeadlines;
    }

    public LegalEntity verificationPlan(String verificationPlan) {
        this.verificationPlan = verificationPlan;
        return this;
    }

    @JsonProperty(value="verificationPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationPlan() {
        return this.verificationPlan;
    }

    @JsonProperty(value="verificationPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationPlan(String verificationPlan) {
        this.verificationPlan = verificationPlan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntity legalEntity = (LegalEntity)o;
        return Objects.equals(this.capabilities, legalEntity.capabilities) && Objects.equals(this.documentDetails, legalEntity.documentDetails) && Objects.equals(this.documents, legalEntity.documents) && Objects.equals(this.entityAssociations, legalEntity.entityAssociations) && Objects.equals(this.id, legalEntity.id) && Objects.equals(this.individual, legalEntity.individual) && Objects.equals(this.organization, legalEntity.organization) && Objects.equals(this.problems, legalEntity.problems) && Objects.equals(this.reference, legalEntity.reference) && Objects.equals(this.soleProprietorship, legalEntity.soleProprietorship) && Objects.equals(this.transferInstruments, legalEntity.transferInstruments) && Objects.equals(this.trust, legalEntity.trust) && Objects.equals((Object)this.type, (Object)legalEntity.type) && Objects.equals(this.unincorporatedPartnership, legalEntity.unincorporatedPartnership) && Objects.equals(this.verificationDeadlines, legalEntity.verificationDeadlines) && Objects.equals(this.verificationPlan, legalEntity.verificationPlan);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.documentDetails, this.documents, this.entityAssociations, this.id, this.individual, this.organization, this.problems, this.reference, this.soleProprietorship, this.transferInstruments, this.trust, this.type, this.unincorporatedPartnership, this.verificationDeadlines, this.verificationPlan});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntity {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    documentDetails: ").append(this.toIndentedString(this.documentDetails)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    entityAssociations: ").append(this.toIndentedString(this.entityAssociations)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    problems: ").append(this.toIndentedString(this.problems)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    soleProprietorship: ").append(this.toIndentedString(this.soleProprietorship)).append("\n");
        sb.append("    transferInstruments: ").append(this.toIndentedString(this.transferInstruments)).append("\n");
        sb.append("    trust: ").append(this.toIndentedString(this.trust)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    unincorporatedPartnership: ").append(this.toIndentedString(this.unincorporatedPartnership)).append("\n");
        sb.append("    verificationDeadlines: ").append(this.toIndentedString(this.verificationDeadlines)).append("\n");
        sb.append("    verificationPlan: ").append(this.toIndentedString(this.verificationPlan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalEntity fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntity)JSON.getMapper().readValue(jsonString, LegalEntity.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        INDIVIDUAL(String.valueOf("individual")),
        ORGANIZATION(String.valueOf("organization")),
        SOLEPROPRIETORSHIP(String.valueOf("soleProprietorship")),
        TRUST(String.valueOf("trust")),
        UNINCORPORATEDPARTNERSHIP(String.valueOf("unincorporatedPartnership"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

