/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.AuthenticationData;
import com.adyen.model.checkout.BillingAddress;
import com.adyen.model.checkout.BrowserInfo;
import com.adyen.model.checkout.CheckoutBankAccount;
import com.adyen.model.checkout.CheckoutPaymentMethod;
import com.adyen.model.checkout.Company;
import com.adyen.model.checkout.DeliveryAddress;
import com.adyen.model.checkout.EncryptedOrderData;
import com.adyen.model.checkout.ForexQuote;
import com.adyen.model.checkout.FundOrigin;
import com.adyen.model.checkout.FundRecipient;
import com.adyen.model.checkout.Installments;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Mandate;
import com.adyen.model.checkout.MerchantRiskIndicator;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.PlatformChargebackLogic;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.SubMerchantInfo;
import com.adyen.model.checkout.ThreeDS2RequestFields;
import com.adyen.model.checkout.ThreeDSecureData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountInfo", "additionalAmount", "additionalData", "amount", "applicationInfo", "authenticationData", "bankAccount", "billingAddress", "browserInfo", "captureDelayHours", "channel", "checkoutAttemptId", "company", "conversionId", "countryCode", "dateOfBirth", "dccQuote", "deliverAt", "deliveryAddress", "deliveryDate", "deviceFingerprint", "enableOneClick", "enablePayOut", "enableRecurring", "entityType", "fraudOffset", "fundOrigin", "fundRecipient", "industryUsage", "installments", "lineItems", "localizedShopperStatement", "mandate", "mcc", "merchantAccount", "merchantOrderReference", "merchantRiskIndicator", "metadata", "mpiData", "order", "orderReference", "origin", "paymentMethod", "platformChargebackLogic", "recurringExpiry", "recurringFrequency", "recurringProcessingModel", "redirectFromIssuerMethod", "redirectToIssuerMethod", "reference", "returnUrl", "riskData", "sessionValidity", "shopperConversionId", "shopperEmail", "shopperIP", "shopperInteraction", "shopperLocale", "shopperName", "shopperReference", "shopperStatement", "socialSecurityNumber", "splits", "store", "storePaymentMethod", "subMerchants", "telephoneNumber", "threeDS2RequestData", "threeDSAuthenticationOnly", "trustedShopper"})
public class PaymentRequest {
    public static final String JSON_PROPERTY_ACCOUNT_INFO = "accountInfo";
    private AccountInfo accountInfo;
    public static final String JSON_PROPERTY_ADDITIONAL_AMOUNT = "additionalAmount";
    private Amount additionalAmount;
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = new HashMap<String, String>();
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    public static final String JSON_PROPERTY_AUTHENTICATION_DATA = "authenticationData";
    private AuthenticationData authenticationData;
    public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
    private CheckoutBankAccount bankAccount;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private BillingAddress billingAddress;
    public static final String JSON_PROPERTY_BROWSER_INFO = "browserInfo";
    private BrowserInfo browserInfo;
    public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
    private Integer captureDelayHours;
    public static final String JSON_PROPERTY_CHANNEL = "channel";
    private ChannelEnum channel;
    public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    private String checkoutAttemptId;
    public static final String JSON_PROPERTY_COMPANY = "company";
    private Company company;
    public static final String JSON_PROPERTY_CONVERSION_ID = "conversionId";
    @Deprecated
    private String conversionId;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private OffsetDateTime dateOfBirth;
    public static final String JSON_PROPERTY_DCC_QUOTE = "dccQuote";
    private ForexQuote dccQuote;
    public static final String JSON_PROPERTY_DELIVER_AT = "deliverAt";
    private OffsetDateTime deliverAt;
    public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
    private DeliveryAddress deliveryAddress;
    public static final String JSON_PROPERTY_DELIVERY_DATE = "deliveryDate";
    @Deprecated
    private OffsetDateTime deliveryDate;
    public static final String JSON_PROPERTY_DEVICE_FINGERPRINT = "deviceFingerprint";
    private String deviceFingerprint;
    public static final String JSON_PROPERTY_ENABLE_ONE_CLICK = "enableOneClick";
    private Boolean enableOneClick;
    public static final String JSON_PROPERTY_ENABLE_PAY_OUT = "enablePayOut";
    private Boolean enablePayOut;
    public static final String JSON_PROPERTY_ENABLE_RECURRING = "enableRecurring";
    private Boolean enableRecurring;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityTypeEnum entityType;
    public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
    private Integer fraudOffset;
    public static final String JSON_PROPERTY_FUND_ORIGIN = "fundOrigin";
    private FundOrigin fundOrigin;
    public static final String JSON_PROPERTY_FUND_RECIPIENT = "fundRecipient";
    private FundRecipient fundRecipient;
    public static final String JSON_PROPERTY_INDUSTRY_USAGE = "industryUsage";
    private IndustryUsageEnum industryUsage;
    public static final String JSON_PROPERTY_INSTALLMENTS = "installments";
    private Installments installments;
    public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    public static final String JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT = "localizedShopperStatement";
    private Map<String, String> localizedShopperStatement = new HashMap<String, String>();
    public static final String JSON_PROPERTY_MANDATE = "mandate";
    private Mandate mandate;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
    private String merchantOrderReference;
    public static final String JSON_PROPERTY_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
    private MerchantRiskIndicator merchantRiskIndicator;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
    private ThreeDSecureData mpiData;
    public static final String JSON_PROPERTY_ORDER = "order";
    private EncryptedOrderData order;
    public static final String JSON_PROPERTY_ORDER_REFERENCE = "orderReference";
    private String orderReference;
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private String origin;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private CheckoutPaymentMethod paymentMethod;
    public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String JSON_PROPERTY_RECURRING_EXPIRY = "recurringExpiry";
    private String recurringExpiry;
    public static final String JSON_PROPERTY_RECURRING_FREQUENCY = "recurringFrequency";
    private String recurringFrequency;
    public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String JSON_PROPERTY_REDIRECT_FROM_ISSUER_METHOD = "redirectFromIssuerMethod";
    private String redirectFromIssuerMethod;
    public static final String JSON_PROPERTY_REDIRECT_TO_ISSUER_METHOD = "redirectToIssuerMethod";
    private String redirectToIssuerMethod;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
    private String returnUrl;
    public static final String JSON_PROPERTY_RISK_DATA = "riskData";
    private RiskData riskData;
    public static final String JSON_PROPERTY_SESSION_VALIDITY = "sessionValidity";
    private String sessionValidity;
    public static final String JSON_PROPERTY_SHOPPER_CONVERSION_ID = "shopperConversionId";
    private String shopperConversionId;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
    private String shopperIP;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
    private String shopperStatement;
    public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    private String socialSecurityNumber;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits = new ArrayList<Split>();
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_STORE_PAYMENT_METHOD = "storePaymentMethod";
    private Boolean storePaymentMethod;
    public static final String JSON_PROPERTY_SUB_MERCHANTS = "subMerchants";
    private List<SubMerchantInfo> subMerchants = new ArrayList<SubMerchantInfo>();
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
    private ThreeDS2RequestFields threeDS2RequestData;
    public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    @Deprecated
    private Boolean threeDSAuthenticationOnly = false;
    public static final String JSON_PROPERTY_TRUSTED_SHOPPER = "trustedShopper";
    private Boolean trustedShopper;

    public PaymentRequest accountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
        return this;
    }

    @JsonProperty(value="accountInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    @JsonProperty(value="accountInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public PaymentRequest additionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
        return this;
    }

    @JsonProperty(value="additionalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAdditionalAmount() {
        return this.additionalAmount;
    }

    @JsonProperty(value="additionalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
    }

    public PaymentRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentRequest authenticationData(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
        return this;
    }

    @JsonProperty(value="authenticationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthenticationData getAuthenticationData() {
        return this.authenticationData;
    }

    @JsonProperty(value="authenticationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationData(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    public PaymentRequest bankAccount(CheckoutBankAccount bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckoutBankAccount getBankAccount() {
        return this.bankAccount;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccount(CheckoutBankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public PaymentRequest billingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillingAddress getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
    }

    public PaymentRequest browserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
        return this;
    }

    @JsonProperty(value="browserInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    @JsonProperty(value="browserInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public PaymentRequest captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @JsonProperty(value="captureDelayHours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    @JsonProperty(value="captureDelayHours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public PaymentRequest channel(ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChannelEnum getChannel() {
        return this.channel;
    }

    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public PaymentRequest checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    @JsonProperty(value="checkoutAttemptId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public PaymentRequest company(Company company) {
        this.company = company;
        return this;
    }

    @JsonProperty(value="company")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Company getCompany() {
        return this.company;
    }

    @JsonProperty(value="company")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompany(Company company) {
        this.company = company;
    }

    @Deprecated
    public PaymentRequest conversionId(String conversionId) {
        this.conversionId = conversionId;
        return this;
    }

    @Deprecated
    @JsonProperty(value="conversionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConversionId() {
        return this.conversionId;
    }

    @Deprecated
    @JsonProperty(value="conversionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConversionId(String conversionId) {
        this.conversionId = conversionId;
    }

    public PaymentRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentRequest dateOfBirth(OffsetDateTime dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(OffsetDateTime dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PaymentRequest dccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
        return this;
    }

    @JsonProperty(value="dccQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ForexQuote getDccQuote() {
        return this.dccQuote;
    }

    @JsonProperty(value="dccQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
    }

    public PaymentRequest deliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
        return this;
    }

    @JsonProperty(value="deliverAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDeliverAt() {
        return this.deliverAt;
    }

    @JsonProperty(value="deliverAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
    }

    public PaymentRequest deliveryAddress(DeliveryAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryAddress getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryAddress(DeliveryAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    @Deprecated
    public PaymentRequest deliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
        return this;
    }

    @Deprecated
    @JsonProperty(value="deliveryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDeliveryDate() {
        return this.deliveryDate;
    }

    @Deprecated
    @JsonProperty(value="deliveryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public PaymentRequest deviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
        return this;
    }

    @JsonProperty(value="deviceFingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    @JsonProperty(value="deviceFingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public PaymentRequest enableOneClick(Boolean enableOneClick) {
        this.enableOneClick = enableOneClick;
        return this;
    }

    @JsonProperty(value="enableOneClick")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableOneClick() {
        return this.enableOneClick;
    }

    @JsonProperty(value="enableOneClick")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnableOneClick(Boolean enableOneClick) {
        this.enableOneClick = enableOneClick;
    }

    public PaymentRequest enablePayOut(Boolean enablePayOut) {
        this.enablePayOut = enablePayOut;
        return this;
    }

    @JsonProperty(value="enablePayOut")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnablePayOut() {
        return this.enablePayOut;
    }

    @JsonProperty(value="enablePayOut")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnablePayOut(Boolean enablePayOut) {
        this.enablePayOut = enablePayOut;
    }

    public PaymentRequest enableRecurring(Boolean enableRecurring) {
        this.enableRecurring = enableRecurring;
        return this;
    }

    @JsonProperty(value="enableRecurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableRecurring() {
        return this.enableRecurring;
    }

    @JsonProperty(value="enableRecurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnableRecurring(Boolean enableRecurring) {
        this.enableRecurring = enableRecurring;
    }

    public PaymentRequest entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public PaymentRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public PaymentRequest fundOrigin(FundOrigin fundOrigin) {
        this.fundOrigin = fundOrigin;
        return this;
    }

    @JsonProperty(value="fundOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundOrigin getFundOrigin() {
        return this.fundOrigin;
    }

    @JsonProperty(value="fundOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundOrigin(FundOrigin fundOrigin) {
        this.fundOrigin = fundOrigin;
    }

    public PaymentRequest fundRecipient(FundRecipient fundRecipient) {
        this.fundRecipient = fundRecipient;
        return this;
    }

    @JsonProperty(value="fundRecipient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundRecipient getFundRecipient() {
        return this.fundRecipient;
    }

    @JsonProperty(value="fundRecipient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundRecipient(FundRecipient fundRecipient) {
        this.fundRecipient = fundRecipient;
    }

    public PaymentRequest industryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
        return this;
    }

    @JsonProperty(value="industryUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IndustryUsageEnum getIndustryUsage() {
        return this.industryUsage;
    }

    @JsonProperty(value="industryUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndustryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
    }

    public PaymentRequest installments(Installments installments) {
        this.installments = installments;
        return this;
    }

    @JsonProperty(value="installments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Installments getInstallments() {
        return this.installments;
    }

    @JsonProperty(value="installments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstallments(Installments installments) {
        this.installments = installments;
    }

    public PaymentRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentRequest localizedShopperStatement(Map<String, String> localizedShopperStatement) {
        this.localizedShopperStatement = localizedShopperStatement;
        return this;
    }

    public PaymentRequest putLocalizedShopperStatementItem(String key, String localizedShopperStatementItem) {
        if (this.localizedShopperStatement == null) {
            this.localizedShopperStatement = new HashMap<String, String>();
        }
        this.localizedShopperStatement.put(key, localizedShopperStatementItem);
        return this;
    }

    @JsonProperty(value="localizedShopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLocalizedShopperStatement() {
        return this.localizedShopperStatement;
    }

    @JsonProperty(value="localizedShopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalizedShopperStatement(Map<String, String> localizedShopperStatement) {
        this.localizedShopperStatement = localizedShopperStatement;
    }

    public PaymentRequest mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @JsonProperty(value="mandate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Mandate getMandate() {
        return this.mandate;
    }

    @JsonProperty(value="mandate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public PaymentRequest mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public PaymentRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentRequest merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @JsonProperty(value="merchantOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    @JsonProperty(value="merchantOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public PaymentRequest merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
        return this;
    }

    @JsonProperty(value="merchantRiskIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    @JsonProperty(value="merchantRiskIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public PaymentRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PaymentRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PaymentRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public PaymentRequest order(EncryptedOrderData order) {
        this.order = order;
        return this;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EncryptedOrderData getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(EncryptedOrderData order) {
        this.order = order;
    }

    public PaymentRequest orderReference(String orderReference) {
        this.orderReference = orderReference;
        return this;
    }

    @JsonProperty(value="orderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderReference() {
        return this.orderReference;
    }

    @JsonProperty(value="orderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    public PaymentRequest origin(String origin) {
        this.origin = origin;
        return this;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public PaymentRequest paymentMethod(CheckoutPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckoutPaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(CheckoutPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public PaymentRequest recurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
        return this;
    }

    @JsonProperty(value="recurringExpiry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringExpiry() {
        return this.recurringExpiry;
    }

    @JsonProperty(value="recurringExpiry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
    }

    public PaymentRequest recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @JsonProperty(value="recurringFrequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    @JsonProperty(value="recurringFrequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public PaymentRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public PaymentRequest redirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
        return this;
    }

    @JsonProperty(value="redirectFromIssuerMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectFromIssuerMethod() {
        return this.redirectFromIssuerMethod;
    }

    @JsonProperty(value="redirectFromIssuerMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    }

    public PaymentRequest redirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
        return this;
    }

    @JsonProperty(value="redirectToIssuerMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectToIssuerMethod() {
        return this.redirectToIssuerMethod;
    }

    @JsonProperty(value="redirectToIssuerMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
    }

    public PaymentRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public PaymentRequest riskData(RiskData riskData) {
        this.riskData = riskData;
        return this;
    }

    @JsonProperty(value="riskData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RiskData getRiskData() {
        return this.riskData;
    }

    @JsonProperty(value="riskData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRiskData(RiskData riskData) {
        this.riskData = riskData;
    }

    public PaymentRequest sessionValidity(String sessionValidity) {
        this.sessionValidity = sessionValidity;
        return this;
    }

    @JsonProperty(value="sessionValidity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSessionValidity() {
        return this.sessionValidity;
    }

    @JsonProperty(value="sessionValidity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionValidity(String sessionValidity) {
        this.sessionValidity = sessionValidity;
    }

    public PaymentRequest shopperConversionId(String shopperConversionId) {
        this.shopperConversionId = shopperConversionId;
        return this;
    }

    @JsonProperty(value="shopperConversionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperConversionId() {
        return this.shopperConversionId;
    }

    @JsonProperty(value="shopperConversionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperConversionId(String shopperConversionId) {
        this.shopperConversionId = shopperConversionId;
    }

    public PaymentRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public PaymentRequest shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperIP() {
        return this.shopperIP;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public PaymentRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public PaymentRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public PaymentRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public PaymentRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public PaymentRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public PaymentRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentRequest store(String store) {
        this.store = store;
        return this;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public PaymentRequest storePaymentMethod(Boolean storePaymentMethod) {
        this.storePaymentMethod = storePaymentMethod;
        return this;
    }

    @JsonProperty(value="storePaymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getStorePaymentMethod() {
        return this.storePaymentMethod;
    }

    @JsonProperty(value="storePaymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStorePaymentMethod(Boolean storePaymentMethod) {
        this.storePaymentMethod = storePaymentMethod;
    }

    public PaymentRequest subMerchants(List<SubMerchantInfo> subMerchants) {
        this.subMerchants = subMerchants;
        return this;
    }

    public PaymentRequest addSubMerchantsItem(SubMerchantInfo subMerchantsItem) {
        if (this.subMerchants == null) {
            this.subMerchants = new ArrayList<SubMerchantInfo>();
        }
        this.subMerchants.add(subMerchantsItem);
        return this;
    }

    @JsonProperty(value="subMerchants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubMerchantInfo> getSubMerchants() {
        return this.subMerchants;
    }

    @JsonProperty(value="subMerchants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchants(List<SubMerchantInfo> subMerchants) {
        this.subMerchants = subMerchants;
    }

    public PaymentRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public PaymentRequest threeDS2RequestData(ThreeDS2RequestFields threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
        return this;
    }

    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2RequestFields getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2RequestData(ThreeDS2RequestFields threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    @Deprecated
    public PaymentRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @Deprecated
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    @Deprecated
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public PaymentRequest trustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
        return this;
    }

    @JsonProperty(value="trustedShopper")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTrustedShopper() {
        return this.trustedShopper;
    }

    @JsonProperty(value="trustedShopper")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRequest paymentRequest = (PaymentRequest)o;
        return Objects.equals(this.accountInfo, paymentRequest.accountInfo) && Objects.equals(this.additionalAmount, paymentRequest.additionalAmount) && Objects.equals(this.additionalData, paymentRequest.additionalData) && Objects.equals(this.amount, paymentRequest.amount) && Objects.equals(this.applicationInfo, paymentRequest.applicationInfo) && Objects.equals(this.authenticationData, paymentRequest.authenticationData) && Objects.equals(this.bankAccount, paymentRequest.bankAccount) && Objects.equals(this.billingAddress, paymentRequest.billingAddress) && Objects.equals(this.browserInfo, paymentRequest.browserInfo) && Objects.equals(this.captureDelayHours, paymentRequest.captureDelayHours) && Objects.equals((Object)this.channel, (Object)paymentRequest.channel) && Objects.equals(this.checkoutAttemptId, paymentRequest.checkoutAttemptId) && Objects.equals(this.company, paymentRequest.company) && Objects.equals(this.conversionId, paymentRequest.conversionId) && Objects.equals(this.countryCode, paymentRequest.countryCode) && Objects.equals(this.dateOfBirth, paymentRequest.dateOfBirth) && Objects.equals(this.dccQuote, paymentRequest.dccQuote) && Objects.equals(this.deliverAt, paymentRequest.deliverAt) && Objects.equals(this.deliveryAddress, paymentRequest.deliveryAddress) && Objects.equals(this.deliveryDate, paymentRequest.deliveryDate) && Objects.equals(this.deviceFingerprint, paymentRequest.deviceFingerprint) && Objects.equals(this.enableOneClick, paymentRequest.enableOneClick) && Objects.equals(this.enablePayOut, paymentRequest.enablePayOut) && Objects.equals(this.enableRecurring, paymentRequest.enableRecurring) && Objects.equals((Object)this.entityType, (Object)paymentRequest.entityType) && Objects.equals(this.fraudOffset, paymentRequest.fraudOffset) && Objects.equals(this.fundOrigin, paymentRequest.fundOrigin) && Objects.equals(this.fundRecipient, paymentRequest.fundRecipient) && Objects.equals((Object)this.industryUsage, (Object)paymentRequest.industryUsage) && Objects.equals(this.installments, paymentRequest.installments) && Objects.equals(this.lineItems, paymentRequest.lineItems) && Objects.equals(this.localizedShopperStatement, paymentRequest.localizedShopperStatement) && Objects.equals(this.mandate, paymentRequest.mandate) && Objects.equals(this.mcc, paymentRequest.mcc) && Objects.equals(this.merchantAccount, paymentRequest.merchantAccount) && Objects.equals(this.merchantOrderReference, paymentRequest.merchantOrderReference) && Objects.equals(this.merchantRiskIndicator, paymentRequest.merchantRiskIndicator) && Objects.equals(this.metadata, paymentRequest.metadata) && Objects.equals(this.mpiData, paymentRequest.mpiData) && Objects.equals(this.order, paymentRequest.order) && Objects.equals(this.orderReference, paymentRequest.orderReference) && Objects.equals(this.origin, paymentRequest.origin) && Objects.equals(this.paymentMethod, paymentRequest.paymentMethod) && Objects.equals(this.platformChargebackLogic, paymentRequest.platformChargebackLogic) && Objects.equals(this.recurringExpiry, paymentRequest.recurringExpiry) && Objects.equals(this.recurringFrequency, paymentRequest.recurringFrequency) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentRequest.recurringProcessingModel) && Objects.equals(this.redirectFromIssuerMethod, paymentRequest.redirectFromIssuerMethod) && Objects.equals(this.redirectToIssuerMethod, paymentRequest.redirectToIssuerMethod) && Objects.equals(this.reference, paymentRequest.reference) && Objects.equals(this.returnUrl, paymentRequest.returnUrl) && Objects.equals(this.riskData, paymentRequest.riskData) && Objects.equals(this.sessionValidity, paymentRequest.sessionValidity) && Objects.equals(this.shopperConversionId, paymentRequest.shopperConversionId) && Objects.equals(this.shopperEmail, paymentRequest.shopperEmail) && Objects.equals(this.shopperIP, paymentRequest.shopperIP) && Objects.equals((Object)this.shopperInteraction, (Object)paymentRequest.shopperInteraction) && Objects.equals(this.shopperLocale, paymentRequest.shopperLocale) && Objects.equals(this.shopperName, paymentRequest.shopperName) && Objects.equals(this.shopperReference, paymentRequest.shopperReference) && Objects.equals(this.shopperStatement, paymentRequest.shopperStatement) && Objects.equals(this.socialSecurityNumber, paymentRequest.socialSecurityNumber) && Objects.equals(this.splits, paymentRequest.splits) && Objects.equals(this.store, paymentRequest.store) && Objects.equals(this.storePaymentMethod, paymentRequest.storePaymentMethod) && Objects.equals(this.subMerchants, paymentRequest.subMerchants) && Objects.equals(this.telephoneNumber, paymentRequest.telephoneNumber) && Objects.equals(this.threeDS2RequestData, paymentRequest.threeDS2RequestData) && Objects.equals(this.threeDSAuthenticationOnly, paymentRequest.threeDSAuthenticationOnly) && Objects.equals(this.trustedShopper, paymentRequest.trustedShopper);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.additionalAmount, this.additionalData, this.amount, this.applicationInfo, this.authenticationData, this.bankAccount, this.billingAddress, this.browserInfo, this.captureDelayHours, this.channel, this.checkoutAttemptId, this.company, this.conversionId, this.countryCode, this.dateOfBirth, this.dccQuote, this.deliverAt, this.deliveryAddress, this.deliveryDate, this.deviceFingerprint, this.enableOneClick, this.enablePayOut, this.enableRecurring, this.entityType, this.fraudOffset, this.fundOrigin, this.fundRecipient, this.industryUsage, this.installments, this.lineItems, this.localizedShopperStatement, this.mandate, this.mcc, this.merchantAccount, this.merchantOrderReference, this.merchantRiskIndicator, this.metadata, this.mpiData, this.order, this.orderReference, this.origin, this.paymentMethod, this.platformChargebackLogic, this.recurringExpiry, this.recurringFrequency, this.recurringProcessingModel, this.redirectFromIssuerMethod, this.redirectToIssuerMethod, this.reference, this.returnUrl, this.riskData, this.sessionValidity, this.shopperConversionId, this.shopperEmail, this.shopperIP, this.shopperInteraction, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber, this.splits, this.store, this.storePaymentMethod, this.subMerchants, this.telephoneNumber, this.threeDS2RequestData, this.threeDSAuthenticationOnly, this.trustedShopper});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRequest {\n");
        sb.append("    accountInfo: ").append(this.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    additionalAmount: ").append(this.toIndentedString(this.additionalAmount)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    authenticationData: ").append(this.toIndentedString(this.authenticationData)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    browserInfo: ").append(this.toIndentedString(this.browserInfo)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    conversionId: ").append(this.toIndentedString(this.conversionId)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    dccQuote: ").append(this.toIndentedString(this.dccQuote)).append("\n");
        sb.append("    deliverAt: ").append(this.toIndentedString(this.deliverAt)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    deliveryDate: ").append(this.toIndentedString(this.deliveryDate)).append("\n");
        sb.append("    deviceFingerprint: ").append(this.toIndentedString(this.deviceFingerprint)).append("\n");
        sb.append("    enableOneClick: ").append(this.toIndentedString(this.enableOneClick)).append("\n");
        sb.append("    enablePayOut: ").append(this.toIndentedString(this.enablePayOut)).append("\n");
        sb.append("    enableRecurring: ").append(this.toIndentedString(this.enableRecurring)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    fundOrigin: ").append(this.toIndentedString(this.fundOrigin)).append("\n");
        sb.append("    fundRecipient: ").append(this.toIndentedString(this.fundRecipient)).append("\n");
        sb.append("    industryUsage: ").append(this.toIndentedString((Object)this.industryUsage)).append("\n");
        sb.append("    installments: ").append(this.toIndentedString(this.installments)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    localizedShopperStatement: ").append(this.toIndentedString(this.localizedShopperStatement)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(this.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    orderReference: ").append(this.toIndentedString(this.orderReference)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    recurringExpiry: ").append(this.toIndentedString(this.recurringExpiry)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    redirectFromIssuerMethod: ").append(this.toIndentedString(this.redirectFromIssuerMethod)).append("\n");
        sb.append("    redirectToIssuerMethod: ").append(this.toIndentedString(this.redirectToIssuerMethod)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    riskData: ").append(this.toIndentedString(this.riskData)).append("\n");
        sb.append("    sessionValidity: ").append(this.toIndentedString(this.sessionValidity)).append("\n");
        sb.append("    shopperConversionId: ").append(this.toIndentedString(this.shopperConversionId)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storePaymentMethod: ").append(this.toIndentedString(this.storePaymentMethod)).append("\n");
        sb.append("    subMerchants: ").append(this.toIndentedString(this.subMerchants)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    threeDS2RequestData: ").append(this.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("    trustedShopper: ").append(this.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentRequest)JSON.getMapper().readValue(jsonString, PaymentRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE(String.valueOf("Ecommerce")),
        CONTAUTH(String.valueOf("ContAuth")),
        MOTO(String.valueOf("Moto")),
        POS(String.valueOf("POS"));

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RecurringProcessingModelEnum {
        CARDONFILE(String.valueOf("CardOnFile")),
        SUBSCRIPTION(String.valueOf("Subscription")),
        UNSCHEDULEDCARDONFILE(String.valueOf("UnscheduledCardOnFile"));

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum IndustryUsageEnum {
        DELAYEDCHARGE(String.valueOf("delayedCharge")),
        INSTALLMENT(String.valueOf("installment")),
        NOSHOW(String.valueOf("noShow"));

        private String value;

        private IndustryUsageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IndustryUsageEnum fromValue(String value) {
            for (IndustryUsageEnum b : IndustryUsageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EntityTypeEnum {
        NATURALPERSON(String.valueOf("NaturalPerson")),
        COMPANYNAME(String.valueOf("CompanyName"));

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChannelEnum {
        IOS(String.valueOf("iOS")),
        ANDROID(String.valueOf("Android")),
        WEB(String.valueOf("Web"));

        private String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelEnum fromValue(String value) {
            for (ChannelEnum b : ChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

