/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"acceptedCountries", "allowBankAccountFormatSelection", "allowIntraRegionCrossBorderPayout", "changeLegalEntityType", "editPrefilledCountry", "enforceLegalAge", "hideOnboardingIntroductionIndividual", "hideOnboardingIntroductionOrganization", "hideOnboardingIntroductionSoleProprietor", "hideOnboardingIntroductionTrust", "instantBankVerification", "requirePciSignEcomMoto", "requirePciSignEcommerce", "requirePciSignPos", "requirePciSignPosMoto", "transferInstrumentLimit"})
public class OnboardingLinkSettings {
    public static final String JSON_PROPERTY_ACCEPTED_COUNTRIES = "acceptedCountries";
    private List<String> acceptedCountries = null;
    public static final String JSON_PROPERTY_ALLOW_BANK_ACCOUNT_FORMAT_SELECTION = "allowBankAccountFormatSelection";
    private Boolean allowBankAccountFormatSelection;
    public static final String JSON_PROPERTY_ALLOW_INTRA_REGION_CROSS_BORDER_PAYOUT = "allowIntraRegionCrossBorderPayout";
    private Boolean allowIntraRegionCrossBorderPayout;
    public static final String JSON_PROPERTY_CHANGE_LEGAL_ENTITY_TYPE = "changeLegalEntityType";
    private Boolean changeLegalEntityType;
    public static final String JSON_PROPERTY_EDIT_PREFILLED_COUNTRY = "editPrefilledCountry";
    private Boolean editPrefilledCountry;
    public static final String JSON_PROPERTY_ENFORCE_LEGAL_AGE = "enforceLegalAge";
    private Boolean enforceLegalAge;
    public static final String JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_INDIVIDUAL = "hideOnboardingIntroductionIndividual";
    private Boolean hideOnboardingIntroductionIndividual;
    public static final String JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_ORGANIZATION = "hideOnboardingIntroductionOrganization";
    private Boolean hideOnboardingIntroductionOrganization;
    public static final String JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_SOLE_PROPRIETOR = "hideOnboardingIntroductionSoleProprietor";
    private Boolean hideOnboardingIntroductionSoleProprietor;
    public static final String JSON_PROPERTY_HIDE_ONBOARDING_INTRODUCTION_TRUST = "hideOnboardingIntroductionTrust";
    private Boolean hideOnboardingIntroductionTrust;
    public static final String JSON_PROPERTY_INSTANT_BANK_VERIFICATION = "instantBankVerification";
    private Boolean instantBankVerification;
    public static final String JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOM_MOTO = "requirePciSignEcomMoto";
    private Boolean requirePciSignEcomMoto;
    public static final String JSON_PROPERTY_REQUIRE_PCI_SIGN_ECOMMERCE = "requirePciSignEcommerce";
    private Boolean requirePciSignEcommerce;
    public static final String JSON_PROPERTY_REQUIRE_PCI_SIGN_POS = "requirePciSignPos";
    private Boolean requirePciSignPos;
    public static final String JSON_PROPERTY_REQUIRE_PCI_SIGN_POS_MOTO = "requirePciSignPosMoto";
    private Boolean requirePciSignPosMoto;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_LIMIT = "transferInstrumentLimit";
    private Integer transferInstrumentLimit;

    public OnboardingLinkSettings acceptedCountries(List<String> acceptedCountries) {
        this.acceptedCountries = acceptedCountries;
        return this;
    }

    public OnboardingLinkSettings addAcceptedCountriesItem(String acceptedCountriesItem) {
        if (this.acceptedCountries == null) {
            this.acceptedCountries = new ArrayList<String>();
        }
        this.acceptedCountries.add(acceptedCountriesItem);
        return this;
    }

    @ApiModelProperty(value="The list of countries the user can choose from in hosted onboarding when `editPrefilledCountry` is allowed.  The value must be in the two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code format.  The array is empty by default, allowing all [countries and regions supported by hosted onboarding](https://docs.adyen.com/platforms/onboard-users/#hosted-onboarding).")
    @JsonProperty(value="acceptedCountries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAcceptedCountries() {
        return this.acceptedCountries;
    }

    @JsonProperty(value="acceptedCountries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptedCountries(List<String> acceptedCountries) {
        this.acceptedCountries = acceptedCountries;
    }

    public OnboardingLinkSettings allowBankAccountFormatSelection(Boolean allowBankAccountFormatSelection) {
        this.allowBankAccountFormatSelection = allowBankAccountFormatSelection;
        return this;
    }

    @ApiModelProperty(value="Default value: **false**  Indicates if the user can select the format for their payout account (if applicable).")
    @JsonProperty(value="allowBankAccountFormatSelection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowBankAccountFormatSelection() {
        return this.allowBankAccountFormatSelection;
    }

    @JsonProperty(value="allowBankAccountFormatSelection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowBankAccountFormatSelection(Boolean allowBankAccountFormatSelection) {
        this.allowBankAccountFormatSelection = allowBankAccountFormatSelection;
    }

    public OnboardingLinkSettings allowIntraRegionCrossBorderPayout(Boolean allowIntraRegionCrossBorderPayout) {
        this.allowIntraRegionCrossBorderPayout = allowIntraRegionCrossBorderPayout;
        return this;
    }

    @ApiModelProperty(value="Default value: **false**  Indicates if the user can select a payout account in a different EU/EEA location (including Switzerland and the UK) than the location of their legal entity.")
    @JsonProperty(value="allowIntraRegionCrossBorderPayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowIntraRegionCrossBorderPayout() {
        return this.allowIntraRegionCrossBorderPayout;
    }

    @JsonProperty(value="allowIntraRegionCrossBorderPayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowIntraRegionCrossBorderPayout(Boolean allowIntraRegionCrossBorderPayout) {
        this.allowIntraRegionCrossBorderPayout = allowIntraRegionCrossBorderPayout;
    }

    public OnboardingLinkSettings changeLegalEntityType(Boolean changeLegalEntityType) {
        this.changeLegalEntityType = changeLegalEntityType;
        return this;
    }

    @ApiModelProperty(value="Default value: **true**  Indicates if the user can change their legal entity type.")
    @JsonProperty(value="changeLegalEntityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getChangeLegalEntityType() {
        return this.changeLegalEntityType;
    }

    @JsonProperty(value="changeLegalEntityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeLegalEntityType(Boolean changeLegalEntityType) {
        this.changeLegalEntityType = changeLegalEntityType;
    }

    public OnboardingLinkSettings editPrefilledCountry(Boolean editPrefilledCountry) {
        this.editPrefilledCountry = editPrefilledCountry;
        return this;
    }

    @ApiModelProperty(value="Default value: **true**  Indicates if the user can change the country of their legal entity's address, for example the registered address of an organization.")
    @JsonProperty(value="editPrefilledCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEditPrefilledCountry() {
        return this.editPrefilledCountry;
    }

    @JsonProperty(value="editPrefilledCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEditPrefilledCountry(Boolean editPrefilledCountry) {
        this.editPrefilledCountry = editPrefilledCountry;
    }

    public OnboardingLinkSettings enforceLegalAge(Boolean enforceLegalAge) {
        this.enforceLegalAge = enforceLegalAge;
        return this;
    }

    @ApiModelProperty(value="Default value: **false**  Indicates if only users above the age of 18 can be onboarded.")
    @JsonProperty(value="enforceLegalAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnforceLegalAge() {
        return this.enforceLegalAge;
    }

    @JsonProperty(value="enforceLegalAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnforceLegalAge(Boolean enforceLegalAge) {
        this.enforceLegalAge = enforceLegalAge;
    }

    public OnboardingLinkSettings hideOnboardingIntroductionIndividual(Boolean hideOnboardingIntroductionIndividual) {
        this.hideOnboardingIntroductionIndividual = hideOnboardingIntroductionIndividual;
        return this;
    }

    @ApiModelProperty(value="Default value: **true**  Indicates whether the introduction screen is hidden for the user of the individual legal entity type. The introduction screen provides brief instructions for the subsequent steps in the hosted onboarding process.")
    @JsonProperty(value="hideOnboardingIntroductionIndividual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideOnboardingIntroductionIndividual() {
        return this.hideOnboardingIntroductionIndividual;
    }

    @JsonProperty(value="hideOnboardingIntroductionIndividual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideOnboardingIntroductionIndividual(Boolean hideOnboardingIntroductionIndividual) {
        this.hideOnboardingIntroductionIndividual = hideOnboardingIntroductionIndividual;
    }

    public OnboardingLinkSettings hideOnboardingIntroductionOrganization(Boolean hideOnboardingIntroductionOrganization) {
        this.hideOnboardingIntroductionOrganization = hideOnboardingIntroductionOrganization;
        return this;
    }

    @ApiModelProperty(value="Default value: **true**  Indicates whether the introduction screen is hidden for the user of the organization legal entity type. The introduction screen provides brief instructions for the subsequent steps in the hosted onboarding process.")
    @JsonProperty(value="hideOnboardingIntroductionOrganization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideOnboardingIntroductionOrganization() {
        return this.hideOnboardingIntroductionOrganization;
    }

    @JsonProperty(value="hideOnboardingIntroductionOrganization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideOnboardingIntroductionOrganization(Boolean hideOnboardingIntroductionOrganization) {
        this.hideOnboardingIntroductionOrganization = hideOnboardingIntroductionOrganization;
    }

    public OnboardingLinkSettings hideOnboardingIntroductionSoleProprietor(Boolean hideOnboardingIntroductionSoleProprietor) {
        this.hideOnboardingIntroductionSoleProprietor = hideOnboardingIntroductionSoleProprietor;
        return this;
    }

    @ApiModelProperty(value="Default value: **true**  Indicates whether the introduction screen is hidden for the user of the sole proprietorship legal entity type. The introduction screen provides brief instructions for the subsequent steps in the hosted onboarding process.")
    @JsonProperty(value="hideOnboardingIntroductionSoleProprietor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideOnboardingIntroductionSoleProprietor() {
        return this.hideOnboardingIntroductionSoleProprietor;
    }

    @JsonProperty(value="hideOnboardingIntroductionSoleProprietor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideOnboardingIntroductionSoleProprietor(Boolean hideOnboardingIntroductionSoleProprietor) {
        this.hideOnboardingIntroductionSoleProprietor = hideOnboardingIntroductionSoleProprietor;
    }

    public OnboardingLinkSettings hideOnboardingIntroductionTrust(Boolean hideOnboardingIntroductionTrust) {
        this.hideOnboardingIntroductionTrust = hideOnboardingIntroductionTrust;
        return this;
    }

    @ApiModelProperty(value="Default value: **true**  Indicates whether the introduction screen is hidden for the user of the trust legal entity type. The introduction screen provides brief instructions for the subsequent steps in the hosted onboarding process.")
    @JsonProperty(value="hideOnboardingIntroductionTrust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideOnboardingIntroductionTrust() {
        return this.hideOnboardingIntroductionTrust;
    }

    @JsonProperty(value="hideOnboardingIntroductionTrust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideOnboardingIntroductionTrust(Boolean hideOnboardingIntroductionTrust) {
        this.hideOnboardingIntroductionTrust = hideOnboardingIntroductionTrust;
    }

    public OnboardingLinkSettings instantBankVerification(Boolean instantBankVerification) {
        this.instantBankVerification = instantBankVerification;
        return this;
    }

    @ApiModelProperty(value="Default value: **true**  Indicates if the user can initiate the verification process through open banking providers, like Plaid or Tink.")
    @JsonProperty(value="instantBankVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getInstantBankVerification() {
        return this.instantBankVerification;
    }

    @JsonProperty(value="instantBankVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstantBankVerification(Boolean instantBankVerification) {
        this.instantBankVerification = instantBankVerification;
    }

    public OnboardingLinkSettings requirePciSignEcomMoto(Boolean requirePciSignEcomMoto) {
        this.requirePciSignEcomMoto = requirePciSignEcomMoto;
        return this;
    }

    @ApiModelProperty(value="Default value: **false**  Indicates if the user is required to sign a PCI questionnaires for the **ecomMoto** sales channel type.")
    @JsonProperty(value="requirePciSignEcomMoto")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequirePciSignEcomMoto() {
        return this.requirePciSignEcomMoto;
    }

    @JsonProperty(value="requirePciSignEcomMoto")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequirePciSignEcomMoto(Boolean requirePciSignEcomMoto) {
        this.requirePciSignEcomMoto = requirePciSignEcomMoto;
    }

    public OnboardingLinkSettings requirePciSignEcommerce(Boolean requirePciSignEcommerce) {
        this.requirePciSignEcommerce = requirePciSignEcommerce;
        return this;
    }

    @ApiModelProperty(value="Default value: **false**  Indicates if the user is required to sign a PCI questionnaires for the **eCommerce** sales channel type.")
    @JsonProperty(value="requirePciSignEcommerce")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequirePciSignEcommerce() {
        return this.requirePciSignEcommerce;
    }

    @JsonProperty(value="requirePciSignEcommerce")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequirePciSignEcommerce(Boolean requirePciSignEcommerce) {
        this.requirePciSignEcommerce = requirePciSignEcommerce;
    }

    public OnboardingLinkSettings requirePciSignPos(Boolean requirePciSignPos) {
        this.requirePciSignPos = requirePciSignPos;
        return this;
    }

    @ApiModelProperty(value="Default value: **false**  Indicates if the user is required to sign a PCI questionnaires for the **pos** sales channel type.")
    @JsonProperty(value="requirePciSignPos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequirePciSignPos() {
        return this.requirePciSignPos;
    }

    @JsonProperty(value="requirePciSignPos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequirePciSignPos(Boolean requirePciSignPos) {
        this.requirePciSignPos = requirePciSignPos;
    }

    public OnboardingLinkSettings requirePciSignPosMoto(Boolean requirePciSignPosMoto) {
        this.requirePciSignPosMoto = requirePciSignPosMoto;
        return this;
    }

    @ApiModelProperty(value="Default value: **false**  Indicates if the user is required to sign a PCI questionnaires for the **posMoto** sales channel type.")
    @JsonProperty(value="requirePciSignPosMoto")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequirePciSignPosMoto() {
        return this.requirePciSignPosMoto;
    }

    @JsonProperty(value="requirePciSignPosMoto")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequirePciSignPosMoto(Boolean requirePciSignPosMoto) {
        this.requirePciSignPosMoto = requirePciSignPosMoto;
    }

    public OnboardingLinkSettings transferInstrumentLimit(Integer transferInstrumentLimit) {
        this.transferInstrumentLimit = transferInstrumentLimit;
        return this;
    }

    @ApiModelProperty(value="The maximum number of transfer instruments the user can create.")
    @JsonProperty(value="transferInstrumentLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTransferInstrumentLimit() {
        return this.transferInstrumentLimit;
    }

    @JsonProperty(value="transferInstrumentLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferInstrumentLimit(Integer transferInstrumentLimit) {
        this.transferInstrumentLimit = transferInstrumentLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnboardingLinkSettings onboardingLinkSettings = (OnboardingLinkSettings)o;
        return Objects.equals(this.acceptedCountries, onboardingLinkSettings.acceptedCountries) && Objects.equals(this.allowBankAccountFormatSelection, onboardingLinkSettings.allowBankAccountFormatSelection) && Objects.equals(this.allowIntraRegionCrossBorderPayout, onboardingLinkSettings.allowIntraRegionCrossBorderPayout) && Objects.equals(this.changeLegalEntityType, onboardingLinkSettings.changeLegalEntityType) && Objects.equals(this.editPrefilledCountry, onboardingLinkSettings.editPrefilledCountry) && Objects.equals(this.enforceLegalAge, onboardingLinkSettings.enforceLegalAge) && Objects.equals(this.hideOnboardingIntroductionIndividual, onboardingLinkSettings.hideOnboardingIntroductionIndividual) && Objects.equals(this.hideOnboardingIntroductionOrganization, onboardingLinkSettings.hideOnboardingIntroductionOrganization) && Objects.equals(this.hideOnboardingIntroductionSoleProprietor, onboardingLinkSettings.hideOnboardingIntroductionSoleProprietor) && Objects.equals(this.hideOnboardingIntroductionTrust, onboardingLinkSettings.hideOnboardingIntroductionTrust) && Objects.equals(this.instantBankVerification, onboardingLinkSettings.instantBankVerification) && Objects.equals(this.requirePciSignEcomMoto, onboardingLinkSettings.requirePciSignEcomMoto) && Objects.equals(this.requirePciSignEcommerce, onboardingLinkSettings.requirePciSignEcommerce) && Objects.equals(this.requirePciSignPos, onboardingLinkSettings.requirePciSignPos) && Objects.equals(this.requirePciSignPosMoto, onboardingLinkSettings.requirePciSignPosMoto) && Objects.equals(this.transferInstrumentLimit, onboardingLinkSettings.transferInstrumentLimit);
    }

    public int hashCode() {
        return Objects.hash(this.acceptedCountries, this.allowBankAccountFormatSelection, this.allowIntraRegionCrossBorderPayout, this.changeLegalEntityType, this.editPrefilledCountry, this.enforceLegalAge, this.hideOnboardingIntroductionIndividual, this.hideOnboardingIntroductionOrganization, this.hideOnboardingIntroductionSoleProprietor, this.hideOnboardingIntroductionTrust, this.instantBankVerification, this.requirePciSignEcomMoto, this.requirePciSignEcommerce, this.requirePciSignPos, this.requirePciSignPosMoto, this.transferInstrumentLimit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OnboardingLinkSettings {\n");
        sb.append("    acceptedCountries: ").append(this.toIndentedString(this.acceptedCountries)).append("\n");
        sb.append("    allowBankAccountFormatSelection: ").append(this.toIndentedString(this.allowBankAccountFormatSelection)).append("\n");
        sb.append("    allowIntraRegionCrossBorderPayout: ").append(this.toIndentedString(this.allowIntraRegionCrossBorderPayout)).append("\n");
        sb.append("    changeLegalEntityType: ").append(this.toIndentedString(this.changeLegalEntityType)).append("\n");
        sb.append("    editPrefilledCountry: ").append(this.toIndentedString(this.editPrefilledCountry)).append("\n");
        sb.append("    enforceLegalAge: ").append(this.toIndentedString(this.enforceLegalAge)).append("\n");
        sb.append("    hideOnboardingIntroductionIndividual: ").append(this.toIndentedString(this.hideOnboardingIntroductionIndividual)).append("\n");
        sb.append("    hideOnboardingIntroductionOrganization: ").append(this.toIndentedString(this.hideOnboardingIntroductionOrganization)).append("\n");
        sb.append("    hideOnboardingIntroductionSoleProprietor: ").append(this.toIndentedString(this.hideOnboardingIntroductionSoleProprietor)).append("\n");
        sb.append("    hideOnboardingIntroductionTrust: ").append(this.toIndentedString(this.hideOnboardingIntroductionTrust)).append("\n");
        sb.append("    instantBankVerification: ").append(this.toIndentedString(this.instantBankVerification)).append("\n");
        sb.append("    requirePciSignEcomMoto: ").append(this.toIndentedString(this.requirePciSignEcomMoto)).append("\n");
        sb.append("    requirePciSignEcommerce: ").append(this.toIndentedString(this.requirePciSignEcommerce)).append("\n");
        sb.append("    requirePciSignPos: ").append(this.toIndentedString(this.requirePciSignPos)).append("\n");
        sb.append("    requirePciSignPosMoto: ").append(this.toIndentedString(this.requirePciSignPosMoto)).append("\n");
        sb.append("    transferInstrumentLimit: ").append(this.toIndentedString(this.transferInstrumentLimit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static OnboardingLinkSettings fromJson(String jsonString) throws JsonProcessingException {
        return (OnboardingLinkSettings)JSON.getMapper().readValue(jsonString, OnboardingLinkSettings.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

