/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"brand", "expiryMonth", "expiryYear", "externalResponseCode", "externalTokenReference", "holderName", "iban", "id", "issuerName", "lastFour", "name", "networkTxReference", "ownerName", "shopperEmail", "shopperReference", "supportedRecurringProcessingModels", "type"})
public class StoredPaymentMethodResource {
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_EXPIRY_MONTH = "expiryMonth";
    private String expiryMonth;
    public static final String JSON_PROPERTY_EXPIRY_YEAR = "expiryYear";
    private String expiryYear;
    public static final String JSON_PROPERTY_EXTERNAL_RESPONSE_CODE = "externalResponseCode";
    private String externalResponseCode;
    public static final String JSON_PROPERTY_EXTERNAL_TOKEN_REFERENCE = "externalTokenReference";
    private String externalTokenReference;
    public static final String JSON_PROPERTY_HOLDER_NAME = "holderName";
    private String holderName;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ISSUER_NAME = "issuerName";
    private String issuerName;
    public static final String JSON_PROPERTY_LAST_FOUR = "lastFour";
    private String lastFour;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NETWORK_TX_REFERENCE = "networkTxReference";
    private String networkTxReference;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SUPPORTED_RECURRING_PROCESSING_MODELS = "supportedRecurringProcessingModels";
    private List<String> supportedRecurringProcessingModels = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public StoredPaymentMethodResource brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="The brand of the card.")
    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public StoredPaymentMethodResource expiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @ApiModelProperty(value="The month the card expires.")
    @JsonProperty(value="expiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    @JsonProperty(value="expiryMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public StoredPaymentMethodResource expiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @ApiModelProperty(value="The last two digits of the year the card expires. For example, **22** for the year 2022.")
    @JsonProperty(value="expiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiryYear() {
        return this.expiryYear;
    }

    @JsonProperty(value="expiryYear")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public StoredPaymentMethodResource externalResponseCode(String externalResponseCode) {
        this.externalResponseCode = externalResponseCode;
        return this;
    }

    @ApiModelProperty(value="The response code returned by an external system (for example after a provisioning operation).")
    @JsonProperty(value="externalResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalResponseCode() {
        return this.externalResponseCode;
    }

    @JsonProperty(value="externalResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalResponseCode(String externalResponseCode) {
        this.externalResponseCode = externalResponseCode;
    }

    public StoredPaymentMethodResource externalTokenReference(String externalTokenReference) {
        this.externalTokenReference = externalTokenReference;
        return this;
    }

    @ApiModelProperty(value="The token reference of a linked token in an external system (for example a network token reference).")
    @JsonProperty(value="externalTokenReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalTokenReference() {
        return this.externalTokenReference;
    }

    @JsonProperty(value="externalTokenReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalTokenReference(String externalTokenReference) {
        this.externalTokenReference = externalTokenReference;
    }

    public StoredPaymentMethodResource holderName(String holderName) {
        this.holderName = holderName;
        return this;
    }

    @ApiModelProperty(value="The unique payment method code.")
    @JsonProperty(value="holderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHolderName() {
        return this.holderName;
    }

    @JsonProperty(value="holderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public StoredPaymentMethodResource iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="The IBAN of the bank account.")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIban() {
        return this.iban;
    }

    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIban(String iban) {
        this.iban = iban;
    }

    public StoredPaymentMethodResource id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="A unique identifier of this stored payment method.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public StoredPaymentMethodResource issuerName(String issuerName) {
        this.issuerName = issuerName;
        return this;
    }

    @ApiModelProperty(value="The name of the issuer of token or card.")
    @JsonProperty(value="issuerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerName() {
        return this.issuerName;
    }

    @JsonProperty(value="issuerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public StoredPaymentMethodResource lastFour(String lastFour) {
        this.lastFour = lastFour;
        return this;
    }

    @ApiModelProperty(value="The last four digits of the PAN.")
    @JsonProperty(value="lastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastFour() {
        return this.lastFour;
    }

    @JsonProperty(value="lastFour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastFour(String lastFour) {
        this.lastFour = lastFour;
    }

    public StoredPaymentMethodResource name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The display name of the stored payment method.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public StoredPaymentMethodResource networkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
        return this;
    }

    @ApiModelProperty(value="Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.")
    @JsonProperty(value="networkTxReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkTxReference() {
        return this.networkTxReference;
    }

    @JsonProperty(value="networkTxReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
    }

    public StoredPaymentMethodResource ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank account holder.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public StoredPaymentMethodResource shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper\u2019s email address.")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public StoredPaymentMethodResource shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Your reference to uniquely identify this shopper, for example user ID or account ID. The value is case-sensitive and must be at least three characters. > Your reference must not include personally identifiable information (PII) such as name or email address.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public StoredPaymentMethodResource supportedRecurringProcessingModels(List<String> supportedRecurringProcessingModels) {
        this.supportedRecurringProcessingModels = supportedRecurringProcessingModels;
        return this;
    }

    public StoredPaymentMethodResource addSupportedRecurringProcessingModelsItem(String supportedRecurringProcessingModelsItem) {
        if (this.supportedRecurringProcessingModels == null) {
            this.supportedRecurringProcessingModels = new ArrayList<String>();
        }
        this.supportedRecurringProcessingModels.add(supportedRecurringProcessingModelsItem);
        return this;
    }

    @ApiModelProperty(value="Defines a recurring payment type. Allowed values: * `Subscription` \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount.")
    @JsonProperty(value="supportedRecurringProcessingModels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSupportedRecurringProcessingModels() {
        return this.supportedRecurringProcessingModels;
    }

    @JsonProperty(value="supportedRecurringProcessingModels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedRecurringProcessingModels(List<String> supportedRecurringProcessingModels) {
        this.supportedRecurringProcessingModels = supportedRecurringProcessingModels;
    }

    public StoredPaymentMethodResource type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of payment method.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredPaymentMethodResource storedPaymentMethodResource = (StoredPaymentMethodResource)o;
        return Objects.equals(this.brand, storedPaymentMethodResource.brand) && Objects.equals(this.expiryMonth, storedPaymentMethodResource.expiryMonth) && Objects.equals(this.expiryYear, storedPaymentMethodResource.expiryYear) && Objects.equals(this.externalResponseCode, storedPaymentMethodResource.externalResponseCode) && Objects.equals(this.externalTokenReference, storedPaymentMethodResource.externalTokenReference) && Objects.equals(this.holderName, storedPaymentMethodResource.holderName) && Objects.equals(this.iban, storedPaymentMethodResource.iban) && Objects.equals(this.id, storedPaymentMethodResource.id) && Objects.equals(this.issuerName, storedPaymentMethodResource.issuerName) && Objects.equals(this.lastFour, storedPaymentMethodResource.lastFour) && Objects.equals(this.name, storedPaymentMethodResource.name) && Objects.equals(this.networkTxReference, storedPaymentMethodResource.networkTxReference) && Objects.equals(this.ownerName, storedPaymentMethodResource.ownerName) && Objects.equals(this.shopperEmail, storedPaymentMethodResource.shopperEmail) && Objects.equals(this.shopperReference, storedPaymentMethodResource.shopperReference) && Objects.equals(this.supportedRecurringProcessingModels, storedPaymentMethodResource.supportedRecurringProcessingModels) && Objects.equals(this.type, storedPaymentMethodResource.type);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.expiryMonth, this.expiryYear, this.externalResponseCode, this.externalTokenReference, this.holderName, this.iban, this.id, this.issuerName, this.lastFour, this.name, this.networkTxReference, this.ownerName, this.shopperEmail, this.shopperReference, this.supportedRecurringProcessingModels, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredPaymentMethodResource {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    externalResponseCode: ").append(this.toIndentedString(this.externalResponseCode)).append("\n");
        sb.append("    externalTokenReference: ").append(this.toIndentedString(this.externalTokenReference)).append("\n");
        sb.append("    holderName: ").append(this.toIndentedString(this.holderName)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuerName: ").append(this.toIndentedString(this.issuerName)).append("\n");
        sb.append("    lastFour: ").append(this.toIndentedString(this.lastFour)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    networkTxReference: ").append(this.toIndentedString(this.networkTxReference)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    supportedRecurringProcessingModels: ").append(this.toIndentedString(this.supportedRecurringProcessingModels)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredPaymentMethodResource fromJson(String jsonString) throws JsonProcessingException {
        return (StoredPaymentMethodResource)JSON.getMapper().readValue(jsonString, StoredPaymentMethodResource.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

