/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"RequestedTestErrorResponseCode", "allowPartialAuth", "authorisationType", "autoRescue", "customRoutingFlag", "industryUsage", "manualCapture", "maxDaysToRescue", "networkTxReference", "overwriteBrand", "subMerchantCity", "subMerchantCountry", "subMerchantID", "subMerchantName", "subMerchantPostalCode", "subMerchantState", "subMerchantStreet", "subMerchantTaxId"})
public class AdditionalDataCommon {
    public static final String JSON_PROPERTY_REQUESTED_TEST_ERROR_RESPONSE_CODE = "RequestedTestErrorResponseCode";
    private String requestedTestErrorResponseCode;
    public static final String JSON_PROPERTY_ALLOW_PARTIAL_AUTH = "allowPartialAuth";
    private String allowPartialAuth;
    public static final String JSON_PROPERTY_AUTHORISATION_TYPE = "authorisationType";
    private String authorisationType;
    public static final String JSON_PROPERTY_AUTO_RESCUE = "autoRescue";
    private String autoRescue;
    public static final String JSON_PROPERTY_CUSTOM_ROUTING_FLAG = "customRoutingFlag";
    private String customRoutingFlag;
    public static final String JSON_PROPERTY_INDUSTRY_USAGE = "industryUsage";
    private IndustryUsageEnum industryUsage;
    public static final String JSON_PROPERTY_MANUAL_CAPTURE = "manualCapture";
    private String manualCapture;
    public static final String JSON_PROPERTY_MAX_DAYS_TO_RESCUE = "maxDaysToRescue";
    private String maxDaysToRescue;
    public static final String JSON_PROPERTY_NETWORK_TX_REFERENCE = "networkTxReference";
    private String networkTxReference;
    public static final String JSON_PROPERTY_OVERWRITE_BRAND = "overwriteBrand";
    private String overwriteBrand;
    public static final String JSON_PROPERTY_SUB_MERCHANT_CITY = "subMerchantCity";
    private String subMerchantCity;
    public static final String JSON_PROPERTY_SUB_MERCHANT_COUNTRY = "subMerchantCountry";
    private String subMerchantCountry;
    public static final String JSON_PROPERTY_SUB_MERCHANT_I_D = "subMerchantID";
    private String subMerchantID;
    public static final String JSON_PROPERTY_SUB_MERCHANT_NAME = "subMerchantName";
    private String subMerchantName;
    public static final String JSON_PROPERTY_SUB_MERCHANT_POSTAL_CODE = "subMerchantPostalCode";
    private String subMerchantPostalCode;
    public static final String JSON_PROPERTY_SUB_MERCHANT_STATE = "subMerchantState";
    private String subMerchantState;
    public static final String JSON_PROPERTY_SUB_MERCHANT_STREET = "subMerchantStreet";
    private String subMerchantStreet;
    public static final String JSON_PROPERTY_SUB_MERCHANT_TAX_ID = "subMerchantTaxId";
    private String subMerchantTaxId;

    public AdditionalDataCommon requestedTestErrorResponseCode(String requestedTestErrorResponseCode) {
        this.requestedTestErrorResponseCode = requestedTestErrorResponseCode;
        return this;
    }

    @ApiModelProperty(value="Triggers test scenarios that allow to replicate certain communication errors.  Allowed values: * **NO_CONNECTION_AVAILABLE** \u2013 There wasn't a connection available to service the outgoing communication. This is a transient, retriable error since no messaging could be initiated to an issuing system (or third-party acquiring system). Therefore, the header Transient-Error: true is returned in the response. A subsequent request using the same idempotency key will be processed as if it was the first request. * **IOEXCEPTION_RECEIVED** \u2013 Something went wrong during transmission of the message or receiving the response. This is a classified as non-transient because the message could have been received by the issuing party and been acted upon. No transient error header is returned. If using idempotency, the (error) response is stored as the final result for the idempotency key. Subsequent messages with the same idempotency key not be processed beyond returning the stored response.")
    @JsonProperty(value="RequestedTestErrorResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestedTestErrorResponseCode() {
        return this.requestedTestErrorResponseCode;
    }

    @JsonProperty(value="RequestedTestErrorResponseCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestedTestErrorResponseCode(String requestedTestErrorResponseCode) {
        this.requestedTestErrorResponseCode = requestedTestErrorResponseCode;
    }

    public AdditionalDataCommon allowPartialAuth(String allowPartialAuth) {
        this.allowPartialAuth = allowPartialAuth;
        return this;
    }

    @ApiModelProperty(value="Set to true to authorise a part of the requested amount in case the cardholder does not have enough funds on their account.  If a payment was partially authorised, the response includes resultCode: PartiallyAuthorised and the authorised amount in additionalData.authorisedAmountValue. To enable this functionality, contact our Support Team.")
    @JsonProperty(value="allowPartialAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAllowPartialAuth() {
        return this.allowPartialAuth;
    }

    @JsonProperty(value="allowPartialAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowPartialAuth(String allowPartialAuth) {
        this.allowPartialAuth = allowPartialAuth;
    }

    public AdditionalDataCommon authorisationType(String authorisationType) {
        this.authorisationType = authorisationType;
        return this;
    }

    @ApiModelProperty(value="Flags a card payment request for either pre-authorisation or final authorisation. For more information, refer to [Authorisation types](https://docs.adyen.com/online-payments/adjust-authorisation#authorisation-types).  Allowed values: * **PreAuth** \u2013 flags the payment request to be handled as a pre-authorisation. * **FinalAuth** \u2013 flags the payment request to be handled as a final authorisation.")
    @JsonProperty(value="authorisationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorisationType() {
        return this.authorisationType;
    }

    @JsonProperty(value="authorisationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorisationType(String authorisationType) {
        this.authorisationType = authorisationType;
    }

    public AdditionalDataCommon autoRescue(String autoRescue) {
        this.autoRescue = autoRescue;
        return this;
    }

    @ApiModelProperty(value="Set to **true** to enable [Auto Rescue](https://docs.adyen.com/online-payments/auto-rescue/) for a transaction. Use the `maxDaysToRescue` to specify a rescue window.")
    @JsonProperty(value="autoRescue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAutoRescue() {
        return this.autoRescue;
    }

    @JsonProperty(value="autoRescue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoRescue(String autoRescue) {
        this.autoRescue = autoRescue;
    }

    public AdditionalDataCommon customRoutingFlag(String customRoutingFlag) {
        this.customRoutingFlag = customRoutingFlag;
        return this;
    }

    @ApiModelProperty(value="Allows you to determine or override the acquirer account that should be used for the transaction.  If you need to process a payment with an acquirer different from a default one, you can set up a corresponding configuration on the Adyen payments platform. Then you can pass a custom routing flag in a payment request's additional data to target a specific acquirer.  To enable this functionality, contact [Support](https://www.adyen.help/hc/en-us/requests/new).")
    @JsonProperty(value="customRoutingFlag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomRoutingFlag() {
        return this.customRoutingFlag;
    }

    @JsonProperty(value="customRoutingFlag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomRoutingFlag(String customRoutingFlag) {
        this.customRoutingFlag = customRoutingFlag;
    }

    public AdditionalDataCommon industryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
        return this;
    }

    @ApiModelProperty(value="In case of [asynchronous authorisation adjustment](https://docs.adyen.com/online-payments/adjust-authorisation#adjust-authorisation), this field denotes why the additional payment is made.  Possible values:   * **NoShow**: An incremental charge is carried out because of a no-show for a guaranteed reservation.   * **DelayedCharge**: An incremental charge is carried out to process an additional payment after the original services have been rendered and the respective payment has been processed.")
    @JsonProperty(value="industryUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IndustryUsageEnum getIndustryUsage() {
        return this.industryUsage;
    }

    @JsonProperty(value="industryUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndustryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
    }

    public AdditionalDataCommon manualCapture(String manualCapture) {
        this.manualCapture = manualCapture;
        return this;
    }

    @ApiModelProperty(value="Set to **true** to require [manual capture](https://docs.adyen.com/online-payments/capture) for the transaction.")
    @JsonProperty(value="manualCapture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getManualCapture() {
        return this.manualCapture;
    }

    @JsonProperty(value="manualCapture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManualCapture(String manualCapture) {
        this.manualCapture = manualCapture;
    }

    public AdditionalDataCommon maxDaysToRescue(String maxDaysToRescue) {
        this.maxDaysToRescue = maxDaysToRescue;
        return this;
    }

    @ApiModelProperty(value="The rescue window for a transaction, in days, when `autoRescue` is set to **true**. You can specify a value between 1 and 48.  * For [cards](https://docs.adyen.com/online-payments/auto-rescue/cards/), the default is one calendar month.  * For [SEPA](https://docs.adyen.com/online-payments/auto-rescue/sepa/), the default is 42 days.")
    @JsonProperty(value="maxDaysToRescue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMaxDaysToRescue() {
        return this.maxDaysToRescue;
    }

    @JsonProperty(value="maxDaysToRescue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxDaysToRescue(String maxDaysToRescue) {
        this.maxDaysToRescue = maxDaysToRescue;
    }

    public AdditionalDataCommon networkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
        return this;
    }

    @ApiModelProperty(value="Allows you to link the transaction to the original or previous one in a subscription/card-on-file chain. This field is required for token-based transactions where Adyen does not tokenize the card.  Transaction identifier from card schemes, for example, Mastercard Trace ID or the Visa Transaction ID.  Submit the original transaction ID of the contract in your payment request if you are not tokenizing card details with Adyen and are making a merchant-initiated transaction (MIT) for subsequent charges.  Make sure you are sending `shopperInteraction` **ContAuth** and `recurringProcessingModel` **Subscription** or **UnscheduledCardOnFile** to ensure that the transaction is classified as MIT.")
    @JsonProperty(value="networkTxReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkTxReference() {
        return this.networkTxReference;
    }

    @JsonProperty(value="networkTxReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
    }

    public AdditionalDataCommon overwriteBrand(String overwriteBrand) {
        this.overwriteBrand = overwriteBrand;
        return this;
    }

    @ApiModelProperty(value="Boolean indicator that can be optionally used for performing debit transactions on combo cards (for example, combo cards in Brazil). This is not mandatory but we recommend that you set this to true if you want to use the `selectedBrand` value to specify how to process the transaction.")
    @JsonProperty(value="overwriteBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOverwriteBrand() {
        return this.overwriteBrand;
    }

    @JsonProperty(value="overwriteBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOverwriteBrand(String overwriteBrand) {
        this.overwriteBrand = overwriteBrand;
    }

    public AdditionalDataCommon subMerchantCity(String subMerchantCity) {
        this.subMerchantCity = subMerchantCity;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the city of the actual merchant's address. * Format: alpha-numeric. * Maximum length: 13 characters.")
    @JsonProperty(value="subMerchantCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubMerchantCity() {
        return this.subMerchantCity;
    }

    @JsonProperty(value="subMerchantCity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchantCity(String subMerchantCity) {
        this.subMerchantCity = subMerchantCity;
    }

    public AdditionalDataCommon subMerchantCountry(String subMerchantCountry) {
        this.subMerchantCountry = subMerchantCountry;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the three-letter country code of the actual merchant's address. * Format: alpha-numeric. * Fixed length: 3 characters.")
    @JsonProperty(value="subMerchantCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubMerchantCountry() {
        return this.subMerchantCountry;
    }

    @JsonProperty(value="subMerchantCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchantCountry(String subMerchantCountry) {
        this.subMerchantCountry = subMerchantCountry;
    }

    public AdditionalDataCommon subMerchantID(String subMerchantID) {
        this.subMerchantID = subMerchantID;
        return this;
    }

    @ApiModelProperty(value="This field contains an identifier of the actual merchant when a transaction is submitted via a payment facilitator. The payment facilitator must send in this unique ID.  A unique identifier per submerchant that is required if the transaction is performed by a registered payment facilitator. * Format: alpha-numeric. * Fixed length: 15 characters.")
    @JsonProperty(value="subMerchantID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubMerchantID() {
        return this.subMerchantID;
    }

    @JsonProperty(value="subMerchantID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchantID(String subMerchantID) {
        this.subMerchantID = subMerchantID;
    }

    public AdditionalDataCommon subMerchantName(String subMerchantName) {
        this.subMerchantName = subMerchantName;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the name of the actual merchant. * Format: alpha-numeric. * Maximum length: 22 characters.")
    @JsonProperty(value="subMerchantName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubMerchantName() {
        return this.subMerchantName;
    }

    @JsonProperty(value="subMerchantName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchantName(String subMerchantName) {
        this.subMerchantName = subMerchantName;
    }

    public AdditionalDataCommon subMerchantPostalCode(String subMerchantPostalCode) {
        this.subMerchantPostalCode = subMerchantPostalCode;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the postal code of the actual merchant's address. * Format: alpha-numeric. * Maximum length: 10 characters.")
    @JsonProperty(value="subMerchantPostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubMerchantPostalCode() {
        return this.subMerchantPostalCode;
    }

    @JsonProperty(value="subMerchantPostalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchantPostalCode(String subMerchantPostalCode) {
        this.subMerchantPostalCode = subMerchantPostalCode;
    }

    public AdditionalDataCommon subMerchantState(String subMerchantState) {
        this.subMerchantState = subMerchantState;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator, and if applicable to the country. This field must contain the state code of the actual merchant's address. * Format: alpha-numeric. * Maximum length: 3 characters.")
    @JsonProperty(value="subMerchantState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubMerchantState() {
        return this.subMerchantState;
    }

    @JsonProperty(value="subMerchantState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchantState(String subMerchantState) {
        this.subMerchantState = subMerchantState;
    }

    public AdditionalDataCommon subMerchantStreet(String subMerchantStreet) {
        this.subMerchantStreet = subMerchantStreet;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the street of the actual merchant's address. * Format: alpha-numeric. * Maximum length: 60 characters.")
    @JsonProperty(value="subMerchantStreet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubMerchantStreet() {
        return this.subMerchantStreet;
    }

    @JsonProperty(value="subMerchantStreet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchantStreet(String subMerchantStreet) {
        this.subMerchantStreet = subMerchantStreet;
    }

    public AdditionalDataCommon subMerchantTaxId(String subMerchantTaxId) {
        this.subMerchantTaxId = subMerchantTaxId;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the tax ID of the actual merchant. * Format: alpha-numeric. * Fixed length: 11 or 14 characters.")
    @JsonProperty(value="subMerchantTaxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubMerchantTaxId() {
        return this.subMerchantTaxId;
    }

    @JsonProperty(value="subMerchantTaxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchantTaxId(String subMerchantTaxId) {
        this.subMerchantTaxId = subMerchantTaxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalDataCommon additionalDataCommon = (AdditionalDataCommon)o;
        return Objects.equals(this.requestedTestErrorResponseCode, additionalDataCommon.requestedTestErrorResponseCode) && Objects.equals(this.allowPartialAuth, additionalDataCommon.allowPartialAuth) && Objects.equals(this.authorisationType, additionalDataCommon.authorisationType) && Objects.equals(this.autoRescue, additionalDataCommon.autoRescue) && Objects.equals(this.customRoutingFlag, additionalDataCommon.customRoutingFlag) && Objects.equals((Object)this.industryUsage, (Object)additionalDataCommon.industryUsage) && Objects.equals(this.manualCapture, additionalDataCommon.manualCapture) && Objects.equals(this.maxDaysToRescue, additionalDataCommon.maxDaysToRescue) && Objects.equals(this.networkTxReference, additionalDataCommon.networkTxReference) && Objects.equals(this.overwriteBrand, additionalDataCommon.overwriteBrand) && Objects.equals(this.subMerchantCity, additionalDataCommon.subMerchantCity) && Objects.equals(this.subMerchantCountry, additionalDataCommon.subMerchantCountry) && Objects.equals(this.subMerchantID, additionalDataCommon.subMerchantID) && Objects.equals(this.subMerchantName, additionalDataCommon.subMerchantName) && Objects.equals(this.subMerchantPostalCode, additionalDataCommon.subMerchantPostalCode) && Objects.equals(this.subMerchantState, additionalDataCommon.subMerchantState) && Objects.equals(this.subMerchantStreet, additionalDataCommon.subMerchantStreet) && Objects.equals(this.subMerchantTaxId, additionalDataCommon.subMerchantTaxId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestedTestErrorResponseCode, this.allowPartialAuth, this.authorisationType, this.autoRescue, this.customRoutingFlag, this.industryUsage, this.manualCapture, this.maxDaysToRescue, this.networkTxReference, this.overwriteBrand, this.subMerchantCity, this.subMerchantCountry, this.subMerchantID, this.subMerchantName, this.subMerchantPostalCode, this.subMerchantState, this.subMerchantStreet, this.subMerchantTaxId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalDataCommon {\n");
        sb.append("    requestedTestErrorResponseCode: ").append(this.toIndentedString(this.requestedTestErrorResponseCode)).append("\n");
        sb.append("    allowPartialAuth: ").append(this.toIndentedString(this.allowPartialAuth)).append("\n");
        sb.append("    authorisationType: ").append(this.toIndentedString(this.authorisationType)).append("\n");
        sb.append("    autoRescue: ").append(this.toIndentedString(this.autoRescue)).append("\n");
        sb.append("    customRoutingFlag: ").append(this.toIndentedString(this.customRoutingFlag)).append("\n");
        sb.append("    industryUsage: ").append(this.toIndentedString((Object)this.industryUsage)).append("\n");
        sb.append("    manualCapture: ").append(this.toIndentedString(this.manualCapture)).append("\n");
        sb.append("    maxDaysToRescue: ").append(this.toIndentedString(this.maxDaysToRescue)).append("\n");
        sb.append("    networkTxReference: ").append(this.toIndentedString(this.networkTxReference)).append("\n");
        sb.append("    overwriteBrand: ").append(this.toIndentedString(this.overwriteBrand)).append("\n");
        sb.append("    subMerchantCity: ").append(this.toIndentedString(this.subMerchantCity)).append("\n");
        sb.append("    subMerchantCountry: ").append(this.toIndentedString(this.subMerchantCountry)).append("\n");
        sb.append("    subMerchantID: ").append(this.toIndentedString(this.subMerchantID)).append("\n");
        sb.append("    subMerchantName: ").append(this.toIndentedString(this.subMerchantName)).append("\n");
        sb.append("    subMerchantPostalCode: ").append(this.toIndentedString(this.subMerchantPostalCode)).append("\n");
        sb.append("    subMerchantState: ").append(this.toIndentedString(this.subMerchantState)).append("\n");
        sb.append("    subMerchantStreet: ").append(this.toIndentedString(this.subMerchantStreet)).append("\n");
        sb.append("    subMerchantTaxId: ").append(this.toIndentedString(this.subMerchantTaxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AdditionalDataCommon fromJson(String jsonString) throws JsonProcessingException {
        return (AdditionalDataCommon)JSON.getMapper().readValue(jsonString, AdditionalDataCommon.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum IndustryUsageEnum {
        NOSHOW("NoShow"),
        DELAYEDCHARGE("DelayedCharge");

        private String value;

        private IndustryUsageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IndustryUsageEnum fromValue(String value) {
            for (IndustryUsageEnum b : IndustryUsageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

