/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.GenerateApiKeyResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class ApiKeyCompanyLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public ApiKeyCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public ApiKeyCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public GenerateApiKeyResponse generateNewApiKey(String companyId, String apiCredentialId) throws ApiException, IOException {
        return this.generateNewApiKey(companyId, apiCredentialId, null);
    }

    public GenerateApiKeyResponse generateNewApiKey(String companyId, String apiCredentialId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (apiCredentialId == null) {
            throw new IllegalArgumentException("Please provide the apiCredentialId path parameter");
        }
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/apiCredentials/{apiCredentialId}/generateApiKey", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return GenerateApiKeyResponse.fromJson(jsonResult);
    }
}

