/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"annualTurnover", "balanceSheetTotal", "currencyOfFinancialData", "dateOfFinancialData", "employeeCount", "netAssets"})
public class FinancialReport {
    public static final String JSON_PROPERTY_ANNUAL_TURNOVER = "annualTurnover";
    private String annualTurnover;
    public static final String JSON_PROPERTY_BALANCE_SHEET_TOTAL = "balanceSheetTotal";
    private String balanceSheetTotal;
    public static final String JSON_PROPERTY_CURRENCY_OF_FINANCIAL_DATA = "currencyOfFinancialData";
    private String currencyOfFinancialData;
    public static final String JSON_PROPERTY_DATE_OF_FINANCIAL_DATA = "dateOfFinancialData";
    private String dateOfFinancialData;
    public static final String JSON_PROPERTY_EMPLOYEE_COUNT = "employeeCount";
    private String employeeCount;
    public static final String JSON_PROPERTY_NET_ASSETS = "netAssets";
    private String netAssets;

    public FinancialReport annualTurnover(String annualTurnover) {
        this.annualTurnover = annualTurnover;
        return this;
    }

    @ApiModelProperty(value="The annual turnover of the business.")
    @JsonProperty(value="annualTurnover")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnnualTurnover() {
        return this.annualTurnover;
    }

    @JsonProperty(value="annualTurnover")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnualTurnover(String annualTurnover) {
        this.annualTurnover = annualTurnover;
    }

    public FinancialReport balanceSheetTotal(String balanceSheetTotal) {
        this.balanceSheetTotal = balanceSheetTotal;
        return this;
    }

    @ApiModelProperty(value="The balance sheet total of the business.")
    @JsonProperty(value="balanceSheetTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceSheetTotal() {
        return this.balanceSheetTotal;
    }

    @JsonProperty(value="balanceSheetTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceSheetTotal(String balanceSheetTotal) {
        this.balanceSheetTotal = balanceSheetTotal;
    }

    public FinancialReport currencyOfFinancialData(String currencyOfFinancialData) {
        this.currencyOfFinancialData = currencyOfFinancialData;
        return this;
    }

    @ApiModelProperty(value="The currency used for the net assets and balance sheet total.")
    @JsonProperty(value="currencyOfFinancialData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyOfFinancialData() {
        return this.currencyOfFinancialData;
    }

    @JsonProperty(value="currencyOfFinancialData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencyOfFinancialData(String currencyOfFinancialData) {
        this.currencyOfFinancialData = currencyOfFinancialData;
    }

    public FinancialReport dateOfFinancialData(String dateOfFinancialData) {
        this.dateOfFinancialData = dateOfFinancialData;
        return this;
    }

    @ApiModelProperty(value="The date the financial data were provided, in YYYY-MM-DD format.")
    @JsonProperty(value="dateOfFinancialData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDateOfFinancialData() {
        return this.dateOfFinancialData;
    }

    @JsonProperty(value="dateOfFinancialData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfFinancialData(String dateOfFinancialData) {
        this.dateOfFinancialData = dateOfFinancialData;
    }

    public FinancialReport employeeCount(String employeeCount) {
        this.employeeCount = employeeCount;
        return this;
    }

    @ApiModelProperty(value="The number of employees of the business.")
    @JsonProperty(value="employeeCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmployeeCount() {
        return this.employeeCount;
    }

    @JsonProperty(value="employeeCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmployeeCount(String employeeCount) {
        this.employeeCount = employeeCount;
    }

    public FinancialReport netAssets(String netAssets) {
        this.netAssets = netAssets;
        return this;
    }

    @ApiModelProperty(value="The net assets of the business.")
    @JsonProperty(value="netAssets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetAssets() {
        return this.netAssets;
    }

    @JsonProperty(value="netAssets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetAssets(String netAssets) {
        this.netAssets = netAssets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinancialReport financialReport = (FinancialReport)o;
        return Objects.equals(this.annualTurnover, financialReport.annualTurnover) && Objects.equals(this.balanceSheetTotal, financialReport.balanceSheetTotal) && Objects.equals(this.currencyOfFinancialData, financialReport.currencyOfFinancialData) && Objects.equals(this.dateOfFinancialData, financialReport.dateOfFinancialData) && Objects.equals(this.employeeCount, financialReport.employeeCount) && Objects.equals(this.netAssets, financialReport.netAssets);
    }

    public int hashCode() {
        return Objects.hash(this.annualTurnover, this.balanceSheetTotal, this.currencyOfFinancialData, this.dateOfFinancialData, this.employeeCount, this.netAssets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FinancialReport {\n");
        sb.append("    annualTurnover: ").append(this.toIndentedString(this.annualTurnover)).append("\n");
        sb.append("    balanceSheetTotal: ").append(this.toIndentedString(this.balanceSheetTotal)).append("\n");
        sb.append("    currencyOfFinancialData: ").append(this.toIndentedString(this.currencyOfFinancialData)).append("\n");
        sb.append("    dateOfFinancialData: ").append(this.toIndentedString(this.dateOfFinancialData)).append("\n");
        sb.append("    employeeCount: ").append(this.toIndentedString(this.employeeCount)).append("\n");
        sb.append("    netAssets: ").append(this.toIndentedString(this.netAssets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FinancialReport fromJson(String jsonString) throws JsonProcessingException {
        return (FinancialReport)JSON.getMapper().readValue(jsonString, FinancialReport.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

