/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.httpclient;

import com.adyen.enums.Environment;
import com.adyen.terminal.security.TerminalCommonNameValidator;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class TerminalLocalAPIHostnameVerifier
implements HostnameVerifier {
    private final Environment environment;

    public TerminalLocalAPIHostnameVerifier(Environment environment) {
        this.environment = environment;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        try {
            if (session.getPeerCertificates() != null && session.getPeerCertificates().length > 0) {
                X509Certificate certificate = (X509Certificate)session.getPeerCertificates()[0];
                return TerminalCommonNameValidator.validateCertificate(certificate, this.environment);
            }
            return false;
        }
        catch (SSLPeerUnverifiedException e) {
            e.printStackTrace();
            return false;
        }
    }
}

