/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentMethodToStore;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantAccount", "paymentMethod", "recurringProcessingModel", "shopperEmail", "shopperIP", "shopperReference"})
public class StoredPaymentMethodRequest {
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private PaymentMethodToStore paymentMethod;
    public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
    private String shopperIP;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;

    public StoredPaymentMethodRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoredPaymentMethodRequest paymentMethod(PaymentMethodToStore paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentMethodToStore getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(PaymentMethodToStore paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public StoredPaymentMethodRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * `Subscription` \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public StoredPaymentMethodRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper's email address. We recommend that you provide this data, as it is used in velocity fraud checks.")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public StoredPaymentMethodRequest shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    @ApiModelProperty(value="The IP address of a shopper.")
    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperIP() {
        return this.shopperIP;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public StoredPaymentMethodRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the shopper (for example, user ID or account ID).")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredPaymentMethodRequest storedPaymentMethodRequest = (StoredPaymentMethodRequest)o;
        return Objects.equals(this.merchantAccount, storedPaymentMethodRequest.merchantAccount) && Objects.equals(this.paymentMethod, storedPaymentMethodRequest.paymentMethod) && Objects.equals((Object)this.recurringProcessingModel, (Object)storedPaymentMethodRequest.recurringProcessingModel) && Objects.equals(this.shopperEmail, storedPaymentMethodRequest.shopperEmail) && Objects.equals(this.shopperIP, storedPaymentMethodRequest.shopperIP) && Objects.equals(this.shopperReference, storedPaymentMethodRequest.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.merchantAccount, this.paymentMethod, this.recurringProcessingModel, this.shopperEmail, this.shopperIP, this.shopperReference});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredPaymentMethodRequest {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredPaymentMethodRequest fromJson(String jsonString) throws JsonProcessingException {
        return (StoredPaymentMethodRequest)JSON.getMapper().readValue(jsonString, StoredPaymentMethodRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

