/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.CardDetails;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.SubMerchant;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"IBAN", "billingAddress", "paymentMethod", "shopperEmail", "shopperName", "shopperReference", "storedPaymentMethodId", "subMerchant", "telephoneNumber", "walletIdentifier", "walletOwnerTaxId", "walletPurpose"})
public class FundRecipient {
    public static final String JSON_PROPERTY_I_B_A_N = "IBAN";
    private String IBAN;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private CardDetails paymentMethod;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;
    public static final String JSON_PROPERTY_SUB_MERCHANT = "subMerchant";
    private SubMerchant subMerchant;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    public static final String JSON_PROPERTY_WALLET_IDENTIFIER = "walletIdentifier";
    private String walletIdentifier;
    public static final String JSON_PROPERTY_WALLET_OWNER_TAX_ID = "walletOwnerTaxId";
    private String walletOwnerTaxId;
    public static final String JSON_PROPERTY_WALLET_PURPOSE = "walletPurpose";
    private WalletPurposeEnum walletPurpose;

    public FundRecipient IBAN(String IBAN) {
        this.IBAN = IBAN;
        return this;
    }

    @ApiModelProperty(value="The IBAN of the bank account where the funds are being transferred to.")
    @JsonProperty(value="IBAN")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIBAN() {
        return this.IBAN;
    }

    @JsonProperty(value="IBAN")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIBAN(String IBAN) {
        this.IBAN = IBAN;
    }

    public FundRecipient billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public FundRecipient paymentMethod(CardDetails paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardDetails getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(CardDetails paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public FundRecipient shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The email address of the shopper.")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public FundRecipient shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public FundRecipient shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public FundRecipient storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public FundRecipient subMerchant(SubMerchant subMerchant) {
        this.subMerchant = subMerchant;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="subMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubMerchant getSubMerchant() {
        return this.subMerchant;
    }

    @JsonProperty(value="subMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchant(SubMerchant subMerchant) {
        this.subMerchant = subMerchant;
    }

    public FundRecipient telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The telephone number of the shopper.")
    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public FundRecipient walletIdentifier(String walletIdentifier) {
        this.walletIdentifier = walletIdentifier;
        return this;
    }

    @ApiModelProperty(value="The unique identifier for the wallet the funds are being transferred to. You can use the shopper reference or any other identifier.")
    @JsonProperty(value="walletIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWalletIdentifier() {
        return this.walletIdentifier;
    }

    @JsonProperty(value="walletIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWalletIdentifier(String walletIdentifier) {
        this.walletIdentifier = walletIdentifier;
    }

    public FundRecipient walletOwnerTaxId(String walletOwnerTaxId) {
        this.walletOwnerTaxId = walletOwnerTaxId;
        return this;
    }

    @ApiModelProperty(value="The tax identifier of the person receiving the funds.")
    @JsonProperty(value="walletOwnerTaxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWalletOwnerTaxId() {
        return this.walletOwnerTaxId;
    }

    @JsonProperty(value="walletOwnerTaxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWalletOwnerTaxId(String walletOwnerTaxId) {
        this.walletOwnerTaxId = walletOwnerTaxId;
    }

    public FundRecipient walletPurpose(WalletPurposeEnum walletPurpose) {
        this.walletPurpose = walletPurpose;
        return this;
    }

    @ApiModelProperty(value="The purpose of a digital wallet transaction.")
    @JsonProperty(value="walletPurpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WalletPurposeEnum getWalletPurpose() {
        return this.walletPurpose;
    }

    @JsonProperty(value="walletPurpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWalletPurpose(WalletPurposeEnum walletPurpose) {
        this.walletPurpose = walletPurpose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundRecipient fundRecipient = (FundRecipient)o;
        return Objects.equals(this.IBAN, fundRecipient.IBAN) && Objects.equals(this.billingAddress, fundRecipient.billingAddress) && Objects.equals(this.paymentMethod, fundRecipient.paymentMethod) && Objects.equals(this.shopperEmail, fundRecipient.shopperEmail) && Objects.equals(this.shopperName, fundRecipient.shopperName) && Objects.equals(this.shopperReference, fundRecipient.shopperReference) && Objects.equals(this.storedPaymentMethodId, fundRecipient.storedPaymentMethodId) && Objects.equals(this.subMerchant, fundRecipient.subMerchant) && Objects.equals(this.telephoneNumber, fundRecipient.telephoneNumber) && Objects.equals(this.walletIdentifier, fundRecipient.walletIdentifier) && Objects.equals(this.walletOwnerTaxId, fundRecipient.walletOwnerTaxId) && Objects.equals((Object)this.walletPurpose, (Object)fundRecipient.walletPurpose);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.IBAN, this.billingAddress, this.paymentMethod, this.shopperEmail, this.shopperName, this.shopperReference, this.storedPaymentMethodId, this.subMerchant, this.telephoneNumber, this.walletIdentifier, this.walletOwnerTaxId, this.walletPurpose});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundRecipient {\n");
        sb.append("    IBAN: ").append(this.toIndentedString(this.IBAN)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    subMerchant: ").append(this.toIndentedString(this.subMerchant)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    walletIdentifier: ").append(this.toIndentedString(this.walletIdentifier)).append("\n");
        sb.append("    walletOwnerTaxId: ").append(this.toIndentedString(this.walletOwnerTaxId)).append("\n");
        sb.append("    walletPurpose: ").append(this.toIndentedString((Object)this.walletPurpose)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FundRecipient fromJson(String jsonString) throws JsonProcessingException {
        return (FundRecipient)JSON.getMapper().readValue(jsonString, FundRecipient.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum WalletPurposeEnum {
        IDENTIFIEDBOLETO("identifiedBoleto"),
        TRANSFERDIFFERENTWALLET("transferDifferentWallet"),
        TRANSFEROWNWALLET("transferOwnWallet"),
        TRANSFERSAMEWALLET("transferSameWallet"),
        UNIDENTIFIEDBOLETO("unidentifiedBoleto");

        private String value;

        private WalletPurposeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WalletPurposeEnum fromValue(String value) {
            for (WalletPurposeEnum b : WalletPurposeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

