/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posmobile;

import com.adyen.model.posmobile.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "installationId", "merchantAccount", "sdkData", "store"})
public class CreateSessionResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INSTALLATION_ID = "installationId";
    private String installationId;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_SDK_DATA = "sdkData";
    private String sdkData;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;

    public CreateSessionResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the session.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public CreateSessionResponse installationId(String installationId) {
        this.installationId = installationId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the SDK installation. If you create the [Terminal API](https://docs.adyen.com/point-of-sale/design-your-integration/terminal-api/) transaction request on your backend, use this as the `POIID` in the `MessageHeader` of the request.")
    @JsonProperty(value="installationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInstallationId() {
        return this.installationId;
    }

    @JsonProperty(value="installationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    public CreateSessionResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of your merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CreateSessionResponse sdkData(String sdkData) {
        this.sdkData = sdkData;
        return this;
    }

    @ApiModelProperty(value="The data that the SDK uses to authenticate responses from the Adyen payments platform. Pass this value to your POS app.")
    @JsonProperty(value="sdkData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSdkData() {
        return this.sdkData;
    }

    @JsonProperty(value="sdkData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSdkData(String sdkData) {
        this.sdkData = sdkData;
    }

    public CreateSessionResponse store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the store that you want to process transactions for.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSessionResponse createSessionResponse = (CreateSessionResponse)o;
        return Objects.equals(this.id, createSessionResponse.id) && Objects.equals(this.installationId, createSessionResponse.installationId) && Objects.equals(this.merchantAccount, createSessionResponse.merchantAccount) && Objects.equals(this.sdkData, createSessionResponse.sdkData) && Objects.equals(this.store, createSessionResponse.store);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.installationId, this.merchantAccount, this.sdkData, this.store);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSessionResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    installationId: ").append(this.toIndentedString(this.installationId)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    sdkData: ").append(this.toIndentedString(this.sdkData)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateSessionResponse fromJson(String jsonString) throws JsonProcessingException {
        return (CreateSessionResponse)JSON.getMapper().readValue(jsonString, CreateSessionResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

