/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"city", "line1", "line2", "line3", "postalCode", "stateOrProvince"})
public class UpdatableAddress {
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_LINE1 = "line1";
    private String line1;
    public static final String JSON_PROPERTY_LINE2 = "line2";
    private String line2;
    public static final String JSON_PROPERTY_LINE3 = "line3";
    private String line3;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_STATE_OR_PROVINCE = "stateOrProvince";
    private String stateOrProvince;

    public UpdatableAddress city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The name of the city.")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public UpdatableAddress line1(String line1) {
        this.line1 = line1;
        return this;
    }

    @ApiModelProperty(value="The street address.")
    @JsonProperty(value="line1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLine1() {
        return this.line1;
    }

    @JsonProperty(value="line1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public UpdatableAddress line2(String line2) {
        this.line2 = line2;
        return this;
    }

    @ApiModelProperty(value="Second address line.")
    @JsonProperty(value="line2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLine2() {
        return this.line2;
    }

    @JsonProperty(value="line2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public UpdatableAddress line3(String line3) {
        this.line3 = line3;
        return this;
    }

    @ApiModelProperty(value="Third address line.")
    @JsonProperty(value="line3")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLine3() {
        return this.line3;
    }

    @JsonProperty(value="line3")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLine3(String line3) {
        this.line3 = line3;
    }

    public UpdatableAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="The postal code.")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public UpdatableAddress stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @ApiModelProperty(value="The state or province code as defined in [ISO 3166-2](https://www.iso.org/standard/72483.html). For example, **ON** for Ontario, Canada.  Required for the following countries:  - Australia - Brazil - Canada - India - Mexico - New Zealand - United States")
    @JsonProperty(value="stateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    @JsonProperty(value="stateOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdatableAddress updatableAddress = (UpdatableAddress)o;
        return Objects.equals(this.city, updatableAddress.city) && Objects.equals(this.line1, updatableAddress.line1) && Objects.equals(this.line2, updatableAddress.line2) && Objects.equals(this.line3, updatableAddress.line3) && Objects.equals(this.postalCode, updatableAddress.postalCode) && Objects.equals(this.stateOrProvince, updatableAddress.stateOrProvince);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.line1, this.line2, this.line3, this.postalCode, this.stateOrProvince);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdatableAddress {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    line1: ").append(this.toIndentedString(this.line1)).append("\n");
        sb.append("    line2: ").append(this.toIndentedString(this.line2)).append("\n");
        sb.append("    line3: ").append(this.toIndentedString(this.line3)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdatableAddress fromJson(String jsonString) throws JsonProcessingException {
        return (UpdatableAddress)JSON.getMapper().readValue(jsonString, UpdatableAddress.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

