/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public final class CertificateUtil {
    private CertificateUtil() {
    }

    public static Certificate loadCertificate(String filePath) throws FileNotFoundException, CertificateException {
        return CertificateUtil.loadCertificate(new FileInputStream(filePath));
    }

    public static Certificate loadCertificate(InputStream inputStream) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return certificateFactory.generateCertificate(inputStream);
    }

    public static KeyStore loadKeyStore(String keyStorePath, String keyStoreType, String keyStorePassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        File file;
        if (keyStorePath == null || keyStoreType == null) {
            throw new IllegalArgumentException();
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        char[] password = null;
        if (keyStorePassword != null && !keyStorePassword.isEmpty()) {
            password = keyStorePassword.toCharArray();
        }
        if (!(file = new File(keyStorePath)).exists()) {
            throw new FileNotFoundException("Keystore file not found at path " + keyStorePath);
        }
        FileInputStream inputStream = new FileInputStream(file);
        keyStore.load(inputStream, password);
        inputStream.close();
        return keyStore;
    }
}

