/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.MinorUnitsMonetaryValue;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"chipFloorLimit", "offlineSwipeLimits"})
public class OfflineProcessing {
    public static final String JSON_PROPERTY_CHIP_FLOOR_LIMIT = "chipFloorLimit";
    private Integer chipFloorLimit;
    public static final String JSON_PROPERTY_OFFLINE_SWIPE_LIMITS = "offlineSwipeLimits";
    private List<MinorUnitsMonetaryValue> offlineSwipeLimits = null;

    public OfflineProcessing chipFloorLimit(Integer chipFloorLimit) {
        this.chipFloorLimit = chipFloorLimit;
        return this;
    }

    @ApiModelProperty(value="The maximum offline transaction amount for chip cards, in the processing currency and specified in [minor units](https://docs.adyen.com/development-resources/currency-codes).")
    @JsonProperty(value="chipFloorLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChipFloorLimit() {
        return this.chipFloorLimit;
    }

    @JsonProperty(value="chipFloorLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChipFloorLimit(Integer chipFloorLimit) {
        this.chipFloorLimit = chipFloorLimit;
    }

    public OfflineProcessing offlineSwipeLimits(List<MinorUnitsMonetaryValue> offlineSwipeLimits) {
        this.offlineSwipeLimits = offlineSwipeLimits;
        return this;
    }

    public OfflineProcessing addOfflineSwipeLimitsItem(MinorUnitsMonetaryValue offlineSwipeLimitsItem) {
        if (this.offlineSwipeLimits == null) {
            this.offlineSwipeLimits = new ArrayList<MinorUnitsMonetaryValue>();
        }
        this.offlineSwipeLimits.add(offlineSwipeLimitsItem);
        return this;
    }

    @ApiModelProperty(value="The maximum offline transaction amount for swiped cards, in the specified currency.")
    @JsonProperty(value="offlineSwipeLimits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MinorUnitsMonetaryValue> getOfflineSwipeLimits() {
        return this.offlineSwipeLimits;
    }

    @JsonProperty(value="offlineSwipeLimits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOfflineSwipeLimits(List<MinorUnitsMonetaryValue> offlineSwipeLimits) {
        this.offlineSwipeLimits = offlineSwipeLimits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfflineProcessing offlineProcessing = (OfflineProcessing)o;
        return Objects.equals(this.chipFloorLimit, offlineProcessing.chipFloorLimit) && Objects.equals(this.offlineSwipeLimits, offlineProcessing.offlineSwipeLimits);
    }

    public int hashCode() {
        return Objects.hash(this.chipFloorLimit, this.offlineSwipeLimits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfflineProcessing {\n");
        sb.append("    chipFloorLimit: ").append(this.toIndentedString(this.chipFloorLimit)).append("\n");
        sb.append("    offlineSwipeLimits: ").append(this.toIndentedString(this.offlineSwipeLimits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static OfflineProcessing fromJson(String jsonString) throws JsonProcessingException {
        return (OfflineProcessing)JSON.getMapper().readValue(jsonString, OfflineProcessing.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

