/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.RecurringDetail;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"paymentSession", "recurringDetails"})
public class PaymentSetupResponse {
    public static final String JSON_PROPERTY_PAYMENT_SESSION = "paymentSession";
    private String paymentSession;
    public static final String JSON_PROPERTY_RECURRING_DETAILS = "recurringDetails";
    @Deprecated
    private List<RecurringDetail> recurringDetails = null;

    public PaymentSetupResponse paymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
        return this;
    }

    @ApiModelProperty(value="The encoded payment session that you need to pass to the SDK.")
    @JsonProperty(value="paymentSession")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentSession() {
        return this.paymentSession;
    }

    @JsonProperty(value="paymentSession")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
    }

    @Deprecated
    public PaymentSetupResponse recurringDetails(List<RecurringDetail> recurringDetails) {
        this.recurringDetails = recurringDetails;
        return this;
    }

    public PaymentSetupResponse addRecurringDetailsItem(RecurringDetail recurringDetailsItem) {
        if (this.recurringDetails == null) {
            this.recurringDetails = new ArrayList<RecurringDetail>();
        }
        this.recurringDetails.add(recurringDetailsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The detailed list of stored payment details required to generate payment forms. Will be empty if oneClick is set to false in the request.")
    @JsonProperty(value="recurringDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RecurringDetail> getRecurringDetails() {
        return this.recurringDetails;
    }

    @Deprecated
    @JsonProperty(value="recurringDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetails(List<RecurringDetail> recurringDetails) {
        this.recurringDetails = recurringDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentSetupResponse paymentSetupResponse = (PaymentSetupResponse)o;
        return Objects.equals(this.paymentSession, paymentSetupResponse.paymentSession) && Objects.equals(this.recurringDetails, paymentSetupResponse.recurringDetails);
    }

    public int hashCode() {
        return Objects.hash(this.paymentSession, this.recurringDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentSetupResponse {\n");
        sb.append("    paymentSession: ").append(this.toIndentedString(this.paymentSession)).append("\n");
        sb.append("    recurringDetails: ").append(this.toIndentedString(this.recurringDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentSetupResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentSetupResponse)JSON.getMapper().readValue(jsonString, PaymentSetupResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

