/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"estimatedArrivalTime", "type"})
public class EstimationTrackingData {
    public static final String JSON_PROPERTY_ESTIMATED_ARRIVAL_TIME = "estimatedArrivalTime";
    private OffsetDateTime estimatedArrivalTime;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public EstimationTrackingData estimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The estimated time the beneficiary should have access to the funds.")
    @JsonProperty(value="estimatedArrivalTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEstimatedArrivalTime() {
        return this.estimatedArrivalTime;
    }

    @JsonProperty(value="estimatedArrivalTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEstimatedArrivalTime(OffsetDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
    }

    public EstimationTrackingData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of tracking event.   Possible values:   - **estimation**: the estimated date and time of when the funds will be credited has been determined.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EstimationTrackingData estimationTrackingData = (EstimationTrackingData)o;
        return Objects.equals(this.estimatedArrivalTime, estimationTrackingData.estimatedArrivalTime) && Objects.equals((Object)this.type, (Object)estimationTrackingData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.estimatedArrivalTime, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EstimationTrackingData {\n");
        sb.append("    estimatedArrivalTime: ").append(this.toIndentedString(this.estimatedArrivalTime)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static EstimationTrackingData fromJson(String jsonString) throws JsonProcessingException {
        return (EstimationTrackingData)JSON.getMapper().readValue(jsonString, EstimationTrackingData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ESTIMATION("estimation");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

