/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.ScheduleTerminalActionsRequestActionDetails;
import com.adyen.model.management.TerminalActionScheduleDetail;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"actionDetails", "items", "scheduledAt", "storeId", "terminalsWithErrors", "totalErrors", "totalScheduled"})
public class ScheduleTerminalActionsResponse {
    public static final String JSON_PROPERTY_ACTION_DETAILS = "actionDetails";
    private ScheduleTerminalActionsRequestActionDetails actionDetails;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<TerminalActionScheduleDetail> items = null;
    public static final String JSON_PROPERTY_SCHEDULED_AT = "scheduledAt";
    private String scheduledAt;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    private String storeId;
    public static final String JSON_PROPERTY_TERMINALS_WITH_ERRORS = "terminalsWithErrors";
    private Map<String, List<String>> terminalsWithErrors = null;
    public static final String JSON_PROPERTY_TOTAL_ERRORS = "totalErrors";
    private Integer totalErrors;
    public static final String JSON_PROPERTY_TOTAL_SCHEDULED = "totalScheduled";
    private Integer totalScheduled;

    public ScheduleTerminalActionsResponse actionDetails(ScheduleTerminalActionsRequestActionDetails actionDetails) {
        this.actionDetails = actionDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="actionDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScheduleTerminalActionsRequestActionDetails getActionDetails() {
        return this.actionDetails;
    }

    @JsonProperty(value="actionDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActionDetails(ScheduleTerminalActionsRequestActionDetails actionDetails) {
        this.actionDetails = actionDetails;
    }

    public ScheduleTerminalActionsResponse items(List<TerminalActionScheduleDetail> items) {
        this.items = items;
        return this;
    }

    public ScheduleTerminalActionsResponse addItemsItem(TerminalActionScheduleDetail itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<TerminalActionScheduleDetail>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="A list containing a terminal ID and an action ID for each terminal that the action was scheduled for.")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TerminalActionScheduleDetail> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItems(List<TerminalActionScheduleDetail> items) {
        this.items = items;
    }

    public ScheduleTerminalActionsResponse scheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the action should happen.  Format: [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339), but without the **Z** before the time offset. For example, **2021-11-15T12:16:21+0100**  The action is sent with the first [maintenance call](https://docs.adyen.com/point-of-sale/automating-terminal-management/terminal-actions-api#when-actions-take-effect) after the specified date and time in the time zone of the terminal.  An empty value causes the action to be sent as soon as possible: at the next maintenance call.")
    @JsonProperty(value="scheduledAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScheduledAt() {
        return this.scheduledAt;
    }

    @JsonProperty(value="scheduledAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public ScheduleTerminalActionsResponse storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the [store](https://docs.adyen.com/api-explorer/#/ManagementService/latest/get/stores). If present, all terminals in the `terminalIds` list must be assigned to this store.")
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public ScheduleTerminalActionsResponse terminalsWithErrors(Map<String, List<String>> terminalsWithErrors) {
        this.terminalsWithErrors = terminalsWithErrors;
        return this;
    }

    public ScheduleTerminalActionsResponse putTerminalsWithErrorsItem(String key, List<String> terminalsWithErrorsItem) {
        if (this.terminalsWithErrors == null) {
            this.terminalsWithErrors = new HashMap<String, List<String>>();
        }
        this.terminalsWithErrors.put(key, terminalsWithErrorsItem);
        return this;
    }

    @ApiModelProperty(value="The validation errors that occurred in the list of terminals, and for each error the IDs of the terminals that the error applies to.")
    @JsonProperty(value="terminalsWithErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, List<String>> getTerminalsWithErrors() {
        return this.terminalsWithErrors;
    }

    @JsonProperty(value="terminalsWithErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminalsWithErrors(Map<String, List<String>> terminalsWithErrors) {
        this.terminalsWithErrors = terminalsWithErrors;
    }

    public ScheduleTerminalActionsResponse totalErrors(Integer totalErrors) {
        this.totalErrors = totalErrors;
        return this;
    }

    @ApiModelProperty(value="The number of terminals for which scheduling the action failed.")
    @JsonProperty(value="totalErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalErrors() {
        return this.totalErrors;
    }

    @JsonProperty(value="totalErrors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalErrors(Integer totalErrors) {
        this.totalErrors = totalErrors;
    }

    public ScheduleTerminalActionsResponse totalScheduled(Integer totalScheduled) {
        this.totalScheduled = totalScheduled;
        return this;
    }

    @ApiModelProperty(value="The number of terminals for which the action was successfully scheduled. This doesn't mean the action has happened yet.")
    @JsonProperty(value="totalScheduled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalScheduled() {
        return this.totalScheduled;
    }

    @JsonProperty(value="totalScheduled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalScheduled(Integer totalScheduled) {
        this.totalScheduled = totalScheduled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleTerminalActionsResponse scheduleTerminalActionsResponse = (ScheduleTerminalActionsResponse)o;
        return Objects.equals(this.actionDetails, scheduleTerminalActionsResponse.actionDetails) && Objects.equals(this.items, scheduleTerminalActionsResponse.items) && Objects.equals(this.scheduledAt, scheduleTerminalActionsResponse.scheduledAt) && Objects.equals(this.storeId, scheduleTerminalActionsResponse.storeId) && Objects.equals(this.terminalsWithErrors, scheduleTerminalActionsResponse.terminalsWithErrors) && Objects.equals(this.totalErrors, scheduleTerminalActionsResponse.totalErrors) && Objects.equals(this.totalScheduled, scheduleTerminalActionsResponse.totalScheduled);
    }

    public int hashCode() {
        return Objects.hash(this.actionDetails, this.items, this.scheduledAt, this.storeId, this.terminalsWithErrors, this.totalErrors, this.totalScheduled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleTerminalActionsResponse {\n");
        sb.append("    actionDetails: ").append(this.toIndentedString(this.actionDetails)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    scheduledAt: ").append(this.toIndentedString(this.scheduledAt)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    terminalsWithErrors: ").append(this.toIndentedString(this.terminalsWithErrors)).append("\n");
        sb.append("    totalErrors: ").append(this.toIndentedString(this.totalErrors)).append("\n");
        sb.append("    totalScheduled: ").append(this.toIndentedString(this.totalScheduled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ScheduleTerminalActionsResponse fromJson(String jsonString) throws JsonProcessingException {
        return (ScheduleTerminalActionsResponse)JSON.getMapper().readValue(jsonString, ScheduleTerminalActionsResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

