/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.DelegatedAuthenticationData;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"paymentInstrumentId", "strongCustomerAuthentication"})
public class RegisterSCARequest {
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;
    public static final String JSON_PROPERTY_STRONG_CUSTOMER_AUTHENTICATION = "strongCustomerAuthentication";
    private DelegatedAuthenticationData strongCustomerAuthentication;

    public RegisterSCARequest paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the payment instrument for which you are registering the SCA device.")
    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public RegisterSCARequest strongCustomerAuthentication(DelegatedAuthenticationData strongCustomerAuthentication) {
        this.strongCustomerAuthentication = strongCustomerAuthentication;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="strongCustomerAuthentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DelegatedAuthenticationData getStrongCustomerAuthentication() {
        return this.strongCustomerAuthentication;
    }

    @JsonProperty(value="strongCustomerAuthentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStrongCustomerAuthentication(DelegatedAuthenticationData strongCustomerAuthentication) {
        this.strongCustomerAuthentication = strongCustomerAuthentication;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterSCARequest registerSCARequest = (RegisterSCARequest)o;
        return Objects.equals(this.paymentInstrumentId, registerSCARequest.paymentInstrumentId) && Objects.equals(this.strongCustomerAuthentication, registerSCARequest.strongCustomerAuthentication);
    }

    public int hashCode() {
        return Objects.hash(this.paymentInstrumentId, this.strongCustomerAuthentication);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegisterSCARequest {\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    strongCustomerAuthentication: ").append(this.toIndentedString(this.strongCustomerAuthentication)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static RegisterSCARequest fromJson(String jsonString) throws JsonProcessingException {
        return (RegisterSCARequest)JSON.getMapper().readValue(jsonString, RegisterSCARequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

