/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayconfiguration;

import com.adyen.model.marketpayconfiguration.JSON;
import com.adyen.model.marketpayconfiguration.NotificationEventConfiguration;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"active", "apiVersion", "description", "eventConfigs", "hmacSignatureKey", "notificationId", "notifyPassword", "notifyURL", "notifyUsername", "sslProtocol"})
public class NotificationConfigurationDetails {
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private Integer apiVersion;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EVENT_CONFIGS = "eventConfigs";
    private List<NotificationEventConfiguration> eventConfigs = null;
    public static final String JSON_PROPERTY_HMAC_SIGNATURE_KEY = "hmacSignatureKey";
    private String hmacSignatureKey;
    public static final String JSON_PROPERTY_NOTIFICATION_ID = "notificationId";
    private Long notificationId;
    public static final String JSON_PROPERTY_NOTIFY_PASSWORD = "notifyPassword";
    private String notifyPassword;
    public static final String JSON_PROPERTY_NOTIFY_U_R_L = "notifyURL";
    private String notifyURL;
    public static final String JSON_PROPERTY_NOTIFY_USERNAME = "notifyUsername";
    private String notifyUsername;
    public static final String JSON_PROPERTY_SSL_PROTOCOL = "sslProtocol";
    private SslProtocolEnum sslProtocol;

    public NotificationConfigurationDetails active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the notification subscription is active.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public NotificationConfigurationDetails apiVersion(Integer apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="The version of the notification to which you are subscribing. To make sure that your integration can properly process the notification, subscribe to the same version as the API that you're using.")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApiVersion(Integer apiVersion) {
        this.apiVersion = apiVersion;
    }

    public NotificationConfigurationDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the notification subscription configuration.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public NotificationConfigurationDetails eventConfigs(List<NotificationEventConfiguration> eventConfigs) {
        this.eventConfigs = eventConfigs;
        return this;
    }

    public NotificationConfigurationDetails addEventConfigsItem(NotificationEventConfiguration eventConfigsItem) {
        if (this.eventConfigs == null) {
            this.eventConfigs = new ArrayList<NotificationEventConfiguration>();
        }
        this.eventConfigs.add(eventConfigsItem);
        return this;
    }

    @ApiModelProperty(value="Contains objects that define event types and their subscription settings.")
    @JsonProperty(value="eventConfigs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NotificationEventConfiguration> getEventConfigs() {
        return this.eventConfigs;
    }

    @JsonProperty(value="eventConfigs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventConfigs(List<NotificationEventConfiguration> eventConfigs) {
        this.eventConfigs = eventConfigs;
    }

    public NotificationConfigurationDetails hmacSignatureKey(String hmacSignatureKey) {
        this.hmacSignatureKey = hmacSignatureKey;
        return this;
    }

    @ApiModelProperty(value="A string with which to salt the notification(s) before hashing. If this field is provided, a hash value will be included under the notification header `HmacSignature` and the hash protocol will be included under the notification header `Protocol`. A notification body along with its `hmacSignatureKey` and `Protocol` can be used to calculate a hash value; matching this hash value with the `HmacSignature` will ensure that the notification body has not been tampered with or corrupted.  >Must be a 32-byte hex-encoded string (i.e. a string containing 64 hexadecimal characters; e.g. \"b0ea55c2fe60d4d1d605e9c385e0e7f7e6cafbb939ce07010f31a327a0871f27\").  The omission of this field will preclude the provision of the `HmacSignature` and `Protocol` headers in notification(s).")
    @JsonProperty(value="hmacSignatureKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHmacSignatureKey() {
        return this.hmacSignatureKey;
    }

    @JsonProperty(value="hmacSignatureKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHmacSignatureKey(String hmacSignatureKey) {
        this.hmacSignatureKey = hmacSignatureKey;
    }

    public NotificationConfigurationDetails notificationId(Long notificationId) {
        this.notificationId = notificationId;
        return this;
    }

    @ApiModelProperty(value="Adyen-generated ID for the entry, returned in the response when you create a notification configuration. Required when updating an existing configuration using [`/updateNotificationConfiguration`](https://docs.adyen.com/api-explorer/#/NotificationConfigurationService/latest/post/updateNotificationConfiguration).")
    @JsonProperty(value="notificationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNotificationId() {
        return this.notificationId;
    }

    @JsonProperty(value="notificationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public NotificationConfigurationDetails notifyPassword(String notifyPassword) {
        this.notifyPassword = notifyPassword;
        return this;
    }

    @ApiModelProperty(value="The password to use when accessing the notifyURL with the specified username.")
    @JsonProperty(value="notifyPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotifyPassword() {
        return this.notifyPassword;
    }

    @JsonProperty(value="notifyPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyPassword(String notifyPassword) {
        this.notifyPassword = notifyPassword;
    }

    public NotificationConfigurationDetails notifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
        return this;
    }

    @ApiModelProperty(value="The URL to which the notifications are to be sent.")
    @JsonProperty(value="notifyURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotifyURL() {
        return this.notifyURL;
    }

    @JsonProperty(value="notifyURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    public NotificationConfigurationDetails notifyUsername(String notifyUsername) {
        this.notifyUsername = notifyUsername;
        return this;
    }

    @ApiModelProperty(value="The username to use when accessing the notifyURL.")
    @JsonProperty(value="notifyUsername")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotifyUsername() {
        return this.notifyUsername;
    }

    @JsonProperty(value="notifyUsername")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyUsername(String notifyUsername) {
        this.notifyUsername = notifyUsername;
    }

    public NotificationConfigurationDetails sslProtocol(SslProtocolEnum sslProtocol) {
        this.sslProtocol = sslProtocol;
        return this;
    }

    @ApiModelProperty(value="The SSL protocol employed by the endpoint. >Permitted values: `TLSv12`, `TLSv13`.")
    @JsonProperty(value="sslProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SslProtocolEnum getSslProtocol() {
        return this.sslProtocol;
    }

    @JsonProperty(value="sslProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSslProtocol(SslProtocolEnum sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationConfigurationDetails notificationConfigurationDetails = (NotificationConfigurationDetails)o;
        return Objects.equals(this.active, notificationConfigurationDetails.active) && Objects.equals(this.apiVersion, notificationConfigurationDetails.apiVersion) && Objects.equals(this.description, notificationConfigurationDetails.description) && Objects.equals(this.eventConfigs, notificationConfigurationDetails.eventConfigs) && Objects.equals(this.hmacSignatureKey, notificationConfigurationDetails.hmacSignatureKey) && Objects.equals(this.notificationId, notificationConfigurationDetails.notificationId) && Objects.equals(this.notifyPassword, notificationConfigurationDetails.notifyPassword) && Objects.equals(this.notifyURL, notificationConfigurationDetails.notifyURL) && Objects.equals(this.notifyUsername, notificationConfigurationDetails.notifyUsername) && Objects.equals((Object)this.sslProtocol, (Object)notificationConfigurationDetails.sslProtocol);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.active, this.apiVersion, this.description, this.eventConfigs, this.hmacSignatureKey, this.notificationId, this.notifyPassword, this.notifyURL, this.notifyUsername, this.sslProtocol});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationConfigurationDetails {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    eventConfigs: ").append(this.toIndentedString(this.eventConfigs)).append("\n");
        sb.append("    hmacSignatureKey: ").append(this.toIndentedString(this.hmacSignatureKey)).append("\n");
        sb.append("    notificationId: ").append(this.toIndentedString(this.notificationId)).append("\n");
        sb.append("    notifyPassword: ").append(this.toIndentedString(this.notifyPassword)).append("\n");
        sb.append("    notifyURL: ").append(this.toIndentedString(this.notifyURL)).append("\n");
        sb.append("    notifyUsername: ").append(this.toIndentedString(this.notifyUsername)).append("\n");
        sb.append("    sslProtocol: ").append(this.toIndentedString((Object)this.sslProtocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static NotificationConfigurationDetails fromJson(String jsonString) throws JsonProcessingException {
        return (NotificationConfigurationDetails)JSON.getMapper().readValue(jsonString, NotificationConfigurationDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum SslProtocolEnum {
        TLSV12("TLSv12"),
        TLSV13("TLSv13");

        private String value;

        private SslProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SslProtocolEnum fromValue(String value) {
            for (SslProtocolEnum b : SslProtocolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

