/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.PinChangeRequest;
import com.adyen.model.balanceplatform.PinChangeResponse;
import com.adyen.model.balanceplatform.PublicKeyResponse;
import com.adyen.model.balanceplatform.RevealPinRequest;
import com.adyen.model.balanceplatform.RevealPinResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PinFunctionalityApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public PinFunctionalityApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public PinFunctionalityApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public PinChangeResponse changePin(PinChangeRequest pinChangeRequest) throws ApiException, IOException {
        return this.changePin(pinChangeRequest, null);
    }

    public PinChangeResponse changePin(PinChangeRequest pinChangeRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = pinChangeRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/pins/change", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PinChangeResponse.fromJson(jsonResult);
    }

    public PublicKeyResponse getRsaPublickey() throws ApiException, IOException {
        return this.getRsaPublickey(null, null, null);
    }

    public PublicKeyResponse getRsaPublickey(String purpose, String format, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (purpose != null) {
            queryParams.put("purpose", purpose);
        }
        if (format != null) {
            queryParams.put("format", format);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/pins/publicKey", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return PublicKeyResponse.fromJson(jsonResult);
    }

    public RevealPinResponse revealPin(RevealPinRequest revealPinRequest) throws ApiException, IOException {
        return this.revealPin(revealPinRequest, null);
    }

    public RevealPinResponse revealPin(RevealPinRequest revealPinRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = revealPinRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/pins/reveal", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return RevealPinResponse.fromJson(jsonResult);
    }
}

