/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"encryptedKey", "paymentInstrumentId"})
public class RevealPinRequest {
    public static final String JSON_PROPERTY_ENCRYPTED_KEY = "encryptedKey";
    private String encryptedKey;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;

    public RevealPinRequest encryptedKey(String encryptedKey) {
        this.encryptedKey = encryptedKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The symmetric session key that you encrypted with the [public key](https://docs.adyen.com/api-explorer/balanceplatform/2/get/publicKey) that you received from Adyen.")
    @JsonProperty(value="encryptedKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    @JsonProperty(value="encryptedKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptedKey(String encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public RevealPinRequest paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the payment instrument, which is the card for which you are managing the PIN.")
    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevealPinRequest revealPinRequest = (RevealPinRequest)o;
        return Objects.equals(this.encryptedKey, revealPinRequest.encryptedKey) && Objects.equals(this.paymentInstrumentId, revealPinRequest.paymentInstrumentId);
    }

    public int hashCode() {
        return Objects.hash(this.encryptedKey, this.paymentInstrumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RevealPinRequest {\n");
        sb.append("    encryptedKey: ").append(this.toIndentedString(this.encryptedKey)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static RevealPinRequest fromJson(String jsonString) throws JsonProcessingException {
        return (RevealPinRequest)JSON.getMapper().readValue(jsonString, RevealPinRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

