/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.model.InvalidField;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"invalidFields", "additionalData", "errorCode", "errorType", "message", "pspReference", "status"})
public class ApiError {
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<InvalidField> invalidFields = null;
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private String errorCode;
    public static final String JSON_PROPERTY_ERROR_TYPE = "errorType";
    private String errorType;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private Integer status;

    public ApiError invalidFields(List<InvalidField> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public ApiError addInvalidFieldsItem(InvalidField invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<InvalidField>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Detailed explanation of each validation error, when applicable.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InvalidField> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<InvalidField> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public ApiError additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public ApiError putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="Contains additional information about the payment. Some data fields are included only if you select them first. Go to **Customer Area** > **Developers** > **Additional data**.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public ApiError errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(value="The error code mapped to the error message.")
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public ApiError errorType(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @ApiModelProperty(value="The category of the error.")
    @JsonProperty(value="errorType")
    @JsonAlias(value={"type"})
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorType() {
        return this.errorType;
    }

    @JsonProperty(value="errorType")
    @JsonAlias(value={"type"})
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public ApiError message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="A short explanation of the issue.")
    @JsonProperty(value="message")
    @JsonAlias(value={"detail"})
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonAlias(value={"detail"})
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public ApiError pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The PSP reference of the payment.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public ApiError status(Integer status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The HTTP response status.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiError apiError = (ApiError)o;
        return Objects.equals(this.additionalData, apiError.additionalData) && Objects.equals(this.errorCode, apiError.errorCode) && Objects.equals(this.errorType, apiError.errorType) && Objects.equals(this.message, apiError.message) && Objects.equals(this.pspReference, apiError.pspReference) && Objects.equals(this.status, apiError.status);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.errorCode, this.errorType, this.message, this.pspReference, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceError {\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorType: ").append(this.toIndentedString(this.errorType)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ApiError fromJson(String jsonString) throws JsonProcessingException {
        if (jsonString == null) {
            return null;
        }
        return (ApiError)JSON.getMapper().readValue(jsonString, ApiError.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

