/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"balanceAccountId", "virtualAccountCode"})
public class MigratedAccounts {
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_VIRTUAL_ACCOUNT_CODE = "virtualAccountCode";
    private String virtualAccountCode;

    public MigratedAccounts balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the account of the migrated account holder in the balance platform.")
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public MigratedAccounts virtualAccountCode(String virtualAccountCode) {
        this.virtualAccountCode = virtualAccountCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the account of the migrated account holder in the classic integration.")
    @JsonProperty(value="virtualAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVirtualAccountCode() {
        return this.virtualAccountCode;
    }

    @JsonProperty(value="virtualAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVirtualAccountCode(String virtualAccountCode) {
        this.virtualAccountCode = virtualAccountCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigratedAccounts migratedAccounts = (MigratedAccounts)o;
        return Objects.equals(this.balanceAccountId, migratedAccounts.balanceAccountId) && Objects.equals(this.virtualAccountCode, migratedAccounts.virtualAccountCode);
    }

    public int hashCode() {
        return Objects.hash(this.balanceAccountId, this.virtualAccountCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigratedAccounts {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    virtualAccountCode: ").append(this.toIndentedString(this.virtualAccountCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MigratedAccounts fromJson(String jsonString) throws JsonProcessingException {
        return (MigratedAccounts)JSON.getMapper().readValue(jsonString, MigratedAccounts.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

