/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.EncryptedOrderData;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "allowedPaymentMethods", "amount", "blockedPaymentMethods", "channel", "countryCode", "merchantAccount", "order", "shopperLocale", "shopperReference", "splitCardFundingSources", "store", "storeFiltrationMode"})
public class PaymentMethodsRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_ALLOWED_PAYMENT_METHODS = "allowedPaymentMethods";
    private List<String> allowedPaymentMethods = null;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BLOCKED_PAYMENT_METHODS = "blockedPaymentMethods";
    private List<String> blockedPaymentMethods = null;
    public static final String JSON_PROPERTY_CHANNEL = "channel";
    private ChannelEnum channel;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_ORDER = "order";
    private EncryptedOrderData order;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES = "splitCardFundingSources";
    private Boolean splitCardFundingSources;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_STORE_FILTRATION_MODE = "storeFiltrationMode";
    private StoreFiltrationModeEnum storeFiltrationMode;

    public PaymentMethodsRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentMethodsRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentMethodsRequest allowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
        return this;
    }

    public PaymentMethodsRequest addAllowedPaymentMethodsItem(String allowedPaymentMethodsItem) {
        if (this.allowedPaymentMethods == null) {
            this.allowedPaymentMethods = new ArrayList<String>();
        }
        this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"allowedPaymentMethods\":[\"ideal\",\"giropay\"]`")
    @JsonProperty(value="allowedPaymentMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAllowedPaymentMethods() {
        return this.allowedPaymentMethods;
    }

    @JsonProperty(value="allowedPaymentMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
    }

    public PaymentMethodsRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentMethodsRequest blockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
        return this;
    }

    public PaymentMethodsRequest addBlockedPaymentMethodsItem(String blockedPaymentMethodsItem) {
        if (this.blockedPaymentMethods == null) {
            this.blockedPaymentMethods = new ArrayList<String>();
        }
        this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"blockedPaymentMethods\":[\"ideal\",\"giropay\"]`")
    @JsonProperty(value="blockedPaymentMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBlockedPaymentMethods() {
        return this.blockedPaymentMethods;
    }

    @JsonProperty(value="blockedPaymentMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
    }

    public PaymentMethodsRequest channel(ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(value="The platform where a payment transaction takes place. This field can be used for filtering out payment methods that are only available on specific platforms. Possible values: * iOS * Android * Web")
    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChannelEnum getChannel() {
        return this.channel;
    }

    @JsonProperty(value="channel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public PaymentMethodsRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The shopper's country code.")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentMethodsRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentMethodsRequest order(EncryptedOrderData order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EncryptedOrderData getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(EncryptedOrderData order) {
        this.order = order;
    }

    public PaymentMethodsRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The combination of a language code and a country code to specify the language to be used in the payment.")
    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentMethodsRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public PaymentMethodsRequest splitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
        return this;
    }

    @ApiModelProperty(value="Boolean value indicating whether the card payment method should be split into separate debit and credit options.")
    @JsonProperty(value="splitCardFundingSources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSplitCardFundingSources() {
        return this.splitCardFundingSources;
    }

    @JsonProperty(value="splitCardFundingSources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
    }

    public PaymentMethodsRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public PaymentMethodsRequest storeFiltrationMode(StoreFiltrationModeEnum storeFiltrationMode) {
        this.storeFiltrationMode = storeFiltrationMode;
        return this;
    }

    @ApiModelProperty(value="Specifies how payment methods should be filtered based on the 'store' parameter:   - 'exclusive': Only payment methods belonging to the specified 'store' are returned.   - 'inclusive': Payment methods from the 'store' and those not associated with any other store are returned.   - 'skipFilter': All payment methods are returned, regardless of store association.")
    @JsonProperty(value="storeFiltrationMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StoreFiltrationModeEnum getStoreFiltrationMode() {
        return this.storeFiltrationMode;
    }

    @JsonProperty(value="storeFiltrationMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreFiltrationMode(StoreFiltrationModeEnum storeFiltrationMode) {
        this.storeFiltrationMode = storeFiltrationMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodsRequest paymentMethodsRequest = (PaymentMethodsRequest)o;
        return Objects.equals(this.additionalData, paymentMethodsRequest.additionalData) && Objects.equals(this.allowedPaymentMethods, paymentMethodsRequest.allowedPaymentMethods) && Objects.equals(this.amount, paymentMethodsRequest.amount) && Objects.equals(this.blockedPaymentMethods, paymentMethodsRequest.blockedPaymentMethods) && Objects.equals((Object)this.channel, (Object)paymentMethodsRequest.channel) && Objects.equals(this.countryCode, paymentMethodsRequest.countryCode) && Objects.equals(this.merchantAccount, paymentMethodsRequest.merchantAccount) && Objects.equals(this.order, paymentMethodsRequest.order) && Objects.equals(this.shopperLocale, paymentMethodsRequest.shopperLocale) && Objects.equals(this.shopperReference, paymentMethodsRequest.shopperReference) && Objects.equals(this.splitCardFundingSources, paymentMethodsRequest.splitCardFundingSources) && Objects.equals(this.store, paymentMethodsRequest.store) && Objects.equals((Object)this.storeFiltrationMode, (Object)paymentMethodsRequest.storeFiltrationMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.allowedPaymentMethods, this.amount, this.blockedPaymentMethods, this.channel, this.countryCode, this.merchantAccount, this.order, this.shopperLocale, this.shopperReference, this.splitCardFundingSources, this.store, this.storeFiltrationMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodsRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    allowedPaymentMethods: ").append(this.toIndentedString(this.allowedPaymentMethods)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    blockedPaymentMethods: ").append(this.toIndentedString(this.blockedPaymentMethods)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    splitCardFundingSources: ").append(this.toIndentedString(this.splitCardFundingSources)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storeFiltrationMode: ").append(this.toIndentedString((Object)this.storeFiltrationMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentMethodsRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentMethodsRequest)JSON.getMapper().readValue(jsonString, PaymentMethodsRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StoreFiltrationModeEnum {
        EXCLUSIVE("exclusive"),
        INCLUSIVE("inclusive"),
        SKIPFILTER("skipFilter");

        private String value;

        private StoreFiltrationModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StoreFiltrationModeEnum fromValue(String value) {
            for (StoreFiltrationModeEnum b : StoreFiltrationModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChannelEnum {
        IOS("iOS"),
        ANDROID("Android"),
        WEB("Web");

        private String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelEnum fromValue(String value) {
            for (ChannelEnum b : ChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

