/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.CardOrder;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"cardOrders", "hasNext", "hasPrevious"})
public class PaginatedGetCardOrderResponse {
    public static final String JSON_PROPERTY_CARD_ORDERS = "cardOrders";
    private List<CardOrder> cardOrders = null;
    public static final String JSON_PROPERTY_HAS_NEXT = "hasNext";
    private Boolean hasNext;
    public static final String JSON_PROPERTY_HAS_PREVIOUS = "hasPrevious";
    private Boolean hasPrevious;

    public PaginatedGetCardOrderResponse cardOrders(List<CardOrder> cardOrders) {
        this.cardOrders = cardOrders;
        return this;
    }

    public PaginatedGetCardOrderResponse addCardOrdersItem(CardOrder cardOrdersItem) {
        if (this.cardOrders == null) {
            this.cardOrders = new ArrayList<CardOrder>();
        }
        this.cardOrders.add(cardOrdersItem);
        return this;
    }

    @ApiModelProperty(value="Contains objects with information about card orders.")
    @JsonProperty(value="cardOrders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CardOrder> getCardOrders() {
        return this.cardOrders;
    }

    @JsonProperty(value="cardOrders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardOrders(List<CardOrder> cardOrders) {
        this.cardOrders = cardOrders;
    }

    public PaginatedGetCardOrderResponse hasNext(Boolean hasNext) {
        this.hasNext = hasNext;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the next page.")
    @JsonProperty(value="hasNext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasNext() {
        return this.hasNext;
    }

    @JsonProperty(value="hasNext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasNext(Boolean hasNext) {
        this.hasNext = hasNext;
    }

    public PaginatedGetCardOrderResponse hasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether there are more items on the previous page.")
    @JsonProperty(value="hasPrevious")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasPrevious() {
        return this.hasPrevious;
    }

    @JsonProperty(value="hasPrevious")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPrevious(Boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginatedGetCardOrderResponse paginatedGetCardOrderResponse = (PaginatedGetCardOrderResponse)o;
        return Objects.equals(this.cardOrders, paginatedGetCardOrderResponse.cardOrders) && Objects.equals(this.hasNext, paginatedGetCardOrderResponse.hasNext) && Objects.equals(this.hasPrevious, paginatedGetCardOrderResponse.hasPrevious);
    }

    public int hashCode() {
        return Objects.hash(this.cardOrders, this.hasNext, this.hasPrevious);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaginatedGetCardOrderResponse {\n");
        sb.append("    cardOrders: ").append(this.toIndentedString(this.cardOrders)).append("\n");
        sb.append("    hasNext: ").append(this.toIndentedString(this.hasNext)).append("\n");
        sb.append("    hasPrevious: ").append(this.toIndentedString(this.hasPrevious)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaginatedGetCardOrderResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaginatedGetCardOrderResponse)JSON.getMapper().readValue(jsonString, PaginatedGetCardOrderResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

